/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.awt.EventQueue;
import java.util.Iterator;
import java.util.WeakHashMap;
import sun.plugin2.util.NativeLibLoader;

public final class MacOSXKeyHandler {
    public static final int NSAlphaShiftKeyMask = 65536;
    public static final int NSShiftKeyMask = 131072;
    public static final int NSControlKeyMask = 262144;
    public static final int NSAlternateKeyMask = 524288;
    public static final int NSCommandKeyMask = 0x100000;
    public static final int NSNumericPadKeyMask = 0x200000;
    public static final int NSHelpKeyMask = 0x400000;
    public static final int NSFunctionKeyMask = 0x800000;
    private static MacOSXKeyHandler instance;
    private static boolean debug;
    final WeakHashMap weakListeners = new WeakHashMap();

    private static native void registerEventTap();

    private static native boolean nativeIsKeyDown(long var0);

    public static MacOSXKeyHandler getInstance() {
        if (instance == null) {
            instance = new MacOSXKeyHandler();
        }
        return instance;
    }

    private MacOSXKeyHandler() {
        MacOSXKeyHandler.registerEventTap();
        Trace.println((String)"tap installed", (TraceLevel)TraceLevel.BASIC);
    }

    public void addListener(Listener listener) {
        this.weakListeners.put(listener, this);
    }

    public void removeListener(Listener listener) {
        this.weakListeners.remove(listener);
    }

    public boolean isKeyDown(long l) {
        if (debug) {
            Trace.println((String)"Testing for keyDown.", (TraceLevel)TraceLevel.UI);
        }
        return MacOSXKeyHandler.nativeIsKeyDown(l);
    }

    void notifyFlagsChanged(long l) {
        Iterator iterator = this.weakListeners.keySet().iterator();
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).keyChanged(l);
        }
    }

    static void notifyFlagsChangedFromNative(final long l) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MacOSXKeyHandler.getInstance().notifyFlagsChanged(l);
            }
        });
    }

    static {
        NativeLibLoader.load(new String[]{"npjp2"});
        debug = false;
    }

    public static interface Listener {
        public void keyChanged(long var1);
    }
}

