/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.applet2.Applet2;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.Timer;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.main.client.MacOSXKeyHandler;
import sun.plugin2.main.client.Plugin2EventListener;

class DetachedAppletController {
    private static final int TITLE_BAR_SIZE = 16;
    private JFrame frame;
    private final Window parentWindow;
    private final Plugin2Manager manager;
    private Boolean appletHasDragMethod;
    private Timer hideTimer;
    private Container oldContentPane;
    private final TransparentPanel TRANSPARENT_PANEL = new TransparentPanel();
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);

    DetachedAppletController(Window window, Plugin2Manager plugin2Manager) {
        this.parentWindow = window;
        this.manager = plugin2Manager;
    }

    private void setAlwaysOnTop(final Frame frame, final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                frame.setAlwaysOnTop(bl);
                return null;
            }
        });
    }

    private synchronized void createFrameIfNeeded() {
        if (this.frame != null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DetachedAppletController.this.createDetachFrame();
                return null;
            }
        });
    }

    void createDetachFrame() {
        this.frame = new DetachFrame();
        JRootPane jRootPane = this.frame.getRootPane();
        jRootPane.putClientProperty("Window.style", "small");
        jRootPane.putClientProperty("Window.hidesOnDeactivate", Boolean.FALSE);
        jRootPane.putClientProperty("Window.minimumSize", new Dimension(16, 16));
        jRootPane.putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (DetachedAppletController.this.frame != null) {
                    DetachedAppletController.this.frame.dispose();
                    DetachedAppletController.this.frame = null;
                }
            }
        });
        this.frame.setResizable(false);
        this.frame.setAlwaysOnTop(true);
        this.frame.getRootPane().putClientProperty("apple.awt._windowWillMoveHandler", new Runnable(){

            public void run() {
                DetachedAppletController.this.detachApplet();
            }
        });
        this.frame.addNotify();
    }

    private boolean isMouseInsideApplet() {
        if (!this.parentWindow.isShowing()) {
            return false;
        }
        Point point = this.parentWindow.getLocationOnScreen();
        point.y -= 16;
        Dimension dimension = this.parentWindow.getSize();
        dimension.height += 16;
        Rectangle rectangle = new Rectangle(point, dimension);
        Point point2 = (Point)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MouseInfo.getPointerInfo().getLocation();
            }
        });
        return rectangle.contains(point2);
    }

    boolean appletImplementsDragging() {
        if (this.appletHasDragMethod != null) {
            return this.appletHasDragMethod;
        }
        try {
            Applet2 applet2 = this.manager.getApplet2Adapter().getApplet2();
            if (applet2 == null) {
                return false;
            }
            applet2.getClass().getMethod("isAppletDragStart", MouseEvent.class);
            this.appletHasDragMethod = Boolean.TRUE;
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.appletHasDragMethod = Boolean.FALSE;
        return false;
    }

    private boolean frameContainsApplet() {
        return this.frame.getContentPane().getComponentCount() > 0;
    }

    private void startHideTimer() {
        if (this.hideTimer != null && this.hideTimer.isRunning()) {
            return;
        }
        this.hideTimer = new Timer(100, new HideTitleBarMonitor());
        this.hideTimer.start();
    }

    private void stopHideTimer() {
        if (this.hideTimer != null && this.hideTimer.isRunning()) {
            this.hideTimer.stop();
        }
    }

    private void positionDetachTitleBar() {
        Rectangle rectangle = this.parentWindow.getBounds();
        Insets insets = this.TRANSPARENT_PANEL.getInsets();
        final Rectangle rectangle2 = new Rectangle(rectangle.x - insets.left, rectangle.y - (16 + insets.top), this.parentWindow.getWidth() + insets.left + insets.right, this.parentWindow.getHeight() + 16 + insets.top + insets.bottom);
        GraphicsConfiguration graphicsConfiguration = this.parentWindow.getGraphicsConfiguration();
        Rectangle rectangle3 = graphicsConfiguration.getBounds();
        if (rectangle3.contains(rectangle)) {
            this.frame.setBounds(rectangle2);
            this.setFrameTitle(this.frame);
            return;
        }
        int n = rectangle.x - insets.left;
        int n2 = rectangle.y - (16 + insets.top);
        Rectangle rectangle4 = new Rectangle(n, n2, this.parentWindow.getWidth() + insets.left + insets.right, 16);
        Rectangle rectangle5 = rectangle3.intersection(rectangle4);
        this.frame.setBounds(rectangle5);
        this.frame.setTitle("");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DetachedAppletController.this.frame.setBounds(rectangle2);
                DetachedAppletController.this.setFrameTitle(DetachedAppletController.this.frame);
            }
        });
    }

    void showFrame() {
        if (!this.parentWindow.isActive() || this.appletImplementsDragging() || !this.isMouseInsideApplet()) {
            return;
        }
        this.createFrameIfNeeded();
        if (this.frameContainsApplet() || this.frame.isActive()) {
            return;
        }
        JRootPane jRootPane = this.frame.getRootPane();
        jRootPane.putClientProperty("Window.shadow", Boolean.FALSE);
        jRootPane.putClientProperty("Window.minimizable", Boolean.FALSE);
        jRootPane.putClientProperty("Window.closeable", Boolean.FALSE);
        jRootPane.putClientProperty("apple.awt._windowFakeActive", Boolean.TRUE);
        jRootPane.putClientProperty("apple.awt._windowFadeIn", new Integer(150));
        jRootPane.putClientProperty("apple.awt._windowFadeOut", new Integer(150));
        jRootPane.putClientProperty("apple.awt._windowFadeDelegate", jRootPane);
        this.oldContentPane = this.frame.getContentPane();
        this.frame.setBackground(TRANSPARENT);
        this.frame.setContentPane(this.TRANSPARENT_PANEL);
        this.frame.setFocusableWindowState(false);
        this.positionDetachTitleBar();
        this.frame.setVisible(true);
        this.startHideTimer();
    }

    void hideFrame() {
        if (this.frame == null || this.frameContainsApplet()) {
            return;
        }
        this.stopHideTimer();
        this.frame.setVisible(false);
    }

    private void setFrameTitle(Frame frame) {
        String string = this.manager.getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        frame.setTitle(string);
    }

    private void detachApplet() {
        if (this.frame == null || this.frameContainsApplet()) {
            return;
        }
        Applet2 applet2 = this.manager.getApplet2Adapter().getApplet2();
        if (applet2 == null) {
            return;
        }
        this.stopHideTimer();
        this.frame.setBackground(Color.WHITE);
        this.frame.setContentPane(this.oldContentPane);
        this.frame.setResizable(false);
        this.setAlwaysOnTop(this.frame, false);
        this.frame.setFocusableWindowState(true);
        final JRootPane jRootPane = this.frame.getRootPane();
        jRootPane.putClientProperty("Window.shadow", Boolean.TRUE);
        jRootPane.putClientProperty("Window.minimizable", Boolean.TRUE);
        jRootPane.putClientProperty("Window.closeable", Boolean.TRUE);
        jRootPane.putClientProperty("apple.awt._windowFadeIn", null);
        jRootPane.putClientProperty("apple.awt._windowFadeOut", null);
        jRootPane.putClientProperty("apple.awt._windowFadeDelegate", null);
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                jRootPane.putClientProperty("apple.awt._windowFakeActive", null);
                DetachedAppletController.this.frame.removeComponentListener(this);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Plugin2EventListener.inflateDockIcon();
            }
        });
    }

    static class TransparentPanel
    extends JComponent {
        final Color HALF_GRAY = new Color(0.5f, 0.5f, 0.5f, 0.5f);
        static final int FRAMEWIDTH = 1;

        TransparentPanel() {
        }

        public void paintComponent(Graphics graphics) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Src);
            Color color = graphics2D.getColor();
            graphics2D.setColor(TRANSPARENT);
            Dimension dimension = this.getSize();
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
        }

        public void paintBorder(Graphics graphics) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.HALF_GRAY);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.0f));
            Dimension dimension = this.getSize();
            graphics2D.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics2D.drawLine(1, dimension.height - 1, dimension.width - 2, dimension.height - 1);
            graphics2D.drawLine(0, 0, 0, dimension.height - 1);
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }

        public Insets getInsets() {
            return new Insets(0, 1, 1, 1);
        }
    }

    class HideTitleBarMonitor
    implements ActionListener {
        HideTitleBarMonitor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DetachedAppletController.this.isMouseInsideApplet() && MacOSXKeyHandler.getInstance().isKeyDown(0x100000L)) {
                return;
            }
            DetachedAppletController.this.hideFrame();
        }
    }

    static class DetachFrame
    extends JFrame {
        DetachFrame() {
        }
    }
}

