/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.gpio.extension.mcp.MCP23S17Pin;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.UnsupportedPinPullResistanceException;
import com.pi4j.wiringpi.Spi;
import java.io.IOException;
import java.util.List;

public class MCP23S17GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP23S17GpioProvider";
    public static final String DESCRIPTION = "MCP23S17 GPIO Provider";
    public static final byte DEFAULT_ADDRESS = 64;
    private static final byte REGISTER_IODIR_A = 0;
    private static final byte REGISTER_IODIR_B = 1;
    private static final byte REGISTER_GPINTEN_A = 4;
    private static final byte REGISTER_GPINTEN_B = 5;
    private static final byte REGISTER_DEFVAL_A = 6;
    private static final byte REGISTER_DEFVAL_B = 7;
    private static final byte REGISTER_INTCON_A = 8;
    private static final byte REGISTER_INTCON_B = 9;
    private static final byte REGISTER_IOCON = 10;
    private static final byte REGISTER_GPPU_A = 12;
    private static final byte REGISTER_GPPU_B = 13;
    private static final byte REGISTER_INTF_A = 14;
    private static final byte REGISTER_INTF_B = 15;
    private static final byte REGISTER_INTCAP_A = 16;
    private static final byte REGISTER_INTCAP_B = 17;
    private static final byte REGISTER_GPIO_A = 18;
    private static final byte REGISTER_GPIO_B = 19;
    private static final int GPIO_A_OFFSET = 0;
    private static final int GPIO_B_OFFSET = 1000;
    private int currentStatesA = 0;
    private int currentStatesB = 0;
    private int currentDirectionA = 0;
    private int currentDirectionB = 0;
    private int currentPullupA = 0;
    private int currentPullupB = 0;
    private byte address = (byte)64;
    private GpioStateMonitor monitor = null;
    public static final int SPI_SPEED = 1000000;
    public static final byte WRITE_FLAG = 0;
    public static final byte READ_FLAG = 1;

    public MCP23S17GpioProvider(byte spiAddress, int spiChannel) throws IOException {
        this(spiAddress, spiChannel, 1000000);
    }

    public MCP23S17GpioProvider(byte spiAddress, int spiChannel, int spiSpeed) throws IOException {
        int fd = Spi.wiringPiSPISetup((int)spiChannel, (int)spiSpeed);
        if (fd <= -1) {
            throw new IOException("SPI port setup failed.");
        }
        this.write((byte)10, (byte)0);
        this.write((byte)0, (byte)this.currentDirectionA);
        this.write((byte)1, (byte)this.currentDirectionB);
        this.write((byte)18, (byte)this.currentStatesA);
        this.write((byte)19, (byte)this.currentStatesB);
        this.write((byte)12, (byte)this.currentPullupA);
        this.write((byte)13, (byte)this.currentPullupB);
        this.write((byte)4, (byte)this.currentDirectionA);
        this.write((byte)5, (byte)this.currentDirectionB);
        this.write((byte)6, (byte)0);
        this.write((byte)7, (byte)0);
        this.write((byte)8, (byte)0);
        this.write((byte)9, (byte)0);
        if (this.currentDirectionA > 0) {
            this.read((byte)16);
        }
        if (this.currentDirectionB > 0) {
            this.read((byte)17);
        }
    }

    protected void write(byte register, byte data) {
        byte[] packet = new byte[]{(byte)(this.address | 0), register, data};
        Spi.wiringPiSPIDataRW((int)0, (byte[])packet, (int)3);
    }

    protected byte read(byte register) {
        byte[] packet = new byte[]{(byte)(this.address | 1), register, 0};
        int result = Spi.wiringPiSPIDataRW((int)0, (byte[])packet, (int)3);
        if (result >= 0) {
            return packet[2];
        }
        throw new RuntimeException("Invalid SPI read operation: " + result);
    }

    public String getName() {
        return NAME;
    }

    public void export(Pin pin, PinMode mode) {
        super.export(pin, mode);
        this.setMode(pin, mode);
    }

    public void unexport(Pin pin) {
        super.unexport(pin);
        this.setMode(pin, PinMode.DIGITAL_OUTPUT);
    }

    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
        try {
            if (pin.getAddress() < 1000) {
                this.setModeA(pin, mode);
            } else {
                this.setModeB(pin, mode);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.currentDirectionA > 0 || this.currentDirectionB > 0) {
            if (this.monitor == null) {
                this.monitor = new GpioStateMonitor(this);
                this.monitor.start();
            }
        } else if (this.monitor != null) {
            this.monitor.shutdown();
            this.monitor = null;
        }
    }

    private void setModeA(Pin pin, PinMode mode) throws IOException {
        int pinAddress = pin.getAddress() - 0;
        if (mode == PinMode.DIGITAL_INPUT) {
            this.currentDirectionA |= pinAddress;
        } else if (mode == PinMode.DIGITAL_OUTPUT) {
            this.currentDirectionA &= ~pinAddress;
        }
        this.write((byte)0, (byte)this.currentDirectionA);
        this.write((byte)4, (byte)this.currentDirectionA);
    }

    private void setModeB(Pin pin, PinMode mode) throws IOException {
        int pinAddress = pin.getAddress() - 1000;
        if (mode == PinMode.DIGITAL_INPUT) {
            this.currentDirectionB |= pinAddress;
        } else if (mode == PinMode.DIGITAL_OUTPUT) {
            this.currentDirectionB &= ~pinAddress;
        }
        this.write((byte)1, (byte)this.currentDirectionB);
        this.write((byte)5, (byte)this.currentDirectionB);
    }

    public PinMode getMode(Pin pin) {
        return super.getMode(pin);
    }

    public void setState(Pin pin, PinState state) {
        super.setState(pin, state);
        try {
            if (pin.getAddress() < 1000) {
                this.setStateA(pin, state);
            } else {
                this.setStateB(pin, state);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setStateA(Pin pin, PinState state) throws IOException {
        int pinAddress = pin.getAddress() - 0;
        this.currentStatesA = state.isHigh() ? (this.currentStatesA |= pinAddress) : (this.currentStatesA &= ~pinAddress);
        this.write((byte)18, (byte)this.currentStatesA);
    }

    private void setStateB(Pin pin, PinState state) throws IOException {
        int pinAddress = pin.getAddress() - 1000;
        this.currentStatesB = state.isHigh() ? (this.currentStatesB |= pinAddress) : (this.currentStatesB &= ~pinAddress);
        this.write((byte)19, (byte)this.currentStatesB);
    }

    public PinState getState(Pin pin) {
        PinState result = super.getState(pin);
        result = pin.getAddress() < 1000 ? this.getStateA(pin) : this.getStateB(pin);
        return result;
    }

    private PinState getStateA(Pin pin) {
        int pinAddress = pin.getAddress() - 0;
        PinState state = (this.currentStatesA & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
        this.getPinCache(pin).setState(state);
        return state;
    }

    private PinState getStateB(Pin pin) {
        int pinAddress = pin.getAddress() - 1000;
        PinState state = (this.currentStatesB & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
        this.getPinCache(pin).setState(state);
        return state;
    }

    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinPullResistance().contains(resistance)) {
            throw new UnsupportedPinPullResistanceException(pin, resistance);
        }
        try {
            if (pin.getAddress() < 1000) {
                this.setPullResistanceA(pin, resistance);
            } else {
                this.setPullResistanceB(pin, resistance);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getPinCache(pin).setResistance(resistance);
    }

    private void setPullResistanceA(Pin pin, PinPullResistance resistance) throws IOException {
        int pinAddress = pin.getAddress() - 0;
        this.currentPullupA = resistance == PinPullResistance.PULL_UP ? (this.currentPullupA |= pinAddress) : (this.currentPullupA &= ~pinAddress);
        this.write((byte)12, (byte)this.currentPullupA);
    }

    private void setPullResistanceB(Pin pin, PinPullResistance resistance) throws IOException {
        int pinAddress = pin.getAddress() - 1000;
        this.currentPullupB = resistance == PinPullResistance.PULL_UP ? (this.currentPullupB |= pinAddress) : (this.currentPullupB &= ~pinAddress);
        this.write((byte)13, (byte)this.currentPullupB);
    }

    public PinPullResistance getPullResistance(Pin pin) {
        return super.getPullResistance(pin);
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        if (this.monitor != null) {
            this.monitor.shutdown();
            this.monitor = null;
        }
    }

    private class GpioStateMonitor
    extends Thread {
        private MCP23S17GpioProvider provider;
        private boolean shuttingDown = false;

        public GpioStateMonitor(MCP23S17GpioProvider provider) {
            this.provider = provider;
        }

        public void shutdown() {
            this.shuttingDown = true;
        }

        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    byte pinInterruptB;
                    byte pinInterruptState;
                    byte pinInterruptA;
                    if (MCP23S17GpioProvider.this.currentDirectionA > 0 && (pinInterruptA = this.provider.read((byte)14)) > 0) {
                        pinInterruptState = this.provider.read((byte)18);
                        for (Pin pin : MCP23S17Pin.ALL_A_PINS) {
                            int pinAddressA = pin.getAddress() - 0;
                            if ((pinInterruptA & pinAddressA) <= 0) continue;
                            this.evaluatePinForChangeA(pin, pinInterruptState);
                        }
                    }
                    if (MCP23S17GpioProvider.this.currentDirectionB > 0 && (pinInterruptB = this.provider.read((byte)15)) > 0) {
                        pinInterruptState = this.provider.read((byte)19);
                        for (Pin pin : MCP23S17Pin.ALL_B_PINS) {
                            int pinAddressB = pin.getAddress() - 1000;
                            if ((pinInterruptB & pinAddressB) <= 0) continue;
                            this.evaluatePinForChangeB(pin, pinInterruptState);
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void evaluatePinForChangeA(Pin pin, int state) {
            int pinAddress;
            if (MCP23S17GpioProvider.this.getPinCache(pin).isExported() && (state & (pinAddress = pin.getAddress() - 0)) != (MCP23S17GpioProvider.this.currentStatesA & pinAddress)) {
                PinState newState = (state & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
                MCP23S17GpioProvider.this.getPinCache(pin).setState(newState);
                if (newState.isHigh()) {
                    MCP23S17GpioProvider.this.currentStatesA = MCP23S17GpioProvider.this.currentStatesA | pinAddress;
                } else {
                    MCP23S17GpioProvider.this.currentStatesA = MCP23S17GpioProvider.this.currentStatesA & ~pinAddress;
                }
                this.dispatchPinChangeEvent(pin.getAddress(), newState);
            }
        }

        private void evaluatePinForChangeB(Pin pin, int state) {
            int pinAddress;
            if (MCP23S17GpioProvider.this.getPinCache(pin).isExported() && (state & (pinAddress = pin.getAddress() - 1000)) != (MCP23S17GpioProvider.this.currentStatesB & pinAddress)) {
                PinState newState = (state & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
                MCP23S17GpioProvider.this.getPinCache(pin).setState(newState);
                if (newState.isHigh()) {
                    MCP23S17GpioProvider.this.currentStatesB = MCP23S17GpioProvider.this.currentStatesB | pinAddress;
                } else {
                    MCP23S17GpioProvider.this.currentStatesB = MCP23S17GpioProvider.this.currentStatesB & ~pinAddress;
                }
                this.dispatchPinChangeEvent(pin.getAddress(), newState);
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, PinState state) {
            for (Pin pin : MCP23S17GpioProvider.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)MCP23S17GpioProvider.this.listeners.get(pin)) {
                    listener.handlePinEvent((PinEvent)new PinDigitalStateChangeEvent((Object)this, pin, state));
                }
            }
        }
    }
}

