/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import bluej.extensions.BlueJ;
import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.bluej.extensions.submitter.transport.TransportSession;

public class SmtpSession
extends TransportSession {
    private Message msg;
    private Multipart multipart;
    private Session session;
    private String smtpTransport;
    private static final String DEBUGLOG_FILENAME = "javamail-debuglog.txt";

    public SmtpSession(URL url, Properties environment, BlueJ bluej) throws UnsupportedEncodingException {
        super(url, environment, bluej);
        this.result = "Submission not sent. Check debug log.";
    }

    public void connect() {
        this.createSession();
        this.msg = new MimeMessage(this.session);
        this.multipart = new MimeMultipart();
        String sendAddress = this.url.getPath();
        String subject = this.urlProps.getProperty("subject");
        if (subject == null) {
            subject = "BlueJ Submission";
        }
        String body = this.urlProps.getProperty("body");
        try {
            this.msg.setFrom(new InternetAddress(this.urlProps.getProperty("useraddr")));
            this.msg.setRecipient(Message.RecipientType.TO, new InternetAddress(sendAddress));
            this.msg.setSubject(subject);
            this.msg.setSentDate(new Date());
            if (body != null) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setText(body);
                this.multipart.addBodyPart(mbp);
            }
        }
        catch (MessagingException ex) {
            this.reportEvent(ex.getMessage());
            ex.printStackTrace();
        }
        this.reportEvent("Message for " + sendAddress + " created ok.");
    }

    private void createSession() {
        String smtpHost;
        String debug = "false";
        File javaMailDebugLog = new File(this.bluej.getUserConfigDir(), DEBUGLOG_FILENAME);
        if (javaMailDebugLog.exists()) {
            debug = "true";
        }
        if ((smtpHost = this.urlProps.getProperty("smtphost")) == null || smtpHost.length() == 0) {
            throw new IllegalArgumentException("SMTP Host has not been set");
        }
        String userAddress = this.urlProps.getProperty("useraddr");
        if (userAddress == null || userAddress.indexOf(64) < 1 || userAddress.indexOf(64) == userAddress.length() - 1) {
            throw new IllegalArgumentException("User Email address invalid");
        }
        this.smtpTransport = this.urlProps.getProperty("ssl", "smtp");
        this.smtpTransport = this.smtpTransport.equalsIgnoreCase("true") ? "smtps" : "smtp";
        String authentication = this.urlProps.getProperty("authenticate", "false");
        String enableTLS = this.urlProps.getProperty("tls", "false");
        String portNumber = this.urlProps.getProperty("port", "25");
        String saslRealm = this.bluej.getExtensionPropertyString("saslrealm", "");
        this.urlProps.put("mail.smtp.starttls.enable", enableTLS);
        this.urlProps.put("mail.transport.protocol", this.smtpTransport);
        this.urlProps.put("mail.smtp.auth", authentication);
        this.urlProps.put("mail.smtps.auth", authentication);
        this.urlProps.put("mail.smtp.port", portNumber);
        this.urlProps.put("mail.host", smtpHost);
        this.urlProps.put("mail.user", userAddress);
        this.urlProps.put("mail.debug", debug);
        this.urlProps.put("mail.smtp.sasl.realm", saslRealm);
        this.session = authentication.equals("true") ? Session.getInstance(this.urlProps, new MailUserAuthenticator()) : Session.getInstance(this.urlProps, null);
        if (debug.equals("true")) {
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(javaMailDebugLog));
                this.session.setDebugOut(ps);
                this.reportEvent("JavaMail's debug log will be written to " + javaMailDebugLog);
                ps.println("The JavaMail session was created with the following properties: ");
                this.session.getProperties().list(ps);
                ps.println("\n");
            }
            catch (FileNotFoundException ee) {
                this.reportEvent(ee.getMessage());
                ee.printStackTrace();
            }
        }
        this.reportEvent("Attempting connection to host " + smtpHost + " on port " + portNumber);
    }

    public void send(InputStream is, String fileName, boolean binary) {
        String packageName = fileName.replace('/', '_');
        String mimeType = "text/plain";
        String reportText = "===> Added text file  " + packageName + " to message.";
        if (binary) {
            mimeType = "application/octet-stream";
            reportText = "===> Added binary file " + packageName + " to message.";
        }
        try {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setFileName(packageName);
            DataHandler dh = new DataHandler(new ByteArrayDataSource(is, mimeType));
            mbp.setDataHandler(dh);
            this.multipart.addBodyPart(mbp);
            this.reportLog(reportText);
        }
        catch (Exception ex) {
            this.reportEvent(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            SMTPTransport transport = (SMTPTransport)this.session.getTransport(this.smtpTransport);
            transport.connect();
            this.msg.setContent(this.multipart);
            transport.sendMessage(this.msg, this.msg.getAllRecipients());
            transport.close();
            this.reportEvent("Disconnecting. All seems ok.");
            this.result = null;
        }
        catch (MessagingException mex) {
            this.reportEvent(mex.getMessage());
            mex.printStackTrace();
            this.reportEvent("Message could not be sent.");
        }
    }

    private class MailUserAuthenticator
    extends Authenticator {
        private MailUserAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String title = SmtpSession.this.bluej.getLabel("authentication.dialog.title") + " ";
            String mainPrompt = SmtpSession.this.bluej.getLabel("authentication.dialog.label");
            String usernamePrompt = SmtpSession.this.bluej.getLabel("authentication.dialog.label.username");
            String passwordPrompt = SmtpSession.this.bluej.getLabel("authentication.dialog.label.password");
            Box box = new Box(3);
            String s = SmtpSession.this.bluej.getExtensionPropertyString("smtpauthuser", System.getProperty("user.name", ""));
            JTextField username = new JTextField(s, 20);
            JPasswordField password = new JPasswordField(20);
            box.add(new JLabel(mainPrompt + " " + this.getRequestingSite()));
            box.add(Box.createVerticalStrut(10));
            box.add(new JLabel(usernamePrompt));
            box.add(username);
            box.add(Box.createVerticalStrut(5));
            box.add(new JLabel(passwordPrompt));
            box.add(password);
            box.add(Box.createVerticalStrut(10));
            int i = JOptionPane.showConfirmDialog(null, box, title + this.getRequestingProtocol(), 2, -1);
            if (i == 2) {
                return null;
            }
            return new PasswordAuthentication(username.getText(), String.copyValueOf(password.getPassword()));
        }
    }
}

