/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions.BlueJ;
import bluej.extensions.Extension;
import bluej.extensions.MenuGenerator;
import bluej.extensions.PreferenceGenerator;
import java.net.URL;
import org.bluej.extensions.submitter.GlobalProp;
import org.bluej.extensions.submitter.MenuBuilder;
import org.bluej.extensions.submitter.PrefPanel;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.SubmitDialog;
import org.bluej.extensions.submitter.properties.TreeData;
import org.bluej.utility.Flexdbg;
import org.bluej.utility.Utility;

public class Submitter
extends Extension {
    private Stat stat;

    public void startup(BlueJ i_bluej) {
        this.stat = new Stat();
        this.stat.bluej = i_bluej;
        this.stat.aDbg = new Flexdbg();
        int debugLevel = Utility.convStringToInt(this.stat.bluej.getExtensionPropertyString("debug.level", ""), 3);
        this.stat.aDbg.setDebugLevel(debugLevel);
        this.stat.aDbg.setServiceMask(-1);
        this.stat.aDbg.trace(1, "Submitter.startup: CALLED");
        this.stat.globalProp = new GlobalProp();
        this.stat.bluej.setPreferenceGenerator((PreferenceGenerator)new PrefPanel(this.stat));
        this.stat.treeData = new TreeData(this.stat);
        this.stat.submitDialog = new SubmitDialog(this.stat);
        this.stat.bluej.setMenuGenerator((MenuGenerator)new MenuBuilder(this.stat));
    }

    public boolean isCompatible() {
        return this.VERSION_MAJOR >= 2;
    }

    public String getVersion() {
        return "2 Feb 2007";
    }

    public String getName() {
        if (this.stat != null && this.stat.bluej != null) {
            return this.stat.bluej.getLabel("Submitter");
        }
        return "Submitter";
    }

    public String getDescription() {
        if (this.stat != null && this.stat.bluej != null) {
            return this.stat.bluej.getLabel("description");
        }
        return "Submit a BlueJ project to a remote location";
    }

    public URL getURL() {
        try {
            return new URL("http://www.bluej.org/extensions/submitter/submitter.html");
        }
        catch (Exception exc) {
            return null;
        }
    }
}

