/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class MultiWrapLabel
extends JComponent {
    private static String lineSep = System.getProperty("line.separator");
    private String text;
    private int wrapWidth;

    public MultiWrapLabel() {
        this.text = "";
        this.wrapWidth = -1;
    }

    public MultiWrapLabel(String text) {
        this.text = text;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public void setWrapWidth(int wrapWidth) {
        this.wrapWidth = wrapWidth;
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.wrapWidth != -1) {
            return this.getPreferredSizeWrapped();
        }
        double height = 0.0;
        double width = 0.0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int npos = 0;
        while (npos < this.text.length()) {
            String line;
            Rectangle2D lineRect;
            int end = this.text.indexOf(lineSep);
            if (end == -1) {
                end = this.text.length();
            }
            if ((lineRect = metrics.getStringBounds(line = this.text.substring(npos, end), this.getGraphics())).getWidth() > width) {
                width = lineRect.getWidth();
            }
            height += lineRect.getHeight();
            npos = end + lineSep.length();
        }
        return new Dimension((int)width + 1, (int)height);
    }

    private Dimension getPreferredSizeWrapped() {
        Graphics ng = this.getGraphics();
        int myWidth = this.wrapWidth;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int npos = 0;
        int currentY = 0;
        while (npos < this.text.length()) {
            int lineAmount;
            int end = this.text.indexOf(lineSep, npos);
            if (end == -1) {
                end = this.text.length();
            }
            String line = this.text.substring(npos, end);
            Rectangle2D lineRect = metrics.getStringBounds(line, ng);
            int lineHeight = (int)lineRect.getHeight();
            if (lineRect.getWidth() > (double)myWidth) {
                int lbound = 0;
                int hbound = line.length();
                int lboundw = 0;
                int hboundw = (int)lineRect.getWidth();
                while (hbound - lbound > 1) {
                    int middlew;
                    int middle = lbound + (hbound - lbound) * (hboundw - lboundw) / (myWidth - lboundw);
                    if (middle <= lbound) {
                        middle = lbound + 1;
                    }
                    if (middle >= hbound) {
                        middle = hbound - 1;
                    }
                    if ((middlew = (int)(lineRect = metrics.getStringBounds(line, 0, middle, ng)).getWidth()) > myWidth) {
                        hbound = middle;
                        hboundw = middlew;
                        continue;
                    }
                    lbound = middle;
                    lboundw = middlew;
                    lineHeight = (int)lineRect.getHeight();
                }
                lineAmount = lbound;
                int priorSpace = line.indexOf(32, 1);
                while (priorSpace != -1 && priorSpace <= lbound) {
                    lineAmount = priorSpace - 1;
                    priorSpace = line.indexOf(32, priorSpace + 1);
                }
                if (lineAmount <= 0) {
                    lineAmount = 1;
                }
            } else {
                lineAmount = line.length();
            }
            currentY += lineHeight;
            if (lineAmount < line.length()) {
                if (this.text.charAt(npos += lineAmount) != ' ') continue;
                ++npos;
                continue;
            }
            npos = end + lineSep.length();
        }
        return new Dimension(this.wrapWidth, currentY);
    }

    protected void paintComponent(Graphics g) {
        Graphics ng = g.create();
        ng.setPaintMode();
        int myWidth = this.getWidth();
        if (this.isOpaque()) {
            ng.setColor(this.getBackground());
            ng.fillRect(0, 0, myWidth, this.getHeight());
        }
        if (this.wrapWidth != -1 && this.wrapWidth < myWidth) {
            myWidth = this.wrapWidth;
        }
        ng.setFont(this.getFont());
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int npos = 0;
        int currentX = 0;
        int currentY = 0;
        while (npos < this.text.length()) {
            int lineAmount;
            int end = this.text.indexOf(lineSep, npos);
            if (end == -1) {
                end = this.text.length();
            }
            String line = this.text.substring(npos, end);
            Rectangle2D lineRect = metrics.getStringBounds(line, ng);
            int lineHeight = (int)lineRect.getHeight();
            if (lineRect.getWidth() > (double)myWidth) {
                int lbound = 0;
                int hbound = line.length();
                int lboundw = 0;
                int hboundw = (int)lineRect.getWidth();
                while (hbound - lbound > 1) {
                    int middlew;
                    int middle = lbound + (hbound - lbound) * (hboundw - lboundw) / (myWidth - lboundw);
                    if (middle <= lbound) {
                        middle = lbound + 1;
                    }
                    if (middle >= hbound) {
                        middle = hbound - 1;
                    }
                    if ((middlew = (int)(lineRect = metrics.getStringBounds(line, 0, middle, ng)).getWidth()) > myWidth) {
                        hbound = middle;
                        hboundw = middlew;
                        continue;
                    }
                    lbound = middle;
                    lboundw = middlew;
                    lineHeight = (int)lineRect.getHeight();
                }
                lineAmount = lbound;
                int priorSpace = line.indexOf(32, 1);
                while (priorSpace != -1 && priorSpace <= lbound) {
                    lineAmount = priorSpace;
                    priorSpace = line.indexOf(32, priorSpace + 1);
                }
                if (lineAmount == 0) {
                    lineAmount = 1;
                }
            } else {
                lineAmount = line.length();
            }
            float ascent = metrics.getLineMetrics(line, 0, lineAmount, ng).getAscent();
            ng.drawString(line.substring(0, lineAmount), currentX, (int)((float)currentY + ascent));
            currentY += lineHeight;
            if (lineAmount < line.length()) {
                if (this.text.charAt(npos += lineAmount) != ' ') continue;
                ++npos;
                continue;
            }
            npos = end + lineSep.length();
        }
    }
}

