/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr.record;

import bluej.testmgr.record.VoidMethodInvokerRecord;
import bluej.utility.JavaNames;

public class MethodInvokerRecord
extends VoidMethodInvokerRecord {
    private Class returnType;
    private String benchType;
    protected String benchName;

    public MethodInvokerRecord(Class returnType, String command, String[] argumentValues) {
        super(command, argumentValues);
        this.returnType = returnType;
        this.benchType = returnType.getName();
        this.benchName = null;
    }

    public void setBenchName(String name, String type) {
        this.benchName = name;
        this.benchType = type;
    }

    public String toFixtureDeclaration() {
        if (this.benchName == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\tprivate ");
        sb.append(this.benchDeclaration());
        sb.append(this.benchName);
        sb.append(";\n");
        return sb.toString();
    }

    public String toFixtureSetup() {
        if (this.benchName == null) {
            return "\t\t" + this.command + ";\n";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\t\t");
        sb.append(this.benchAssignmentTypecast());
        sb.append(";\n");
        return sb.toString();
    }

    public String toTestMethod() {
        StringBuffer sb = new StringBuffer();
        if (this.benchName != null) {
            sb.append("\t\t");
            sb.append(this.benchDeclaration());
            sb.append(this.benchAssignmentTypecast());
            sb.append(";\n");
        }
        if (this.getAssertionCount() == 0 && this.benchName == null) {
            sb.append("\t\t" + this.command + ";\n");
        }
        if (this.getAssertionCount() == 1) {
            if (this.benchName == null) {
                sb.append("\t\t");
                sb.append(MethodInvokerRecord.insertCommandIntoAssertionStatement(this.getAssertion(0), this.command));
                sb.append(";\n");
            } else {
                sb.append("\t\t");
                sb.append(MethodInvokerRecord.insertCommandIntoAssertionStatement(this.getAssertion(0), this.benchName));
                sb.append(";\n");
            }
        }
        if (this.getAssertionCount() > 1) {
            String assertAgainstName;
            String indentLevel;
            if (this.benchName == null) {
                indentLevel = "\t\t\t";
                assertAgainstName = "result";
            } else {
                indentLevel = "\t\t";
                assertAgainstName = this.benchName;
            }
            if (this.benchName == null) {
                sb.append("\t\t");
                sb.append("{\n");
                sb.append("\t\t\t");
                sb.append(JavaNames.typeName(this.returnType.getName()));
                sb.append(" result = ");
                sb.append(this.command);
                sb.append(";\n");
            }
            for (int i = 0; i < this.getAssertionCount(); ++i) {
                sb.append(indentLevel);
                sb.append(MethodInvokerRecord.insertCommandIntoAssertionStatement(this.getAssertion(i), assertAgainstName));
                sb.append(";\n");
            }
            if (this.benchName == null) {
                sb.append("\t\t");
                sb.append("}\n");
            }
        }
        return sb.toString();
    }

    private String benchDeclaration() {
        return JavaNames.typeName(this.benchType) + " ";
    }

    protected String benchAssignmentTypecast() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.benchName);
        sb.append(" = ");
        if (!this.benchType.equals(this.returnType.getName())) {
            sb.append("(");
            sb.append(this.benchType);
            sb.append(")");
        }
        sb.append(this.command);
        return sb.toString();
    }
}

