/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.SourceLocation;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.testmgr.CounterPanel;
import bluej.testmgr.MyCellRenderer;
import bluej.testmgr.ProgressBar;
import bluej.utility.JavaNames;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestDisplayFrame {
    static TestDisplayFrame singleton = null;
    private JFrame frame;
    private DefaultListModel testEntries;
    private JList testnames;
    private ProgressBar progressBar;
    private GridBagConstraints pbConstraints;
    private JPanel statusLabel;
    private JPanel bottomPanel;
    private static final int PROGRESS_BAR_INDEX = 0;
    private CounterPanel counterPanel;
    private int errorCount = 0;
    private int failureCount = 0;
    private int testTotal = 0;
    private boolean doingMultiple = false;
    private JTextArea exceptionMessageField;
    private JButton showSourceButton;
    private Project lastProject;

    public static synchronized TestDisplayFrame getTestDisplay() {
        if (singleton == null) {
            singleton = new TestDisplayFrame();
        }
        return singleton;
    }

    public static boolean isFrameShown() {
        if (singleton == null) {
            return false;
        }
        return singleton.isShown();
    }

    public TestDisplayFrame() {
        this.createUI();
    }

    public void showTestDisplay(boolean doShow) {
        this.frame.setVisible(doShow);
    }

    public boolean isShown() {
        return this.frame.isShowing();
    }

    protected void createUI() {
        this.frame = new JFrame(Config.getString("testdisplay.title"));
        this.frame.setIconImage(BlueJTheme.getIconImage());
        this.frame.setLocation(Config.getLocation("bluej.testdisplay"));
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.testdisplay", TestDisplayFrame.this.frame.getLocation());
            }
        });
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setBorder(BlueJTheme.generalBorder);
        splitPane.setResizeWeight(0.5);
        JScrollPane resultScrollPane = new JScrollPane();
        this.testEntries = new DefaultListModel();
        this.testnames = new JList(this.testEntries);
        this.testnames.setCellRenderer(new MyCellRenderer());
        this.testnames.addListSelectionListener(new MyListSelectionListener());
        this.testnames.addMouseListener(new ShowSourceListener());
        resultScrollPane.setViewportView(this.testnames);
        splitPane.setTopComponent(resultScrollPane);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        this.progressBar = new ProgressBar();
        this.bottomPanel.add((Component)this.progressBar, constraints);
        this.bottomPanel.add(Box.createVerticalStrut(5), constraints);
        this.counterPanel = new CounterPanel();
        this.bottomPanel.add((Component)this.counterPanel, constraints);
        this.bottomPanel.add(Box.createVerticalStrut(5), constraints);
        this.exceptionMessageField = new JTextArea("");
        this.exceptionMessageField.setEditable(false);
        this.exceptionMessageField.setRows(6);
        this.exceptionMessageField.setColumns(42);
        this.exceptionMessageField.setFocusable(false);
        Dimension size = this.exceptionMessageField.getPreferredSize();
        size.width = this.exceptionMessageField.getMinimumSize().width;
        this.exceptionMessageField.setMinimumSize(size);
        JScrollPane exceptionScrollPane = new JScrollPane(this.exceptionMessageField);
        exceptionScrollPane.setMinimumSize(size);
        this.showSourceButton = new JButton(Config.getString("testdisplay.showsource"));
        this.showSourceButton.addActionListener(new ShowSourceListener());
        JButton closeButton = new JButton(Config.getString("close"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestDisplayFrame.this.frame.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.showSourceButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(closeButton);
        constraints.weighty = 1.0;
        this.bottomPanel.add((Component)exceptionScrollPane, constraints);
        constraints.weighty = 0.0;
        this.bottomPanel.add(Box.createVerticalStrut(5), constraints);
        this.bottomPanel.add((Component)buttonPanel, constraints);
        constraints.gridy = 0;
        this.pbConstraints = constraints;
        splitPane.setBottomComponent(this.bottomPanel);
        this.frame.getContentPane().add(splitPane);
        this.frame.pack();
    }

    protected void reset() {
        this.testEntries.clear();
        this.errorCount = 0;
        this.failureCount = 0;
        this.testTotal = 0;
        this.exceptionMessageField.setText("");
        this.showSourceButton.setEnabled(false);
        this.progressBar.reset();
        this.counterPanel.setTotal(0);
        this.counterPanel.setErrorValue(0);
        this.counterPanel.setFailureValue(0);
        this.bottomPanel.remove(0);
        this.bottomPanel.add(this.progressBar, this.pbConstraints, 0);
        this.bottomPanel.validate();
        this.progressBar.repaint();
    }

    public void startMultipleTests(int num) {
        this.doingMultiple = true;
        this.reset();
        this.testTotal = num;
        this.counterPanel.setTotal(this.testTotal);
        this.progressBar.setMaximum(this.testTotal);
        this.showTestDisplay(true);
    }

    public void endMultipleTests() {
        this.doingMultiple = false;
        this.setResultLabel();
    }

    public void startTest(Project project, int num) {
        this.lastProject = project;
        if (!this.doingMultiple) {
            this.reset();
            this.testTotal = num;
            this.counterPanel.setTotal(this.testTotal);
            this.progressBar.setMaximum(this.testTotal);
        }
    }

    public void addResult(DebuggerTestResult dtr, boolean quiet) {
        this.addResultQuietly(dtr);
        if (!quiet) {
            this.showTestDisplay(true);
        }
    }

    public void addResultQuietly(DebuggerTestResult dtr) {
        if (!dtr.isSuccess()) {
            if (dtr.isFailure()) {
                ++this.failureCount;
            } else {
                ++this.errorCount;
            }
        }
        this.testEntries.addElement(dtr);
        this.progressBar.step(this.testEntries.getSize(), dtr.isSuccess());
        this.counterPanel.setFailureValue(this.failureCount);
        this.counterPanel.setErrorValue(this.errorCount);
        this.counterPanel.setRunValue(this.testEntries.getSize());
        if (!this.doingMultiple && this.progressBar.getValue() == this.progressBar.getMaximum()) {
            this.setResultLabel();
        }
    }

    private void setResultLabel() {
        this.statusLabel = new JPanel();
        if (this.errorCount + this.failureCount == 0) {
            this.statusLabel.setBackground(ProgressBar.greenBarColour);
        } else {
            this.statusLabel.setBackground(ProgressBar.redBarColour);
        }
        this.statusLabel.setMinimumSize(this.progressBar.getMinimumSize());
        this.statusLabel.setMaximumSize(this.progressBar.getMaximumSize());
        this.statusLabel.setPreferredSize(this.progressBar.getSize());
        this.statusLabel.setOpaque(true);
        this.bottomPanel.remove(0);
        this.bottomPanel.add(this.statusLabel, this.pbConstraints, 0);
        this.bottomPanel.validate();
        this.statusLabel.repaint();
    }

    class ShowSourceListener
    extends MouseAdapter
    implements ActionListener {
        ShowSourceListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int cc = e.getClickCount();
            if (cc == 2) {
                this.showSource();
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.showSource();
        }

        private void showSource() {
            DebuggerTestResult dtr = (DebuggerTestResult)TestDisplayFrame.this.testnames.getSelectedValue();
            if (dtr != null && (dtr.isError() || dtr.isFailure())) {
                SourceLocation exceptionLocation = dtr.getExceptionLocation();
                if (exceptionLocation == null) {
                    return;
                }
                String packageName = JavaNames.getPrefix(exceptionLocation.getClassName());
                Package spackage = TestDisplayFrame.this.lastProject.getPackage(packageName);
                if (spackage == null) {
                    return;
                }
                String sourceName = exceptionLocation.getFileName();
                int lineno = exceptionLocation.getLineNumber();
                spackage.showSource(sourceName, lineno, "", false);
            }
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (TestDisplayFrame.this.testnames.getSelectedValue() != null) {
                DebuggerTestResult dtr = (DebuggerTestResult)TestDisplayFrame.this.testnames.getSelectedValue();
                if (dtr.isError() || dtr.isFailure()) {
                    TestDisplayFrame.this.exceptionMessageField.setText(dtr.getExceptionMessage() + "\n---\n" + dtr.getTrace());
                    TestDisplayFrame.this.exceptionMessageField.setCaretPosition(0);
                    TestDisplayFrame.this.exceptionMessageField.setColumns(1);
                    TestDisplayFrame.this.showSourceButton.setEnabled(dtr.getExceptionLocation() != null);
                } else {
                    TestDisplayFrame.this.exceptionMessageField.setText("");
                    TestDisplayFrame.this.showSourceButton.setEnabled(false);
                }
            }
        }
    }
}

