/*
 * Decompiled with CFR 0.152.
 */
package bluej.runtime;

import bluej.runtime.BJInputStream;
import bluej.runtime.RemoteSecurityManager;
import bluej.runtime.RemoteTestRunner;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ExecServer {
    public static final String MAIN_THREAD_NAME = "mainThread";
    public static Thread mainThread = null;
    public static final String WORKER_THREAD_NAME = "workerThread";
    public static Thread workerThread = null;
    public static String classToRun;
    public static String methodToRun;
    public static String[] parameterTypes;
    public static Object[] arguments;
    public static int execAction;
    public static Object methodReturn;
    public static Class executedClass;
    public static Throwable exception;
    public static final String CLASS_TO_RUN_NAME = "classToRun";
    public static final String METHOD_TO_RUN_NAME = "methodToRun";
    public static final String PARAMETER_TYPES_NAME = "parameterTypes";
    public static final String ARGUMENTS_NAME = "arguments";
    public static final String EXEC_ACTION_NAME = "execAction";
    public static final String METHOD_RETURN_NAME = "methodReturn";
    public static final String EXCEPTION_NAME = "exception";
    public static final String EXECUTED_CLASS_NAME = "executedClass";
    public static final int EXEC_SHELL = 0;
    public static final int TEST_SETUP = 1;
    public static final int TEST_RUN = 2;
    public static final int DISPOSE_WINDOWS = 3;
    public static final int EXIT_VM = 4;
    public static final int LOAD_INIT_CLASS = 5;
    public static final int INSTANTIATE_CLASS = 6;
    public static final int INSTANTIATE_CLASS_ARGS = 7;
    public static int workerAction;
    public static String objectName;
    public static Object object;
    public static String classPath;
    public static String className;
    public static String scopeId;
    public static ClassLoader classLoader;
    public static Object workerReturn;
    public static final String WORKER_ACTION_NAME = "workerAction";
    public static final String OBJECTNAME_NAME = "objectName";
    public static final String OBJECT_NAME = "object";
    public static final String CLASSPATH_NAME = "classPath";
    public static final String CLASSNAME_NAME = "className";
    public static final String WORKER_RETURN_NAME = "workerReturn";
    public static final String SCOPE_ID_NAME = "scopeId";
    public static final String CLASSLOADER_NAME = "classLoader";
    public static final int REMOVE_OBJECT = 0;
    public static final int ADD_OBJECT = 1;
    public static final int LOAD_CLASS = 2;
    public static final int NEW_LOADER = 3;
    public static final int LOAD_ALL = 5;
    private static ClassLoader currentLoader;
    private static Map objectMaps;
    private static List openWindows;
    private static boolean disposingAllWindows;

    public static void main(String[] args) throws Throwable {
        System.setIn(new BJInputStream(System.in));
        if (args.length > 0 && !args[0].equals("")) {
            System.setOut(new PrintStream((OutputStream)System.out, true, args[0]));
        }
        workerThread = new Thread("BlueJ worker thread"){

            public void run() {
                while (true) {
                    ExecServer.vmSuspend();
                    switch (workerAction) {
                        case 1: {
                            ExecServer.addObject(scopeId, objectName, object);
                            object = null;
                            break;
                        }
                        case 0: {
                            ExecServer.removeObject(scopeId, objectName);
                            break;
                        }
                        case 2: {
                            try {
                                if (classLoader == null) {
                                    classLoader = currentLoader;
                                }
                                workerReturn = Class.forName(className, false, currentLoader);
                                ((Class)workerReturn).getFields();
                                classLoader = null;
                            }
                            catch (Throwable cnfe) {
                                workerReturn = null;
                            }
                            break;
                        }
                        case 3: {
                            workerReturn = ExecServer.newLoader(classPath);
                            break;
                        }
                        case 4: {
                            System.exit(0);
                        }
                        case 5: {
                            workerReturn = ExecServer.loadAllClasses(className);
                        }
                    }
                    workerAction = 4;
                }
            }
        };
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        AWTEventListener listener = new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 200) {
                    ExecServer.addWindow(event.getSource());
                } else if (event.getID() == 202) {
                    ExecServer.removeWindow(event.getSource());
                }
            }
        };
        toolkit.addAWTEventListener(listener, 64L);
        System.setSecurityManager(new RemoteSecurityManager());
        ExecServer.newThread();
        workerThread.setPriority(10);
        workerThread.start();
    }

    public static void vmStarted() {
    }

    public static void vmSuspend() {
    }

    private static void addWindow(Object o) {
        openWindows.add(o);
    }

    private static void removeWindow(Object o) {
        if (!disposingAllWindows) {
            openWindows.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getScope(String scopeId) {
        Map map = objectMaps;
        synchronized (map) {
            HashMap m = (HashMap)objectMaps.get(scopeId);
            if (m == null) {
                m = new HashMap();
                objectMaps.put(scopeId, m);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader newLoader(String urlListAsString) {
        String[] splits = urlListAsString.split("\n");
        URL[] urls = new URL[splits.length];
        for (int index = 0; index < splits.length; ++index) {
            try {
                urls[index] = new URL(splits[index]);
                continue;
            }
            catch (MalformedURLException mfue) {
                System.err.println("ExecServer.newLoader() Malformed URL=" + splits[index]);
            }
        }
        currentLoader = new URLClassLoader(urls);
        Map map = objectMaps;
        synchronized (map) {
            objectMaps.clear();
        }
        return currentLoader;
    }

    public static Class loadAndInitClass(String className) {
        Class<?> cl;
        if (currentLoader == null) {
            System.err.println("ExecServer.loadClass() currentLoader=null");
        }
        Throwable exception = null;
        try {
            cl = Class.forName(className, true, currentLoader);
        }
        catch (ClassNotFoundException cnfe) {
            cl = null;
        }
        catch (ExceptionInInitializerError eiie) {
            exception = eiie.getCause();
            try {
                cl = Class.forName(className, false, currentLoader);
            }
            catch (ClassNotFoundException cnfe) {
                cl = null;
            }
        }
        catch (Throwable err) {
            exception = err;
            try {
                cl = Class.forName(className, false, currentLoader);
            }
            catch (Throwable t) {
                cl = null;
            }
        }
        if (exception != null) {
            String stClassName;
            int i;
            StackTraceElement[] stackTrace = exception.getStackTrace();
            for (i = stackTrace.length - 1; i > 0 && ((stClassName = stackTrace[i].getClassName()).startsWith("bluej.runtime.ExecServer") || stClassName.startsWith("java.lang.Class")); --i) {
            }
            StackTraceElement[] newStackTrace = new StackTraceElement[i + 1];
            System.arraycopy(stackTrace, 0, newStackTrace, 0, i + 1);
            exception.setStackTrace(newStackTrace);
            ExecServer.recordException(exception);
        }
        return cl;
    }

    private static Class[] loadAllClasses(String className) {
        ArrayList l = new ArrayList();
        try {
            Class<?> c = currentLoader.loadClass(className);
            c.getFields();
            l.add(c);
            ExecServer.getDeclaredInnerClasses(c, l);
            int i = 1;
            while (true) {
                c = currentLoader.loadClass(className + '$' + i);
                c.getFields();
                l.add(c);
                ++i;
            }
        }
        catch (Throwable throwable) {
            return l.toArray(new Class[l.size()]);
        }
    }

    private static void getDeclaredInnerClasses(Class c, List list) {
        try {
            Class<?>[] rlist = c.getDeclaredClasses();
            for (int i = 0; i < rlist.length; ++i) {
                c = rlist[i];
                c.getFields();
                list.add(rlist[i]);
                ExecServer.getDeclaredInnerClasses(rlist[i], list);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addObject(String scopeId, String instanceName, Object value) {
        Map scope;
        Map map = scope = ExecServer.getScope(scopeId);
        synchronized (map) {
            scope.put(instanceName, value);
            scope.notify();
        }
    }

    private static Object[] runTestSetUp(String className) {
        Class cl = ExecServer.loadAndInitClass(className);
        try {
            Method setUpMethod;
            Object testCase = null;
            Class[] partypes = new Class[]{String.class};
            try {
                Constructor ct = cl.getConstructor(partypes);
                Object[] arglist = new Object[]{"TestCase " + className};
                testCase = ct.newInstance(arglist);
            }
            catch (NoSuchMethodException nsme) {
                testCase = null;
            }
            if (testCase == null) {
                testCase = cl.newInstance();
            }
            if ((setUpMethod = ExecServer.findMethod(cl, "setUp", null)) != null) {
                setUpMethod.setAccessible(true);
                setUpMethod.invoke(testCase, (Object[])null);
            }
            Field[] fields = cl.getDeclaredFields();
            Object[] obs = new Object[fields.length * 2 + 1];
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                obs[i * 2] = fields[i].getName();
                obs[i * 2 + 1] = fields[i].get(testCase);
            }
            obs[obs.length - 1] = testCase;
            return obs;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Object[0];
        }
    }

    private static Method findMethod(Class cl, String name, Class[] paramtypes) {
        while (cl != null) {
            try {
                return cl.getDeclaredMethod(name, paramtypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                cl = cl.getSuperclass();
            }
        }
        return null;
    }

    private static Object[] runTestMethod(String className, String methodName) {
        Class cl = ExecServer.loadAndInitClass(className);
        TestCase testCase = null;
        try {
            Class[] partypes = new Class[]{String.class};
            Constructor ct = cl.getConstructor(partypes);
            Object[] arglist = new Object[]{methodName};
            testCase = (TestCase)ct.newInstance(arglist);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("ie");
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("iae");
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("ite");
        }
        if (testCase == null) {
            try {
                testCase = (TestCase)cl.newInstance();
                testCase.setName(methodName);
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        TestSuite suite = new TestSuite("bluej");
        suite.addTest((Test)testCase);
        RemoteTestRunner runner = new RemoteTestRunner();
        TestResult tr = runner.doRun((Test)suite);
        if (tr.errorCount() > 1 || tr.failureCount() > 1) {
            throw new IllegalStateException("error or failure count was > 1");
        }
        if (tr.errorCount() == 1) {
            Enumeration e = tr.errors();
            if (e.hasMoreElements()) {
                Object[] result = new Object[7];
                TestFailure tf = (TestFailure)e.nextElement();
                result[0] = tf.isFailure() ? "failure" : "error";
                result[1] = tf.exceptionMessage() != null ? tf.exceptionMessage() : "no exception message";
                result[2] = tf.trace() != null ? tf.trace() : "no trace";
                StackTraceElement[] ste = tf.thrownException().getStackTrace();
                result[3] = ste[0].getClassName();
                result[4] = ste[0].getFileName();
                result[5] = ste[0].getMethodName();
                result[6] = String.valueOf(ste[0].getLineNumber());
                return result;
            }
            throw new IllegalStateException("errorCount was 1 but found no errors");
        }
        if (tr.failureCount() == 1) {
            Enumeration e = tr.failures();
            if (e.hasMoreElements()) {
                int i;
                Object[] result = new Object[7];
                TestFailure tf = (TestFailure)e.nextElement();
                result[0] = tf.isFailure() ? "failure" : "error";
                result[1] = tf.exceptionMessage() != null ? tf.exceptionMessage() : "no exception message";
                result[2] = tf.trace() != null ? tf.trace() : "no trace";
                StackTraceElement[] ste = tf.thrownException().getStackTrace();
                for (i = 0; i < ste.length && ste[i].getClassName().startsWith("junit."); ++i) {
                }
                result[3] = ste[i].getClassName();
                result[4] = ste[i].getFileName();
                result[5] = ste[i].getMethodName();
                result[6] = String.valueOf(ste[i].getLineNumber());
                return result;
            }
            throw new IllegalStateException("failureCount was 1 but found no errors");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeObject(String scopeId, String instanceName) {
        Map scope;
        Map map = scope = ExecServer.getScope(scopeId);
        synchronized (map) {
            scope.remove(instanceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeWindows() {
        List list = openWindows;
        synchronized (list) {
            disposingAllWindows = true;
            Iterator it = openWindows.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Window)) continue;
                Window w = (Window)o;
                w.dispose();
            }
            openWindows.clear();
            disposingAllWindows = false;
        }
    }

    static void clearInputBuffer() {
        try {
            int n = System.in.available();
            while (n != 0) {
                System.in.skip(n);
                n = System.in.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void newThread() {
        final Thread oldThread = mainThread;
        mainThread = new Thread("main"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    if (oldThread != null) {
                        oldThread.join();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ExecServer.vmStarted();
                methodReturn = null;
                exception = null;
                try {
                    switch (execAction) {
                        case 0: {
                            Class<?> c;
                            methodReturn = null;
                            executedClass = null;
                            ExecServer.clearInputBuffer();
                            executedClass = c = currentLoader.loadClass(classToRun);
                            Method m = c.getMethod("run", new Class[0]);
                            try {
                                methodReturn = m.invoke(null, new Object[0]);
                                return;
                            }
                            catch (InvocationTargetException ite) {
                                throw ite.getCause();
                            }
                        }
                        case 6: {
                            ExecServer.clearInputBuffer();
                            Class<?> c = currentLoader.loadClass(classToRun);
                            Constructor<?> cons = c.getDeclaredConstructor(new Class[0]);
                            cons.setAccessible(true);
                            try {
                                methodReturn = cons.newInstance(null);
                                return;
                            }
                            catch (InvocationTargetException ite) {
                                throw ite.getCause();
                            }
                        }
                        case 7: {
                            ExecServer.clearInputBuffer();
                            Class<?> c = currentLoader.loadClass(classToRun);
                            Class[] paramClasses = new Class[parameterTypes.length];
                            for (int i = 0; i < parameterTypes.length; ++i) {
                                if (classLoader == null) {
                                    classLoader = currentLoader;
                                }
                                paramClasses[i] = Class.forName(parameterTypes[i], false, currentLoader);
                            }
                            Constructor<?> cons = c.getDeclaredConstructor(paramClasses);
                            cons.setAccessible(true);
                            try {
                                methodReturn = cons.newInstance(arguments);
                                return;
                            }
                            catch (InvocationTargetException ite) {
                                throw ite.getCause();
                            }
                        }
                        case 1: {
                            methodReturn = ExecServer.runTestSetUp(classToRun);
                            return;
                        }
                        case 2: {
                            methodReturn = ExecServer.runTestMethod(classToRun, methodToRun);
                            return;
                        }
                        case 3: {
                            ExecServer.disposeWindows();
                            return;
                        }
                        case 5: {
                            try {
                                methodReturn = ExecServer.loadAndInitClass(classToRun);
                                return;
                            }
                            catch (Throwable cnfe) {
                                methodReturn = null;
                                return;
                            }
                        }
                        case 4: {
                            System.exit(0);
                            return;
                        }
                    }
                    return;
                }
                catch (Throwable t) {
                    ExecServer.recordException(t);
                    return;
                }
                finally {
                    execAction = 4;
                    ExecServer.newThread();
                }
            }
        };
        mainThread.start();
    }

    private static void recordException(Throwable t) {
        int i;
        exception = t;
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (i = 0; i < stackTrace.length && !stackTrace[i].getClassName().startsWith("__SHELL"); ++i) {
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[i];
        System.arraycopy(stackTrace, 0, newStackTrace, 0, i);
        t.setStackTrace(newStackTrace);
        t.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String instanceName) {
        Map m = ExecServer.getScope(scopeId);
        Object rval = null;
        try {
            Map map = m;
            synchronized (map) {
                rval = m.get(instanceName);
                if (rval == null) {
                    m.wait();
                    rval = m.get(instanceName);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return rval;
    }

    public static ClassLoader getCurrentClassLoader() {
        return currentLoader;
    }

    public static void setClassLoader(ClassLoader newLoader) {
        currentLoader = newLoader;
    }

    static {
        workerAction = 4;
        classLoader = null;
        objectMaps = new HashMap();
        openWindows = Collections.synchronizedList(new LinkedList());
        disposingAllWindows = false;
    }
}

