/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MiscPrefPanel
extends JPanel
implements PrefPanelListener {
    private static final String bluejJdkURL = "bluej.url.javaStdLib";
    private static final String greenfootJdkURL = "greenfoot.url.javaStdLib";
    private JTextField jdkURLField;
    private JCheckBox linkToLibBox;
    private JCheckBox showUncheckedBox;
    private JCheckBox showTestBox;
    private JCheckBox showTeamBox;
    private String jdkURLPropertyName = Config.isGreenfoot() ? "greenfoot.url.javaStdLib" : "bluej.url.javaStdLib";

    public MiscPrefPanel() {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        this.add(box);
        this.setBorder(BlueJTheme.generalBorder);
        box.add(Box.createVerticalGlue());
        JPanel docPanel = new JPanel();
        docPanel.setLayout(new BoxLayout(docPanel, 1));
        String docTitle = Config.getString("prefmgr.misc.documentation.title");
        docPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        docPanel.setAlignmentX(0.0f);
        JPanel urlPanel = new JPanel(new BorderLayout(5, 0));
        urlPanel.add((Component)new JLabel(Config.getString("prefmgr.misc.jdkurlpath")), "West");
        this.jdkURLField = new JTextField(32);
        urlPanel.add((Component)this.jdkURLField, "Center");
        urlPanel.setAlignmentX(0.0f);
        docPanel.add(urlPanel);
        docPanel.add(Box.createVerticalStrut(5));
        this.linkToLibBox = new JCheckBox(Config.getString("prefmgr.misc.linkToLib"));
        this.linkToLibBox.setAlignmentX(0.0f);
        docPanel.add(this.linkToLibBox);
        docPanel.add(Box.createVerticalStrut(5));
        JLabel linkToLibNoteLine1 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine1"));
        Font smallFont = linkToLibNoteLine1.getFont().deriveFont(10);
        linkToLibNoteLine1.setFont(smallFont);
        linkToLibNoteLine1.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine1);
        JLabel linkToLibNoteLine2 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine2"));
        linkToLibNoteLine2.setFont(smallFont);
        linkToLibNoteLine2.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine2);
        box.add(docPanel);
        if (!Config.isGreenfoot()) {
            box.add(Box.createVerticalStrut(5));
            JPanel testPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            testPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.tools.title")), BlueJTheme.generalBorder));
            testPanel.setAlignmentX(0.0f);
            this.showTestBox = new JCheckBox(Config.getString("prefmgr.misc.showTesting"));
            testPanel.add(this.showTestBox);
            this.showTeamBox = new JCheckBox(Config.getString("prefmgr.misc.showTeam"));
            testPanel.add(this.showTeamBox);
            box.add(testPanel);
            box.add(Box.createVerticalStrut(5));
            JPanel vmPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            vmPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.vm.title")), BlueJTheme.generalBorder));
            vmPanel.setAlignmentX(0.0f);
            this.showUncheckedBox = new JCheckBox(Config.getString("prefmgr.misc.showUnchecked"));
            if (Config.isJava15()) {
                vmPanel.add(this.showUncheckedBox);
            }
            box.add(vmPanel);
        }
        box.add(Box.createVerticalStrut(5));
    }

    public void beginEditing() {
        this.linkToLibBox.setSelected(PrefMgr.getFlag("doctool.linkToStandardLib"));
        this.jdkURLField.setText(Config.getPropString(this.jdkURLPropertyName));
        if (!Config.isGreenfoot()) {
            this.showTestBox.setSelected(PrefMgr.getFlag("bluej.testing.showtools"));
            this.showTeamBox.setSelected(PrefMgr.getFlag("bluej.teamwork.showtools"));
            this.showUncheckedBox.setSelected(PrefMgr.getFlag("bluej.compiler.showunchecked"));
        }
    }

    public void revertEditing() {
    }

    public void commitEditing() {
        PrefMgr.setFlag("doctool.linkToStandardLib", this.linkToLibBox.isSelected());
        if (!Config.isGreenfoot()) {
            PrefMgr.setFlag("bluej.testing.showtools", this.showTestBox.isSelected());
            PrefMgr.setFlag("bluej.teamwork.showtools", this.showTeamBox.isSelected());
            PrefMgr.setFlag("bluej.compiler.showunchecked", this.showUncheckedBox.isSelected());
            PkgMgrFrame.updateTestingStatus();
            PkgMgrFrame.updateTeamStatus();
        }
        String jdkURL = this.jdkURLField.getText();
        Config.putPropString(this.jdkURLPropertyName, jdkURL);
    }
}

