/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.graph.GraphEditor;
import bluej.graph.Moveable;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PackageTarget
extends Target
implements Moveable {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 40;
    private static final int TAB_HEIGHT = 12;
    static String openStr = Config.getString("pkgmgr.packagemenu.open");
    static String removeStr = Config.getString("pkgmgr.packagemenu.remove");
    static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    static final BasicStroke normalStroke = new BasicStroke(1.0f);
    static final BasicStroke selectedStroke = new BasicStroke(3.0f);
    private int ghostX;
    private int ghostY;
    private int ghostWidth;
    private int ghostHeight;
    private boolean isDragging;
    private boolean isMoveable = true;

    public PackageTarget(Package pkg, String baseName) {
        super(pkg, baseName);
        this.setSize(PackageTarget.calculateWidth(baseName), 62);
    }

    public String getBaseName() {
        return this.getIdentifierName();
    }

    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        super.load(props, prefix);
    }

    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(prefix + ".type", "PackageTarget");
    }

    public void deleteFiles() {
        this.deleteDir(new File(this.getPackage().getPath(), this.getBaseName()));
    }

    private void deleteDir(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        } else {
            this.getPackage().getProject().prepareDeleteDir(directory);
            for (int i = 0; i < Array.getLength(fileList); ++i) {
                this.deleteDir(fileList[i]);
            }
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        }
    }

    public boolean copyFiles(String directory) {
        return true;
    }

    public void doubleClick(MouseEvent evt) {
        this.getPackage().getEditor().raiseOpenPackageEvent(this, this.getPackage().getQualifiedName(this.getBaseName()));
    }

    public void popupMenu(int x, int y, GraphEditor graphEditor) {
        JPopupMenu menu = this.createMenu();
        if (menu != null) {
            menu.show(graphEditor, x, y);
        }
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu(this.getBaseName());
        OpenAction openAction = new OpenAction(openStr, this, this.getPackage().getQualifiedName(this.getBaseName()));
        this.addMenuItem(menu, openAction);
        RemoveAction removeAction = new RemoveAction(removeStr, this);
        this.addMenuItem(menu, removeAction);
        return menu;
    }

    private void addMenuItem(JPopupMenu menu, Action action) {
        JMenuItem item = menu.add(action);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(envOpColour);
    }

    public void remove() {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(this.getPackage());
        if (pmf.askRemovePackage(this)) {
            this.deleteFiles();
            this.getPackage().getProject().removePackage(this.getQualifiedName());
            this.getPackage().removeTarget(this);
        }
    }

    public void removeImmediate() {
        this.deleteFiles();
        this.getPackage().removeTarget(this);
        this.getPackage().getProject().removePackage(this.getQualifiedName());
    }

    public void setSize(int width, int height) {
        super.setSize(Math.max(width, 60), Math.max(height, 40));
        this.setGhostSize(0, 0);
    }

    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.setGhostPosition(0, 0);
    }

    public int getGhostX() {
        return this.ghostX;
    }

    public int getGhostY() {
        return this.ghostY;
    }

    public int getGhostWidth() {
        return this.ghostWidth;
    }

    public int getGhostHeight() {
        return this.ghostHeight;
    }

    public void setGhostPosition(int deltaX, int deltaY) {
        this.ghostX = this.getX() + deltaX;
        this.ghostY = this.getY() + deltaY;
    }

    public void setGhostSize(int deltaX, int deltaY) {
        this.ghostWidth = Math.max(this.getWidth() + deltaX, 60);
        this.ghostHeight = Math.max(this.getHeight() + deltaY, 40);
    }

    public void setPositionToGhost() {
        super.setPos(this.ghostX, this.ghostY);
        this.setSize(this.ghostWidth, this.ghostHeight);
        this.isDragging = false;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public void setIsMoveable(boolean isMoveable) {
        this.isMoveable = isMoveable;
    }

    private class RemoveAction
    extends AbstractAction {
        private Target t;

        public RemoveAction(String menu, Target t) {
            super(menu);
            this.t = t;
        }

        public void actionPerformed(ActionEvent e) {
            PackageTarget.this.getPackage().getEditor().raiseRemoveTargetEvent(this.t);
        }
    }

    private class OpenAction
    extends AbstractAction {
        private Target t;
        private String pkgName;

        public OpenAction(String menu, Target t, String pkgName) {
            super(menu);
            this.t = t;
            this.pkgName = pkgName;
        }

        public void actionPerformed(ActionEvent e) {
            PackageTarget.this.getPackage().getEditor().raiseOpenPackageEvent(this.t, this.pkgName);
        }
    }
}

