/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.actions;

import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public abstract class PkgMgrAction
extends AbstractAction {
    protected static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static PkgMgrFrame frameFromEvent(ActionEvent event) {
        Component jc = (Component)event.getSource();
        while (jc != null && !(jc instanceof PkgMgrFrame)) {
            if (jc instanceof JPopupMenu) {
                jc = ((JPopupMenu)jc).getInvoker();
                continue;
            }
            jc = jc.getParent();
        }
        return (PkgMgrFrame)jc;
    }

    public PkgMgrAction(String s) {
        super(Config.getString(s));
        if (!Config.isMacOS()) {
            this.putValue("MnemonicKey", new Integer(Config.getMnemonicKey(s)));
        }
        if (Config.hasAcceleratorKey(s)) {
            this.putValue("AcceleratorKey", Config.getAcceleratorKey(s));
        }
    }

    public PkgMgrAction(String s, int keycode) {
        super(Config.getString(s));
        KeyStroke ks = KeyStroke.getKeyStroke(keycode, SHORTCUT_MASK);
        this.putValue("AcceleratorKey", ks);
    }

    public PkgMgrAction(String s, int keycode, int modifiers) {
        super(Config.getString(s));
        KeyStroke ks = KeyStroke.getKeyStroke(keycode, modifiers);
        this.putValue("AcceleratorKey", ks);
    }

    public ButtonModel getToggleModel(PkgMgrFrame pmf) {
        return null;
    }

    public final void actionPerformed(ActionEvent event) {
        PkgMgrFrame pmf = PkgMgrAction.frameFromEvent(event);
        this.actionPerformed(pmf);
    }

    public void actionPerformed(PkgMgrFrame pmf) {
    }
}

