/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.LibraryCallDialog;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.debugmgr.texteval.TextEvalArea;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.MenuManager;
import bluej.groupwork.actions.CheckoutAction;
import bluej.groupwork.actions.TeamActionGroup;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.pkgmgr.AboutBlue;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.ImportFailedDialog;
import bluej.pkgmgr.MachineIcon;
import bluej.pkgmgr.NewClassDialog;
import bluej.pkgmgr.NewPackageDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageEditorEvent;
import bluej.pkgmgr.PackageEditorListener;
import bluej.pkgmgr.PackagePrintManager;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectPrintDialog;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.actions.AddClassAction;
import bluej.pkgmgr.actions.CancelTestRecordAction;
import bluej.pkgmgr.actions.CheckExtensionsAction;
import bluej.pkgmgr.actions.CheckVersionAction;
import bluej.pkgmgr.actions.CloseProjectAction;
import bluej.pkgmgr.actions.CompileAction;
import bluej.pkgmgr.actions.CompileSelectedAction;
import bluej.pkgmgr.actions.EndTestRecordAction;
import bluej.pkgmgr.actions.ExportProjectAction;
import bluej.pkgmgr.actions.GenerateDocsAction;
import bluej.pkgmgr.actions.HelpAboutAction;
import bluej.pkgmgr.actions.ImportProjectAction;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewInheritsAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.actions.NewProjectAction;
import bluej.pkgmgr.actions.NewUsesAction;
import bluej.pkgmgr.actions.OpenNonBlueJAction;
import bluej.pkgmgr.actions.OpenProjectAction;
import bluej.pkgmgr.actions.PageSetupAction;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.pkgmgr.actions.PreferencesAction;
import bluej.pkgmgr.actions.PrintAction;
import bluej.pkgmgr.actions.QuitAction;
import bluej.pkgmgr.actions.RebuildAction;
import bluej.pkgmgr.actions.RemoveAction;
import bluej.pkgmgr.actions.RestartVMAction;
import bluej.pkgmgr.actions.RunTestsAction;
import bluej.pkgmgr.actions.SaveProjectAction;
import bluej.pkgmgr.actions.SaveProjectAsAction;
import bluej.pkgmgr.actions.ShowCopyrightAction;
import bluej.pkgmgr.actions.ShowDebuggerAction;
import bluej.pkgmgr.actions.ShowInheritsAction;
import bluej.pkgmgr.actions.ShowTerminalAction;
import bluej.pkgmgr.actions.ShowTestResultsAction;
import bluej.pkgmgr.actions.ShowTextEvalAction;
import bluej.pkgmgr.actions.ShowUsesAction;
import bluej.pkgmgr.actions.StandardAPIHelpAction;
import bluej.pkgmgr.actions.TutorialAction;
import bluej.pkgmgr.actions.UseLibraryAction;
import bluej.pkgmgr.actions.WebsiteAction;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.MethodInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class PkgMgrFrame
extends JFrame
implements BlueJEventListener,
MouseListener,
PackageEditorListener,
FocusListener {
    public Font PkgMgrFont = PrefMgr.getStandardFont();
    static final int DEFAULT_WIDTH = 560;
    static final int DEFAULT_HEIGHT = 400;
    private static Application macApplication = PkgMgrFrame.prepareMacOSApp();
    private static boolean testToolsShown = PkgMgrFrame.wantToSeeTestingTools();
    private static boolean teamToolsShown = PkgMgrFrame.wantToSeeTeamTools();
    private JPanel buttonPanel;
    private JPanel testPanel;
    private JPanel teamPanel;
    private JCheckBoxMenuItem showUsesMenuItem;
    private JCheckBoxMenuItem showExtendsMenuItem;
    private AbstractButton imgExtendsButton;
    private AbstractButton imgDependsButton;
    private AbstractButton runButton;
    private JLabel statusbar;
    private ActivityIndicator progressbar;
    private JLabel testStatusMessage;
    private JLabel recordingLabel;
    private AbstractButton endTestButton;
    private AbstractButton cancelTestButton;
    private JMenuItem endTestMenuItem;
    private JMenuItem cancelTestMenuItem;
    private ClassTarget testTarget = null;
    private String testTargetMethod;
    private JMenuBar menubar = null;
    private JMenu recentProjectsMenu;
    private JMenu testingMenu;
    private MenuManager menuManager;
    private JMenu teamMenu;
    private JMenuItem shareProjectMenuItem;
    private JMenuItem teamSettingsMenuItem;
    private JMenuItem showLogMenuItem;
    private JMenuItem updateMenuItem;
    private JMenuItem commitMenuItem;
    private JMenuItem statusMenuItem;
    private AbstractButton updateButton;
    private AbstractButton commitButton;
    private AbstractButton teamStatusButton;
    private List teamItems;
    private TeamActionGroup teamActions;
    private JMenuItem showTestResultsItem;
    private List itemsToDisable;
    private List actionsToDisable;
    private List testItems;
    private MachineIcon machineIcon;
    private Action closeProjectAction = new CloseProjectAction();
    private Action saveProjectAction = new SaveProjectAction();
    private Action saveProjectAsAction = new SaveProjectAsAction();
    private Action importProjectAction = new ImportProjectAction();
    private Action exportProjectAction = new ExportProjectAction();
    private Action pageSetupAction = new PageSetupAction();
    private Action printAction = new PrintAction();
    private Action newClassAction = new NewClassAction();
    private Action newPackageAction = new NewPackageAction();
    private Action addClassAction = new AddClassAction();
    private Action removeAction = new RemoveAction();
    private Action newUsesAction = new NewUsesAction();
    private Action newInheritsAction = new NewInheritsAction();
    private Action compileAction = new CompileAction();
    private Action compileSelectedAction = new CompileSelectedAction();
    private Action rebuildAction = new RebuildAction();
    private Action useLibraryAction = new UseLibraryAction();
    private Action generateDocsAction = new GenerateDocsAction();
    private PkgMgrAction showUsesAction = new ShowUsesAction();
    private PkgMgrAction showInheritsAction = new ShowInheritsAction();
    private PkgMgrAction showDebuggerAction = new ShowDebuggerAction();
    private PkgMgrAction showTerminalAction = new ShowTerminalAction();
    private PkgMgrAction showTextEvalAction = new ShowTextEvalAction();
    private Action runTestsAction = new RunTestsAction();
    private JScrollPane classScroller = null;
    private Package pkg = null;
    private PackageEditor editor = null;
    private ObjectBench objbench = new ObjectBench();
    private TextEvalArea textEvaluator;
    private JSplitPane splitPane;
    private JSplitPane objectBenchSplitPane;
    private boolean showingTextEvaluator = false;
    private LibraryCallDialog libraryCallDialog = null;
    private ProjectPrintDialog projectPrintDialog = null;
    private static PageFormat pageFormat = null;
    private static List frames = new ArrayList();
    private static ExtensionsManager extMgr = ExtensionsManager.getInstance();

    private static Application prepareMacOSApp() {
        Application macApp = new Application();
        macApp.setEnabledPreferencesMenu(true);
        macApp.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent e) {
                HelpAboutAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                e.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent e) {
                PreferencesAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                e.setHandled(true);
            }

            public void handleQuit(ApplicationEvent e) {
                QuitAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
            }
        });
        return macApp;
    }

    public static PkgMgrFrame createFrame() {
        PkgMgrFrame frame = new PkgMgrFrame();
        frames.add(frame);
        BlueJEvent.addListener(frame);
        return frame;
    }

    public static PkgMgrFrame createFrame(Package pkg) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
        if (pmf == null) {
            if (frames.size() == 1) {
                pmf = (PkgMgrFrame)frames.get(0);
            }
            if (pmf == null || !pmf.isEmptyFrame()) {
                pmf = PkgMgrFrame.createFrame();
            }
            pmf.openPackage(pkg);
        }
        return pmf;
    }

    public static void closeFrame(PkgMgrFrame frame) {
        if (!frame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        frames.remove(frame);
        BlueJEvent.removeListener(frame);
        PrefMgr.setFlag("bluej.startWithTextEval", frame.showingTextEvaluator);
        frame.dispose();
    }

    public static PkgMgrFrame findFrame(Package pkg) {
        Iterator i = frames.iterator();
        while (i.hasNext()) {
            PkgMgrFrame pmf = (PkgMgrFrame)i.next();
            if (pmf.isEmptyFrame() || pmf.getPackage() != pkg) continue;
            return pmf;
        }
        return null;
    }

    public static int frameCount() {
        return frames.size();
    }

    public static PkgMgrFrame[] getAllFrames() {
        PkgMgrFrame[] openFrames = new PkgMgrFrame[frames.size()];
        frames.toArray(openFrames);
        return openFrames;
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj) {
        return PkgMgrFrame.getAllProjectFrames(proj, "");
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj, String pkgPrefix) {
        ArrayList<PkgMgrFrame> list = new ArrayList<PkgMgrFrame>();
        String pkgPrefixWithDot = pkgPrefix + ".";
        Iterator i = frames.iterator();
        while (i.hasNext()) {
            PkgMgrFrame pmf = (PkgMgrFrame)i.next();
            if (pmf.isEmptyFrame() || pmf.getProject() != proj) continue;
            String fullName = pmf.getPackage().getQualifiedName();
            if (fullName.startsWith(pkgPrefixWithDot)) {
                list.add(pmf);
                continue;
            }
            if (!fullName.equals(pkgPrefix) && pkgPrefix.length() != 0) continue;
            list.add(pmf);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new PkgMgrFrame[list.size()]);
    }

    public static PkgMgrFrame getMostRecent() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllFrames();
        if (frames.length < 1) {
            return null;
        }
        PkgMgrFrame mostRecent = frames[0];
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getFocusOwner() == null) continue;
            mostRecent = frames[i];
        }
        return mostRecent;
    }

    public static void updateTestingStatus() {
        if (testToolsShown != PkgMgrFrame.wantToSeeTestingTools()) {
            Iterator i = frames.iterator();
            while (i.hasNext()) {
                ((PkgMgrFrame)i.next()).showTestingTools(!testToolsShown);
            }
            testToolsShown = !testToolsShown;
        }
    }

    private static boolean wantToSeeTestingTools() {
        return PrefMgr.getFlag("bluej.testing.showtools");
    }

    public static void updateTeamStatus() {
        if (teamToolsShown != PkgMgrFrame.wantToSeeTeamTools()) {
            Iterator i = frames.iterator();
            while (i.hasNext()) {
                ((PkgMgrFrame)i.next()).showTeamTools(!teamToolsShown);
            }
            teamToolsShown = !teamToolsShown;
        }
    }

    private static boolean wantToSeeTeamTools() {
        return PrefMgr.getFlag("bluej.teamwork.showtools");
    }

    public static void displayMessage(String message) {
        Iterator i = frames.iterator();
        while (i.hasNext()) {
            PkgMgrFrame frame = (PkgMgrFrame)i.next();
            frame.setStatus(message);
        }
    }

    public static void displayMessage(Package sourcePkg, String message) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            pmf.setStatus(message);
        }
    }

    public static void displayMessage(Project sourceProj, String message) {
        PkgMgrFrame[] pmf = PkgMgrFrame.getAllProjectFrames(sourceProj);
        if (pmf != null) {
            for (int i = 0; i < pmf.length; ++i) {
                if (pmf[i] == null) continue;
                pmf[i].setStatus(message);
            }
        }
    }

    public static void showError(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showError(pmf, msgId);
        }
    }

    public static void showMessage(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessage(pmf, msgId);
        }
    }

    public static void showMessageWithText(Package sourcePkg, String msgId, String text) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessageWithText(pmf, msgId, text);
        }
    }

    private PkgMgrFrame() {
        if (!Config.isGreenfoot()) {
            this.teamActions = new TeamActionGroup(false);
            this.teamActions.setAllDisabled();
            this.setupActionDisableSet();
            this.makeFrame();
            this.updateWindowTitle();
            this.setStatus("BlueJ 2.2.0");
        }
    }

    public void openPackage(Package pkg) {
        if (pkg == null) {
            throw new NullPointerException();
        }
        if (this.pkg != null) {
            this.closePackage();
        }
        this.pkg = pkg;
        if (!Config.isGreenfoot()) {
            this.editor = new PackageEditor(pkg, this);
            this.editor.setFocusable(true);
            this.editor.addMouseListener(this);
            this.editor.addFocusListener(this);
            this.editor.startMouseListening();
            pkg.setEditor(this.editor);
            this.classScroller.setViewportView(this.editor);
            Properties p = pkg.getLastSavedProperties();
            try {
                String width_str = p.getProperty("package.editor.width", Integer.toString(560));
                String height_str = p.getProperty("package.editor.height", Integer.toString(400));
                this.classScroller.setPreferredSize(new Dimension(Integer.parseInt(width_str), Integer.parseInt(height_str)));
                String x_str = p.getProperty("package.editor.x", "30");
                String y_str = p.getProperty("package.editor.y", "30");
                int x = Integer.parseInt(x_str);
                int y = Integer.parseInt(y_str);
                if (x > Config.screenBounds.width - 80) {
                    x = Config.screenBounds.width - 80;
                }
                if (y > Config.screenBounds.height - 80) {
                    y = Config.screenBounds.height - 80;
                }
                this.setLocation(x, y);
            }
            catch (NumberFormatException e) {
                Debug.reportError("Could not read preferred project screen position");
            }
            String uses_str = p.getProperty("package.showUses", "true");
            String extends_str = p.getProperty("package.showExtends", "true");
            this.showUsesMenuItem.setSelected(uses_str.equals("true"));
            this.showExtendsMenuItem.setSelected(extends_str.equals("true"));
            this.updateShowUsesInPackage();
            this.updateShowExtendsInPackage();
            this.pack();
            this.editor.revalidate();
            this.editor.requestFocus();
            this.enableFunctions(true);
            this.updateWindowTitle();
            this.setVisible(true);
            this.menuManager.setAttachedObject(pkg);
            this.menuManager.addExtensionMenu(pkg.getProject());
            this.teamActions = pkg.getProject().getTeamActions();
            this.resetTeamActions();
        }
        extMgr.packageOpened(pkg);
    }

    private void resetTeamActions() {
        this.teamStatusButton.setAction(this.teamActions.getStatusAction());
        this.updateButton.setAction(this.teamActions.getUpdateAction());
        this.teamSettingsMenuItem.setAction(this.teamActions.getTeamSettingsAction());
        this.commitButton.setAction(this.teamActions.getCommitCommentAction());
        this.shareProjectMenuItem.setAction(this.teamActions.getImportAction());
        this.statusMenuItem.setAction(this.teamActions.getStatusAction());
        this.commitMenuItem.setAction(this.teamActions.getCommitCommentAction());
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.updateMenuItem.setAction(this.teamActions.getUpdateAction());
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.showLogMenuItem.setAction(this.teamActions.getShowLogAction());
    }

    public void closePackage() {
        if (this.isEmptyFrame()) {
            return;
        }
        extMgr.packageClosing(this.pkg);
        if (!Config.isGreenfoot()) {
            this.classScroller.setViewportView(null);
            this.classScroller.setBorder(Config.normalBorder);
            this.editor.removeMouseListener(this);
            this.editor.removeFocusListener(this);
            this.menuManager.setAttachedObject(this.pkg);
        }
        this.getObjectBench().removeAllObjects(this.getProject().getUniqueId());
        this.clearTextEval();
        this.getPackage().closeAllEditors();
        Project proj = this.getProject();
        this.editor = null;
        this.pkg = null;
        if (PkgMgrFrame.getAllProjectFrames(proj) == null) {
            Project.cleanUp(proj);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(false);
        } else if (!Config.isGreenfoot()) {
            super.setVisible(true);
            this.setState(0);
        }
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Project getProject() {
        return this.pkg == null ? null : this.pkg.getProject();
    }

    public boolean isEmptyFrame() {
        return this.pkg == null;
    }

    protected String updateWindowTitle() {
        if (this.isEmptyFrame()) {
            this.setTitle("BlueJ");
            return "BlueJ";
        }
        String title = Config.getString("pkgmgr.title") + this.getProject().getProjectName();
        if (!this.getPackage().isUnnamedPackage()) {
            title = title + "  [" + this.getPackage().getQualifiedName() + "]";
        }
        if (this.getProject().isTeamProject()) {
            title = title + " (" + Config.getString("team.project.marker") + ")";
        }
        this.setTitle(title);
        return title;
    }

    public void setStatus(final String status) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (PkgMgrFrame.this.statusbar != null) {
                    PkgMgrFrame.this.statusbar.setText(status);
                }
            }
        });
    }

    public void startProgress() {
        this.progressbar.setRunning(true);
    }

    public void stopProgress() {
        this.progressbar.setRunning(false);
    }

    public void clearStatus() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (PkgMgrFrame.this.statusbar != null) {
                    PkgMgrFrame.this.statusbar.setText(" ");
                }
            }
        });
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public ObjectBench getObjectBench() {
        return this.objbench;
    }

    public void mousePressed(MouseEvent evt) {
        this.clearStatus();
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void focusGained(FocusEvent e) {
        this.classScroller.setBorder(Config.focusBorder);
        this.editor.setHasFocus(true);
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.classScroller.setBorder(Config.normalBorder);
            this.editor.setHasFocus(false);
        }
    }

    public void targetEvent(PackageEditorEvent e) {
        int evtId = e.getID();
        switch (evtId) {
            case 1: {
                this.callMethod(e.getCallable());
                break;
            }
            case 2: {
                ((Target)e.getSource()).remove();
                break;
            }
            case 3: {
                this.openPackageTarget(e.getName());
                break;
            }
            case 4: {
                ClassTarget ct = (ClassTarget)e.getSource();
                ct.getRole().run(this, ct, e.getName());
                break;
            }
            case 5: {
                this.objectBenchToTestFixture((ClassTarget)e.getSource());
                break;
            }
            case 6: {
                this.testFixtureToObjectBench((ClassTarget)e.getSource());
                break;
            }
            case 7: {
                this.makeTestCase((ClassTarget)e.getSource());
                break;
            }
            case 8: {
                DebuggerObject gotObj = e.getDebuggerObject();
                boolean tryAgain = true;
                do {
                    String newObjectName;
                    if ((newObjectName = DialogManager.askString((Component)e.getSource(), "getobject-new-name", this.getProject().getDebugger().guessNewName(gotObj))) == null) {
                        tryAgain = false;
                        continue;
                    }
                    if (JavaNames.isIdentifier(newObjectName)) {
                        this.putObjectOnBench(newObjectName, e.getDebuggerObject(), e.getIType(), e.getInvokerRecord());
                        tryAgain = false;
                        continue;
                    }
                    DialogManager.showError((Component)e.getSource(), "must-be-identifier");
                } while (tryAgain);
            }
        }
    }

    public boolean newProject(String dirName) {
        if (Project.createNewProject(dirName)) {
            Project proj = Project.openProject(dirName);
            if (this.isEmptyFrame()) {
                this.openPackage(proj.getPackage(""));
            } else {
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(proj.getPackage(""));
                DialogManager.tileWindow(pmf, this);
                pmf.setVisible(true);
            }
            return true;
        }
        return false;
    }

    public File[] importProjectDir(File dir, boolean showFailureDialog) {
        Object[] fails = FileUtility.recursiveCopyFile(dir, this.getPackage().getPath());
        if (fails != null && showFailureDialog) {
            ImportFailedDialog importFailedDlg = new ImportFailedDialog(this, fails);
            importFailedDlg.setVisible(true);
        }
        List dirsToConvert = Import.findInterestingDirectories(this.getPackage().getPath());
        Import.convertDirectory(dirsToConvert);
        this.getProject().reloadAll();
        return fails;
    }

    public boolean createNewClass(String name, String template, boolean showErr) {
        boolean success;
        if (this.pkg.getTarget(name) != null) {
            DialogManager.showError(this, "duplicate-name");
            return false;
        }
        ClassTarget target = null;
        target = new ClassTarget(this.pkg, name, template);
        if (template != null && !(success = target.generateSkeleton(template))) {
            return false;
        }
        this.pkg.findSpaceForVertex(target);
        this.pkg.addTarget(target);
        if (this.editor != null) {
            this.editor.revalidate();
            this.editor.scrollRectToVisible(target.getRectangle());
            this.editor.repaint();
        }
        if (target.getRole() instanceof UnitTestClassRole) {
            this.pkg.compileQuiet(target);
        }
        return true;
    }

    public boolean doNewProject() {
        String newname = FileUtility.getFileName(this, Config.getString("pkgmgr.newPkg.title"), Config.getString("pkgmgr.newPkg.buttonLabel"), true, null, true);
        if (newname == null) {
            return false;
        }
        if (!this.newProject(newname)) {
            DialogManager.showError(null, "directory-exists");
            return false;
        }
        return true;
    }

    public void doOpen() {
        File dirName = FileUtility.getPackageName(this);
        if (dirName != null) {
            this.openProject(dirName.getAbsolutePath());
        }
    }

    private boolean openProject(String projectPath) {
        Package pkg;
        PkgMgrFrame pmf;
        Project openProj = Project.openProject(projectPath);
        if (openProj == null) {
            return false;
        }
        if (openProj.isReadOnly()) {
            DialogManager.showMessage(this, "project-is-readonly");
        }
        if ((pmf = PkgMgrFrame.findFrame(pkg = openProj.getPackage(openProj.getInitialPackageName()))) == null) {
            if (this.isEmptyFrame()) {
                pmf = this;
                this.openPackage(pkg);
            } else {
                pmf = PkgMgrFrame.createFrame(pkg);
                DialogManager.tileWindow(pmf, this);
            }
        }
        pmf.setVisible(true);
        return true;
    }

    public void doOpenNonBlueJ() {
        File dirName = FileUtility.getNonBlueJDirectoryName(this);
        if (dirName == null) {
            return;
        }
        File absDirName = dirName.getAbsoluteFile();
        if (!absDirName.exists()) {
            DialogManager.showError(this, "file-does-not-exist");
            return;
        }
        if (absDirName.isDirectory()) {
            if (Project.isProject(absDirName.getPath())) {
                DialogManager.showError(this, "open-non-bluej-already-bluej");
                return;
            }
            if (!Import.convertNonBlueJ(this, absDirName)) {
                return;
            }
            this.openProject(absDirName.getPath());
        } else {
            this.openJar(absDirName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openJar(File jarName) {
        ZipInputStream jarInStream = null;
        try {
            String prefixFolder = this.getArchivePrefixFolder(jarName);
            File oPath = jarName.getParentFile();
            if (prefixFolder == null) {
                if (!(oPath = new File(oPath, jarName.getName().substring(0, jarName.getName().length() - 4))).mkdir()) {
                    DialogManager.showErrorWithText(this, "jar-output-dir-exists", oPath.toString());
                    return;
                }
            } else {
                File prefixFolderFile = new File(oPath, prefixFolder);
                if (!prefixFolderFile.mkdir()) {
                    DialogManager.showErrorWithText(this, "jar-output-dir-exists", prefixFolderFile.toString());
                    return;
                }
            }
            FileInputStream is = new FileInputStream(jarName);
            jarInStream = new JarInputStream(is);
            JarEntry je = ((JarInputStream)jarInStream).getNextJarEntry();
            while (je != null) {
                File outFile = new File(oPath, je.getName());
                if (je.getName().endsWith("/")) {
                    outFile.mkdirs();
                } else {
                    outFile.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(outFile);
                    byte[] buffer = new byte[8192];
                    int rlength = jarInStream.read(buffer);
                    while (rlength != -1) {
                        ((OutputStream)os).write(buffer, 0, rlength);
                        rlength = jarInStream.read(buffer);
                    }
                    jarInStream.closeEntry();
                }
                je = ((JarInputStream)jarInStream).getNextJarEntry();
            }
            if (prefixFolder != null) {
                oPath = new File(oPath, prefixFolder);
            }
            if (Project.isProject(oPath.getPath())) {
                this.openProject(oPath.getPath());
                return;
            }
            if (!Import.convertNonBlueJ(this, oPath)) return;
            this.openProject(oPath.getPath());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            DialogManager.showError(this, "jar-extraction-error");
            return;
        }
        finally {
            try {
                if (jarInStream != null) {
                    jarInStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getArchivePrefixFolder(File arName) throws FileNotFoundException, IOException {
        ZipInputStream jarInStream = null;
        FileInputStream is = null;
        String prefixFolder = null;
        try {
            is = new FileInputStream(arName);
            jarInStream = new JarInputStream(is);
            JarEntry je = ((JarInputStream)jarInStream).getNextJarEntry();
            while (je != null) {
                String entryName = je.getName();
                int slashIndex = entryName.indexOf(47);
                if (slashIndex == -1) {
                    prefixFolder = null;
                    break;
                }
                String prefix = entryName.substring(0, slashIndex);
                if (prefixFolder == null) {
                    prefixFolder = prefix;
                } else if (!prefixFolder.equals(prefix)) {
                    prefixFolder = null;
                    break;
                }
                je = ((JarInputStream)jarInStream).getNextJarEntry();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (jarInStream != null) {
                jarInStream.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return prefixFolder;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(project);
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].doClose(true);
            }
        }
    }

    public void doClose(boolean keepLastFrame) {
        this.doSave();
        if (PkgMgrFrame.frameCount() == 1) {
            if (keepLastFrame && !Config.isGreenfoot()) {
                this.testRecordingEnded();
                this.closePackage();
                this.updateWindowTitle();
                this.updateRecentProjects();
                this.enableFunctions(false);
                this.updateWindowTitle();
                this.menuManager.addExtensionMenu(null);
            } else {
                this.doQuit();
            }
        } else {
            this.closePackage();
            PkgMgrFrame.closeFrame(this);
        }
    }

    public void wantToQuit() {
        int answer = 0;
        if (Project.getOpenProjectCount() > 1) {
            answer = DialogManager.askQuestion(this, "quit-all");
        }
        if (answer == 0) {
            this.doQuit();
        }
    }

    private void doQuit() {
        PkgMgrFrame[] pkgFrames = PkgMgrFrame.getAllFrames();
        this.handleOrphanPackages(pkgFrames);
        for (int i = pkgFrames.length - 1; i >= 0; --i) {
            PkgMgrFrame aFrame = pkgFrames[i];
            aFrame.doSave();
            aFrame.closePackage();
            PkgMgrFrame.closeFrame(aFrame);
        }
        extMgr.unloadExtensions();
        Main.exit();
    }

    private void handleOrphanPackages(PkgMgrFrame[] openFrames) {
        if (PkgMgrFrame.hadOrphanPackages()) {
            this.removeOrphanPackageList();
        }
        for (int i = 0; i < openFrames.length; ++i) {
            PkgMgrFrame aFrame = openFrames[i];
            if (aFrame.isEmptyFrame()) continue;
            Config.putPropString("bluej.openPackage" + (i + 1), aFrame.getPackage().getPath().toString());
        }
    }

    public static boolean hadOrphanPackages() {
        String dir = "";
        int i = 1;
        while (dir != null) {
            dir = Config.getPropString("bluej.openPackage" + i, null);
            if (dir != null && Project.isBlueJProject(dir)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeOrphanPackageList() {
        String exists = "";
        int i = 1;
        while (exists != null) {
            exists = Config.removeProperty("bluej.openPackage" + i);
            ++i;
        }
    }

    protected void doSave() {
        if (this.isEmptyFrame()) {
            return;
        }
        Properties p = new Properties();
        if (!Config.isGreenfoot()) {
            Dimension d = this.classScroller.getSize(null);
            p.put("package.editor.width", Integer.toString(d.width));
            p.put("package.editor.height", Integer.toString(d.height));
            Point point = this.getLocation();
            p.put("package.editor.x", Integer.toString(point.x));
            p.put("package.editor.y", Integer.toString(point.y));
            p.put("package.showUses", new Boolean(this.isShowUses()).toString());
            p.put("package.showExtends", new Boolean(this.isShowExtends()).toString());
        }
        this.pkg.save(p);
        this.setStatus(Config.getString("pkgmgr.packageSaved"));
    }

    public void doImport() {
        String importName = FileUtility.getFileName(this, Config.getString("pkgmgr.importPkg.title"), Config.getString("pkgmgr.importPkg.buttonLabel"), true, null, false);
        if (importName == null) {
            return;
        }
        File importDir = new File(importName);
        if (!importDir.isDirectory()) {
            return;
        }
        if (this.isEmptyFrame()) {
            return;
        }
        this.importProjectDir(new File(importName), true);
    }

    public void doAddFromFile() {
        File[] classes = FileUtility.getMultipleFiles(this, Config.getString("pkgmgr.addClass.title"), Config.getString("pkgmgr.addClass.buttonLabel"), FileUtility.getJavaSourceFilter());
        if (classes == null) {
            return;
        }
        block7: for (int i = 0; i < classes.length; ++i) {
            int result = this.pkg.importFile(classes[i]);
            switch (result) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    DialogManager.showErrorWithText(this, "file-does-not-exist", classes[i].getName());
                    continue block7;
                }
                case 2: {
                    DialogManager.showErrorWithText(this, "cannot-import", classes[i].getName());
                    continue block7;
                }
                case 4: {
                    DialogManager.showErrorWithText(this, "duplicate-name", classes[i].getName());
                    continue block7;
                }
                case 3: {
                    DialogManager.showErrorWithText(this, "error-in-import", classes[i].getName());
                }
            }
        }
    }

    public void doExport() {
        ExportManager exporter = new ExportManager(this);
        exporter.export();
    }

    public void doPageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pfmt = job.pageDialog(PkgMgrFrame.getPageFormat());
        PkgMgrFrame.setPageFormat(pfmt);
    }

    public static PageFormat getPageFormat() {
        if (pageFormat == null) {
            pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        return pageFormat;
    }

    public static void setPageFormat(PageFormat page) {
        pageFormat = page;
    }

    public void doPrint() {
        if (this.projectPrintDialog == null) {
            this.projectPrintDialog = new ProjectPrintDialog(this);
        }
        if (this.projectPrintDialog.display()) {
            PackagePrintManager printManager = new PackagePrintManager(this.getPackage(), PkgMgrFrame.getPageFormat(), this.projectPrintDialog);
            printManager.start();
        }
    }

    public void showPreferences() {
        PrefMgrDialog.showDialog();
    }

    public void aboutBlueJ() {
        AboutBlue about = new AboutBlue(this, "2.2.0");
        about.setVisible(true);
    }

    public void showCopyright() {
        JOptionPane.showMessageDialog(this, new String[]{"BlueJ \u00a9 2000-2007 Michael K\u00f6lling, John Rosenberg.", " ", Config.getString("menu.help.copyright.line1"), Config.getString("menu.help.copyright.line2"), Config.getString("menu.help.copyright.line3"), Config.getString("menu.help.copyright.line4")}, Config.getString("menu.help.copyright.title"), 1);
    }

    private void callMethod(CallableView cv) {
        ResultWatcher watcher = null;
        if (cv instanceof ConstructorView) {
            watcher = new ResultWatcher(){

                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    if (name == null || name.length() == 0) {
                        name = "result";
                    }
                    if (result != null) {
                        ObjectWrapper wrapper = ObjectWrapper.getWrapper(PkgMgrFrame.this, PkgMgrFrame.this.getObjectBench(), result, result.getGenType(), name);
                        PkgMgrFrame.this.getObjectBench().addObject(wrapper);
                        PkgMgrFrame.this.getPackage().getDebugger().addObject(PkgMgrFrame.this.pkg.getId(), wrapper.getName(), result);
                        PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    }
                }

                public void putError(String msg) {
                }

                public void putException(String msg) {
                }

                public void putVMTerminated() {
                }
            };
        } else if (cv instanceof MethodView) {
            final MethodView mv = (MethodView)cv;
            watcher = new ResultWatcher(){
                private ExpressionInformation expressionInformation;
                {
                    this.expressionInformation = new ExpressionInformation(mv, PkgMgrFrame.this.getName());
                }

                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    this.expressionInformation.setArgumentValues(ir.getArgumentValues());
                    PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                    if (name == null) {
                        return;
                    }
                    if (result == null) {
                        return;
                    }
                    ResultInspector viewer = PkgMgrFrame.this.getProject().getResultInspectorInstance(result, name, PkgMgrFrame.this.getPackage(), ir, this.expressionInformation, PkgMgrFrame.this);
                    BlueJEvent.raiseEvent(3, viewer.getResult());
                }

                public void putError(String msg) {
                }

                public void putException(String msg) {
                }

                public void putVMTerminated() {
                }
            };
        }
        new Invoker(this, cv, watcher).invokeInteractive();
    }

    private void openPackageTarget(String newname) {
        Package p = this.getPackage().getProject().getPackage(newname);
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(p);
        if (pmf == null) {
            pmf = PkgMgrFrame.createFrame(p);
            DialogManager.tileWindow(pmf, this);
        }
        pmf.setVisible(true);
    }

    private void objectBenchToTestFixture(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doBenchToFixture(this, target);
        }
    }

    private void testFixtureToObjectBench(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doFixtureToBench(this, target);
        }
    }

    private void makeTestCase(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            if (!testToolsShown) {
                this.showTestingTools(true);
            }
            utcr.doMakeTestCase(this, target);
        }
    }

    public void putObjectOnBench(String newInstanceName, DebuggerObject object, GenTypeClass iType, InvokerRecord ir) {
        if (!object.isNullObject()) {
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(this, this.getObjectBench(), object, iType, newInstanceName);
            this.getObjectBench().addObject(wrapper);
            this.getPackage().getDebugger().addObject(this.pkg.getId(), wrapper.getName(), object);
            if (ir instanceof MethodInvokerRecord) {
                MethodInvokerRecord mir = (MethodInvokerRecord)ir;
                mir.setBenchName(newInstanceName, wrapper.getObject().getClassName());
            }
        }
    }

    public void doCreateNewClass() {
        NewClassDialog dlg = new NewClassDialog(this);
        boolean okay = dlg.display();
        if (okay) {
            String name = dlg.getClassName();
            String template = dlg.getTemplateName();
            this.createNewClass(name, template, true);
        }
    }

    public void doCreateNewPackage() {
        NewPackageDialog dlg = new NewPackageDialog(this);
        boolean okay = dlg.display();
        if (!okay) {
            return;
        }
        String name = dlg.getPackageName();
        if (name.length() == 0) {
            return;
        }
        this.createNewPackage(name, true);
    }

    public boolean createNewPackage(String name, boolean showErrDialog) {
        Package newPackage;
        String fullName = name.indexOf(46) > -1 ? name : this.getPackage().getQualifiedName(name);
        String prefix = JavaNames.getPrefix(fullName);
        String base = JavaNames.getBase(fullName);
        Package basePkg = this.getProject().getPackage(prefix);
        if (basePkg != null && basePkg.getTarget(base) != null) {
            if (showErrDialog) {
                DialogManager.showError(this, "duplicate-name");
            }
            return false;
        }
        this.getProject().createPackageDirectory(fullName);
        if (newPackage == null) {
            Debug.reportError("creation of new package failed unexpectedly");
            return false;
        }
        for (newPackage = this.getProject().getPackage(fullName); newPackage != null; newPackage = newPackage.getParent()) {
            newPackage.reload();
        }
        return true;
    }

    public void doRemove() {
        Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (permanentFocusOwner == this.editor) {
            if (!this.doRemoveTargets() && !this.doRemoveDependency()) {
                DialogManager.showError(this, "no-class-selected");
            }
        } else if (permanentFocusOwner == this.objbench) {
            this.objbench.removeSelectedObject(this.pkg.getId());
        }
    }

    private boolean doRemoveTargets() {
        Target[] targets = this.pkg.getSelectedTargets();
        if (targets.length <= 0) {
            return false;
        }
        if (this.askRemoveClass()) {
            for (int i = 0; i < targets.length; ++i) {
                targets[i].remove();
            }
        }
        return true;
    }

    private boolean doRemoveDependency() {
        Dependency dependency = this.pkg.getSelectedDependency();
        if (dependency == null) {
            return false;
        }
        dependency.remove();
        return true;
    }

    public void doNewUses() {
        this.pkg.setState(1);
        this.setStatus(Config.getString("pkgmgr.chooseUsesFrom"));
        this.pkg.getEditor().clearSelection();
    }

    public void doNewInherits() {
        this.pkg.setState(3);
        this.setStatus(Config.getString("pkgmgr.chooseInhFrom"));
        this.editor.clearSelection();
    }

    public void doTest() {
        this.runButton.setEnabled(false);
        List l = this.pkg.getTestTargets();
        int numTests = 0;
        ListIterator i = l.listIterator();
        while (i.hasNext()) {
            ClassTarget ct = (ClassTarget)i.next();
            if (ct.isCompiled() && !ct.isAbstract()) {
                UnitTestClassRole utcr = (UnitTestClassRole)ct.getRole();
                numTests += utcr.getTestCount(ct);
                continue;
            }
            i.remove();
        }
        Iterator it = l.iterator();
        TestDisplayFrame.getTestDisplay().startMultipleTests(numTests);
        TestRunnerThread trt = new TestRunnerThread(this, it);
        trt.start();
    }

    public void endTestRun() {
        TestDisplayFrame.getTestDisplay().endMultipleTests();
        this.runButton.setEnabled(true);
    }

    public void doEndTest() {
        if (this.testTarget != null) {
            this.testRecordingEnded();
            if (this.testTarget.getRole() instanceof UnitTestClassRole) {
                UnitTestClassRole utcr = (UnitTestClassRole)this.testTarget.getRole();
                utcr.doEndMakeTestCase(this, this.testTarget, this.testTargetMethod);
            }
            this.getPackage().compileQuiet(this.testTarget);
            this.getProject().removeClassLoader();
            this.getProject().newRemoteClassLoader();
            this.testTarget = null;
        }
    }

    public void doCancelTest() {
        this.testRecordingEnded();
        this.getProject().removeClassLoader();
        this.getProject().newRemoteClassLoader();
        this.testTarget = null;
    }

    public void testRecordingStarted(String message) {
        this.recordingLabel.setEnabled(true);
        this.testStatusMessage.setText(message);
        this.endTestButton.setEnabled(true);
        this.endTestMenuItem.setEnabled(true);
        this.cancelTestButton.setEnabled(true);
        this.cancelTestMenuItem.setEnabled(true);
        this.getProject().setTestMode(true);
    }

    private void testRecordingEnded() {
        this.recordingLabel.setEnabled(false);
        this.testStatusMessage.setText("");
        this.endTestButton.setEnabled(false);
        this.endTestMenuItem.setEnabled(false);
        this.cancelTestButton.setEnabled(false);
        this.cancelTestMenuItem.setEnabled(false);
        Project proj = this.getProject();
        if (proj != null) {
            proj.setTestMode(false);
        }
    }

    public void setTestInfo(String testName, ClassTarget testClass) {
        this.testTargetMethod = testName;
        this.testTarget = testClass;
    }

    public boolean askRemoveClass() {
        int response = DialogManager.askQuestion(this, "really-remove-class");
        return response == 0;
    }

    public boolean askRemovePackage(PackageTarget removableTarget) {
        String name = removableTarget.getQualifiedName();
        PkgMgrFrame[] f = PkgMgrFrame.getAllProjectFrames(this.getProject(), name);
        if (f != null) {
            DialogManager.showError(this, "remove-package-open");
            return false;
        }
        int response = DialogManager.askQuestion(this, "really-remove-package");
        return response == 0;
    }

    public void compileSelected() {
        Target[] targets = this.pkg.getSelectedTargets();
        if (targets.length > 0) {
            for (int i = 0; i < targets.length; ++i) {
                ClassTarget t;
                if (!(targets[i] instanceof ClassTarget) || !(t = (ClassTarget)targets[i]).hasSourceCode()) continue;
                this.pkg.compile(t);
            }
        } else {
            DialogManager.showError(this, "no-class-selected-compile");
        }
    }

    public void callLibraryClass() {
        if (this.libraryCallDialog == null) {
            this.libraryCallDialog = new LibraryCallDialog(this);
        }
        this.libraryCallDialog.setVisible(true);
    }

    public void generateProjectDocumentation() {
        String message = this.pkg.generateDocumentation();
        if (message != "") {
            DialogManager.showText(this, message);
        }
    }

    public void showDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().getExecControls().showHide(true);
        }
    }

    public void restartDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().restartVM();
        }
    }

    public void updateShowUsesInPackage() {
        this.pkg.setShowUses(this.isShowUses());
        this.editor.repaint();
    }

    public void updateShowExtendsInPackage() {
        this.pkg.setShowExtends(this.isShowExtends());
        this.editor.repaint();
    }

    public boolean isShowUses() {
        return this.showUsesMenuItem.isSelected();
    }

    public boolean isShowExtends() {
        return this.showExtendsMenuItem.isSelected();
    }

    public void showTestingTools(boolean show) {
        Iterator it = this.testItems.iterator();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            component.setVisible(show);
        }
    }

    public void showTeamTools(boolean show) {
        Iterator it = this.teamItems.iterator();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            component.setVisible(show);
        }
    }

    public void updateSharedStatus(boolean shared) {
        this.updateWindowTitle();
    }

    public boolean isTextEvalVisible() {
        return this.showingTextEvaluator;
    }

    public void showHideTextEval(boolean show) {
        if (this.showingTextEvaluator == show) {
            return;
        }
        if (show) {
            this.addTextEvaluatorPane();
            this.textEvaluator.requestFocus();
        } else {
            this.removeTextEvaluatorPane();
            this.editor.requestFocus();
        }
        this.pack();
        this.showingTextEvaluator = show;
    }

    public void clearTextEval() {
        if (this.textEvaluator != null) {
            this.textEvaluator.clear();
        }
    }

    public void blueJEvent(int eventId, Object arg) {
        switch (eventId) {
            case 0: {
                this.setStatus(Config.getString("pkgmgr.creatingVM"));
                break;
            }
            case 2: {
                this.setStatus(Config.getString("pkgmgr.creatingVMDone"));
                break;
            }
            case 6: {
                this.setStatus(Config.getString("pkgmgr.generatingDocu"));
                break;
            }
            case 7: {
                this.setStatus(Config.getString("pkgmgr.docuGenerated"));
                break;
            }
            case 8: {
                this.setStatus(Config.getString("pkgmgr.docuAborted"));
                break;
            }
            case 1: {
                DialogManager.showError(this, "error-create-vm");
                this.doQuit();
            }
        }
    }

    public void setDebuggerState(int state) {
        switch (state) {
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                if (this.machineIcon != null) {
                    this.machineIcon.setIdle();
                }
                this.getProject().getTerminal().activate(false);
                break;
            }
            case 3: {
                if (this.machineIcon != null) {
                    this.machineIcon.setRunning();
                }
                this.getProject().getTerminal().activate(true);
                break;
            }
            case 4: {
                if (this.machineIcon == null) break;
                this.machineIcon.setStopped();
            }
        }
    }

    public String toString() {
        String str = "PkgMgrFrame(): ";
        str = this.isEmptyFrame() ? str + "empty" : str + this.getPackage().toString() + " " + this.getProject().toString();
        return str;
    }

    public void showWebPage(String url) {
        if (Utility.openWebBrowser(url)) {
            this.setStatus(Config.getString("pkgmgr.webBrowserMsg"));
        } else {
            this.setStatus(Config.getString("pkgmgr.webBrowserError"));
        }
    }

    private void makeFrame() {
        this.setFont(this.PkgMgrFont);
        this.setIconImage(BlueJTheme.getIconImage());
        this.testItems = new ArrayList();
        this.teamItems = new ArrayList();
        this.setupMenus();
        Container contentPane = this.getContentPane();
        ((JPanel)contentPane).setBorder(BlueJTheme.generalBorderWithStatusBar);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        PkgMgrAction action = RestartVMAction.getInstance();
        mainPanel.getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), "restartVM");
        mainPanel.getActionMap().put("restartVM", action);
        JPanel toolPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        AbstractButton button = this.createButton(this.newClassAction, false, false, 4, 4);
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.imgDependsButton = this.createButton(this.newUsesAction, true, false, 4, 4);
        this.buttonPanel.add(this.imgDependsButton);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.imgExtendsButton = this.createButton(this.newInheritsAction, true, false, 4, 4);
        this.buttonPanel.add(this.imgExtendsButton);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        button = this.createButton(this.compileAction, false, false, 4, 4);
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createVerticalStrut(3));
        this.buttonPanel.setAlignmentX(0.5f);
        this.testPanel = new JPanel();
        this.testPanel.setLayout(new BoxLayout(this.testPanel, 1));
        this.testPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 14, 5));
        this.runButton = this.createButton(this.runTestsAction, false, false, 2, 4);
        this.runButton.setText(Config.getString("pkgmgr.test.run"));
        this.runButton.setAlignmentX(0.15f);
        this.testPanel.add(this.runButton);
        this.testPanel.add(Box.createVerticalStrut(8));
        this.recordingLabel = new JLabel(Config.getString("pkgmgr.test.record"), Config.getImageAsIcon("image.test.recording"), 10);
        this.recordingLabel.setFont(this.PkgMgrFont);
        this.recordingLabel.setEnabled(false);
        this.recordingLabel.setAlignmentX(0.15f);
        this.testPanel.add(this.recordingLabel);
        this.testPanel.add(Box.createVerticalStrut(3));
        action = EndTestRecordAction.getInstance();
        this.endTestButton = this.createButton(action, false, false, 2, 4);
        this.endTestButton.setText(Config.getString("pkgmgr.test.end"));
        this.endTestButton.setEnabled(false);
        this.testPanel.add(this.endTestButton);
        this.testPanel.add(Box.createVerticalStrut(3));
        action = CancelTestRecordAction.getInstance();
        this.cancelTestButton = this.createButton(action, false, false, 2, 4);
        this.cancelTestButton.setText(Config.getString("cancel"));
        this.cancelTestButton.setEnabled(false);
        this.testPanel.add(this.cancelTestButton);
        this.testPanel.setAlignmentX(0.5f);
        this.testItems.add(this.testPanel);
        this.teamPanel = new JPanel();
        this.teamPanel.setLayout(new BoxLayout(this.teamPanel, 1));
        this.teamPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 14, 5));
        this.updateButton = this.createButton(this.teamActions.getUpdateAction(), false, false, 2, 4);
        this.updateButton.setAlignmentX(0.15f);
        this.teamPanel.add(this.updateButton);
        this.teamPanel.add(Box.createVerticalStrut(3));
        this.commitButton = this.createButton(this.teamActions.getCommitCommentAction(), false, false, 2, 4);
        this.commitButton.setAlignmentX(0.15f);
        this.teamPanel.add(this.commitButton);
        this.teamPanel.add(Box.createVerticalStrut(3));
        this.teamStatusButton = this.createButton(this.teamActions.getStatusAction(), false, false, 2, 4);
        this.teamStatusButton.setAlignmentX(0.15f);
        this.teamPanel.add(this.teamStatusButton);
        this.teamPanel.add(Box.createVerticalStrut(3));
        this.teamPanel.setAlignmentX(0.5f);
        this.teamItems.add(this.teamPanel);
        this.machineIcon = new MachineIcon();
        this.machineIcon.setAlignmentX(0.5f);
        this.itemsToDisable.add(this.machineIcon);
        toolPanel.setLayout(new BoxLayout(toolPanel, 1));
        toolPanel.add(this.buttonPanel);
        toolPanel.add(Box.createVerticalGlue());
        toolPanel.add(this.teamPanel);
        toolPanel.add(this.testPanel);
        toolPanel.add(this.machineIcon);
        mainPanel.add((Component)toolPanel, "West");
        this.classScroller = new JScrollPane();
        this.classScroller.setBorder(Config.normalBorder);
        this.classScroller.setPreferredSize(new Dimension(560, 400));
        this.classScroller.setSize(new Dimension(560, 400));
        this.classScroller.setFocusable(false);
        this.classScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.classScroller.getHorizontalScrollBar().setUnitIncrement(20);
        mainPanel.add((Component)this.classScroller, "Center");
        this.itemsToDisable.add(this.objbench);
        this.splitPane = new JSplitPane(0, mainPanel, this.objbench);
        this.splitPane.setBorder(null);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(5);
        contentPane.add((Component)this.splitPane, "Center");
        JPanel statusArea = new JPanel(new BorderLayout());
        statusArea.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 6));
        this.statusbar = new JLabel(" ");
        this.statusbar.setFont(this.PkgMgrFont);
        statusArea.add((Component)this.statusbar, "Center");
        this.testStatusMessage = new JLabel(" ");
        this.testStatusMessage.setFont(this.PkgMgrFont);
        statusArea.add((Component)this.testStatusMessage, "West");
        this.progressbar = new ActivityIndicator();
        this.progressbar.setRunning(false);
        statusArea.add((Component)this.progressbar, "East");
        contentPane.add((Component)statusArea, "South");
        if (!testToolsShown) {
            this.showTestingTools(false);
        }
        if (!teamToolsShown) {
            this.showTeamTools(false);
        }
        if (PrefMgr.getFlag("bluej.startWithTextEval")) {
            this.addTextEvaluatorPane();
        }
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                PkgMgrFrame pmf = (PkgMgrFrame)E.getWindow();
                pmf.doClose(false);
            }
        });
        if (this.isEmptyFrame()) {
            this.enableFunctions(false);
        }
    }

    private void addTextEvaluatorPane() {
        this.classScroller.setPreferredSize(this.classScroller.getSize());
        if (this.textEvaluator == null) {
            this.textEvaluator = new TextEvalArea(this, this.PkgMgrFont);
            this.objectBenchSplitPane = new JSplitPane(1, this.objbench, this.textEvaluator);
            this.objectBenchSplitPane.setBorder(null);
            this.objectBenchSplitPane.setResizeWeight(1.0);
            this.objectBenchSplitPane.setDividerSize(5);
            this.itemsToDisable.add(this.textEvaluator);
        } else {
            this.objectBenchSplitPane.setLeftComponent(this.objbench);
        }
        this.splitPane.setBottomComponent(this.objectBenchSplitPane);
        this.showingTextEvaluator = true;
    }

    private void removeTextEvaluatorPane() {
        this.textEvaluator.setPreferredSize(this.textEvaluator.getSize());
        this.classScroller.setPreferredSize(this.classScroller.getSize());
        this.splitPane.setBottomComponent(this.objbench);
        this.showingTextEvaluator = false;
    }

    private AbstractButton createButton(Action action, boolean notext, boolean toggle, int hSpacing, int vSpacing) {
        AbstractButton button = toggle ? new JToggleButton(action) : new JButton(action);
        button.setFont(this.PkgMgrFont);
        button.putClientProperty("JButton.buttonType", "toolbar");
        button.setFocusable(false);
        if (notext) {
            button.setText(null);
        }
        Dimension pref = button.getMinimumSize();
        pref.width = Integer.MAX_VALUE;
        button.setMaximumSize(pref);
        button.setMargin(new Insets(vSpacing, hSpacing, vSpacing, hSpacing));
        return button;
    }

    private void setupMenus() {
        this.menubar = new JMenuBar();
        this.itemsToDisable = new ArrayList();
        JMenu menu = new JMenu(Config.getString("menu.package"));
        int mnemonic = Config.getMnemonicKey("menu.package");
        menu.setMnemonic(mnemonic);
        this.menubar.add(menu);
        this.createMenuItem(NewProjectAction.getInstance(), menu);
        this.createMenuItem(OpenProjectAction.getInstance(), menu);
        this.recentProjectsMenu = new JMenu(Config.getString("menu.package.openRecent"));
        menu.add(this.recentProjectsMenu);
        this.createMenuItem(OpenNonBlueJAction.getInstance(), menu);
        this.createMenuItem(this.closeProjectAction, menu);
        this.createMenuItem(this.saveProjectAction, menu);
        this.createMenuItem(this.saveProjectAsAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.importProjectAction, menu);
        this.createMenuItem(this.exportProjectAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.pageSetupAction, menu);
        this.createMenuItem(this.printAction, menu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(QuitAction.getInstance(), menu);
        }
        menu = new JMenu(Config.getString("menu.edit"));
        menu.setMnemonic(Config.getMnemonicKey("menu.edit"));
        this.menubar.add(menu);
        this.createMenuItem(this.newClassAction, menu);
        this.createMenuItem(this.newPackageAction, menu);
        this.createMenuItem(this.addClassAction, menu);
        this.createMenuItem(this.removeAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.newUsesAction, menu);
        this.createMenuItem(this.newInheritsAction, menu);
        menu = new JMenu(Config.getString("menu.tools"));
        menu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.menubar.add(menu);
        this.createMenuItem(this.compileAction, menu);
        this.createMenuItem(this.compileSelectedAction, menu);
        this.createMenuItem(this.rebuildAction, menu);
        menu.addSeparator();
        this.createMenuItem(this.useLibraryAction, menu);
        this.createMenuItem(this.generateDocsAction, menu);
        this.testingMenu = new JMenu(Config.getString("menu.tools.testing"));
        this.testingMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        this.createMenuItem(this.runTestsAction, this.testingMenu);
        this.endTestMenuItem = this.createMenuItem(EndTestRecordAction.getInstance(), this.testingMenu);
        this.cancelTestMenuItem = this.createMenuItem(CancelTestRecordAction.getInstance(), this.testingMenu);
        this.endTestMenuItem.setEnabled(false);
        this.cancelTestMenuItem.setEnabled(false);
        this.testItems.add(this.testingMenu);
        menu.add(this.testingMenu);
        this.teamMenu = new JMenu(Config.getString("menu.tools.teamwork"));
        this.teamMenu.setMnemonic(Config.getMnemonicKey("menu.tools"));
        CheckoutAction checkoutAction = CheckoutAction.getInstance();
        this.createMenuItem(checkoutAction, this.teamMenu);
        this.shareProjectMenuItem = this.createMenuItem(this.teamActions.getImportAction(), this.teamMenu);
        this.teamMenu.addSeparator();
        this.updateMenuItem = this.createMenuItem(this.teamActions.getUpdateAction(), this.teamMenu);
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.commitMenuItem = this.createMenuItem(this.teamActions.getCommitCommentAction(), this.teamMenu);
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.statusMenuItem = this.createMenuItem(this.teamActions.getStatusAction(), this.teamMenu);
        this.showLogMenuItem = this.createMenuItem(this.teamActions.getShowLogAction(), this.teamMenu);
        this.teamMenu.addSeparator();
        this.teamSettingsMenuItem = this.createMenuItem(this.teamActions.getTeamSettingsAction(), this.teamMenu);
        this.teamItems.add(this.teamMenu);
        menu.add(this.teamMenu);
        if (!Config.usingMacScreenMenubar()) {
            menu.addSeparator();
            this.createMenuItem(PreferencesAction.getInstance(), menu);
        }
        this.menuManager = new MenuManager(menu.getPopupMenu());
        if (frames.size() <= 1) {
            this.menuManager.addExtensionMenu(null);
        }
        menu = new JMenu(Config.getString("menu.view"));
        menu.setMnemonic(Config.getMnemonicKey("menu.view"));
        this.menubar.add(menu);
        this.showUsesMenuItem = this.createCheckboxMenuItem(this.showUsesAction, menu, true);
        this.showExtendsMenuItem = this.createCheckboxMenuItem(this.showInheritsAction, menu, true);
        menu.addSeparator();
        this.createCheckboxMenuItem(this.showDebuggerAction, menu, false);
        this.createCheckboxMenuItem(this.showTerminalAction, menu, false);
        this.createCheckboxMenuItem(this.showTextEvalAction, menu, false);
        JSeparator testSeparator = new JSeparator();
        this.testItems.add(testSeparator);
        menu.add(testSeparator);
        this.showTestResultsItem = this.createCheckboxMenuItem(ShowTestResultsAction.getInstance(), menu, false);
        this.testItems.add(this.showTestResultsItem);
        menu = new JMenu(Config.getString("menu.help"));
        menu.setMnemonic(Config.getMnemonicKey("menu.help"));
        this.menubar.add(menu);
        if (!Config.usingMacScreenMenubar()) {
            this.createMenuItem(HelpAboutAction.getInstance(), menu);
        }
        this.createMenuItem(CheckVersionAction.getInstance(), menu);
        this.createMenuItem(CheckExtensionsAction.getInstance(), menu);
        this.createMenuItem(ShowCopyrightAction.getInstance(), menu);
        menu.addSeparator();
        this.createMenuItem(WebsiteAction.getInstance(), menu);
        this.createMenuItem(TutorialAction.getInstance(), menu);
        this.createMenuItem(StandardAPIHelpAction.getInstance(), menu);
        this.addUserHelpItems(menu);
        this.updateRecentProjects();
        this.setJMenuBar(this.menubar);
    }

    private JMenuItem createMenuItem(Action action, JMenu menu) {
        JMenuItem item = menu.add(action);
        item.setIcon(null);
        return item;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(PkgMgrAction action, JMenu menu, boolean selected) {
        ButtonModel bmodel = action.getToggleModel(this);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        if (bmodel != null) {
            item.setModel(action.getToggleModel(this));
        } else {
            item.setState(selected);
        }
        menu.add(item);
        return item;
    }

    public void menuCall() {
        if (!this.isEmptyFrame()) {
            this.pkg.setState(0);
        }
        this.clearStatus();
    }

    private void setupActionDisableSet() {
        this.actionsToDisable = new ArrayList();
        this.actionsToDisable.add(this.closeProjectAction);
        this.actionsToDisable.add(this.saveProjectAction);
        this.actionsToDisable.add(this.saveProjectAsAction);
        this.actionsToDisable.add(this.importProjectAction);
        this.actionsToDisable.add(this.exportProjectAction);
        this.actionsToDisable.add(this.pageSetupAction);
        this.actionsToDisable.add(this.printAction);
        this.actionsToDisable.add(this.newClassAction);
        this.actionsToDisable.add(this.newPackageAction);
        this.actionsToDisable.add(this.addClassAction);
        this.actionsToDisable.add(this.removeAction);
        this.actionsToDisable.add(this.newUsesAction);
        this.actionsToDisable.add(this.newInheritsAction);
        this.actionsToDisable.add(this.compileAction);
        this.actionsToDisable.add(this.compileSelectedAction);
        this.actionsToDisable.add(this.rebuildAction);
        this.actionsToDisable.add(this.useLibraryAction);
        this.actionsToDisable.add(this.generateDocsAction);
        this.actionsToDisable.add(this.showUsesAction);
        this.actionsToDisable.add(this.showInheritsAction);
        this.actionsToDisable.add(this.showDebuggerAction);
        this.actionsToDisable.add(this.showTerminalAction);
        this.actionsToDisable.add(this.showTextEvalAction);
        this.actionsToDisable.add(this.runTestsAction);
    }

    private void addUserHelpItems(JMenu menu) {
        String helpItems = Config.getPropString("bluej.help.items", "");
        if (helpItems != null && helpItems.length() > 0) {
            menu.addSeparator();
            URLDisplayer urlDisplayer = new URLDisplayer();
            StringTokenizer t = new StringTokenizer(helpItems);
            while (t.hasMoreTokens()) {
                String itemID = t.nextToken();
                String itemName = Config.getPropString("bluej.help." + itemID + ".label");
                String itemURL = Config.getPropString("bluej.help." + itemID + ".url");
                JMenuItem item = new JMenuItem(itemName);
                item.setActionCommand(itemURL);
                item.addActionListener(urlDisplayer);
                menu.add(item);
            }
        }
    }

    private void updateRecentProjects() {
        ProjectOpener opener = new ProjectOpener();
        this.recentProjectsMenu.removeAll();
        List projects = PrefMgr.getRecentProjects();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            JMenuItem item = this.recentProjectsMenu.add((String)it.next());
            item.addActionListener(opener);
        }
    }

    protected void enableFunctions(boolean enable) {
        if (!enable) {
            this.teamActions.setAllDisabled();
        }
        Iterator it = this.itemsToDisable.iterator();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            component.setEnabled(enable);
        }
        it = this.actionsToDisable.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            action.setEnabled(enable);
        }
    }

    class ProjectOpener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String project = evt.getActionCommand();
            if (!PkgMgrFrame.this.openProject(project)) {
                PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.error.open"));
            }
        }
    }

    class URLDisplayer
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String url = evt.getActionCommand();
            PkgMgrFrame.this.showWebPage(url);
        }
    }
}

