/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.CompilerWarningDialog;
import bluej.compiler.EventqueueCompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.CallHistory;
import bluej.editor.Editor;
import bluej.editor.LineColumn;
import bluej.extensions.BPackage;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.graph.Edge;
import bluej.graph.Graph;
import bluej.graph.Vertex;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.ParentPackageTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.TargetCollection;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.MultiIterator;
import bluej.utility.SortedProperties;
import bluej.utility.filefilter.JavaClassFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import bluej.utility.filefilter.SubPackageFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public final class Package
extends Graph {
    static final String compiling = Config.getString("pkgmgr.compiling");
    static final String compileDone = Config.getString("pkgmgr.compileDone");
    static final String chooseUsesTo = Config.getString("pkgmgr.chooseUsesTo");
    static final String chooseInhTo = Config.getString("pkgmgr.chooseInhTo");
    public static final String pkgfileName = "bluej.pkg";
    public static final String readmeName = "README.TXT";
    public static final int NO_ERROR = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int ILLEGAL_FORMAT = 2;
    public static final int COPY_ERROR = 3;
    public static final int CLASS_EXISTS = 4;
    public static final int CREATE_ERROR = 5;
    public static final int FIXED_TARGET_X = 10;
    public static final int FIXED_TARGET_Y = 10;
    private Project project;
    private Package parentPackage = null;
    private String baseName = "";
    private SortedProperties lastSavedProps = new SortedProperties();
    private TargetCollection targets;
    private List usesArrows;
    private List extendsArrows;
    private DependentTarget fromChoice;
    private CallHistory callHistory;
    private boolean showExtends = true;
    private boolean showUses = true;
    private String lastSourceName = "";
    public static final int S_IDLE = 0;
    public static final int S_CHOOSE_USES_FROM = 1;
    public static final int S_CHOOSE_USES_TO = 2;
    public static final int S_CHOOSE_EXT_FROM = 3;
    public static final int S_CHOOSE_EXT_TO = 4;
    public static final int HISTORY_LENGTH = 6;
    private int state = 0;
    private PackageEditor editor;
    private BPackage singleBPackage;

    public Package(Project project, String baseName, Package parent) throws IOException {
        if (parent == null) {
            throw new NullPointerException("Package must have a valid parent package");
        }
        if (baseName.length() == 0) {
            throw new IllegalArgumentException("unnamedPackage must be created using Package(project)");
        }
        if (!JavaNames.isIdentifier(baseName)) {
            throw new IllegalArgumentException(baseName + " is not a valid name for a Package");
        }
        this.project = project;
        this.baseName = baseName;
        this.parentPackage = parent;
        this.init();
    }

    public Package(Project project) throws IOException {
        this.project = project;
        this.baseName = "";
        this.parentPackage = null;
        this.init();
    }

    private void init() throws IOException {
        this.targets = new TargetCollection();
        this.usesArrows = new ArrayList();
        this.extendsArrows = new ArrayList();
        this.callHistory = new CallHistory(6);
        this.load();
    }

    public boolean isUnnamedPackage() {
        return this.parentPackage == null;
    }

    public Project getProject() {
        return this.project;
    }

    public final synchronized BPackage getBPackage() {
        if (this.singleBPackage == null) {
            this.singleBPackage = ExtensionBridge.newBPackage((Package)this);
        }
        return this.singleBPackage;
    }

    public String getId() {
        return this.getPath().getPath();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getQualifiedName(String identifier) {
        if (this.isUnnamedPackage()) {
            return identifier;
        }
        return this.getQualifiedName() + "." + identifier;
    }

    public String getQualifiedName() {
        Package currentPkg = this;
        String retName = "";
        while (!currentPkg.isUnnamedPackage()) {
            retName = retName == "" ? currentPkg.getBaseName() : currentPkg.getBaseName() + "." + retName;
            currentPkg = currentPkg.getParent();
        }
        return retName;
    }

    public ReadmeTarget getReadmeTarget() {
        ReadmeTarget readme = (ReadmeTarget)this.targets.get("@README");
        return readme;
    }

    private File getRelativePath() {
        Package currentPkg = this;
        File retFile = new File(currentPkg.getBaseName());
        while (!currentPkg.isUnnamedPackage()) {
            currentPkg = currentPkg.getParent();
            retFile = new File(currentPkg.getBaseName(), retFile.getPath());
        }
        return retFile;
    }

    public File getPath() {
        return new File(this.project.getProjectDir(), this.getRelativePath().getPath());
    }

    public Package getParent() {
        return this.parentPackage;
    }

    protected Package getBoringSubPackage() {
        PackageTarget pt = null;
        Iterator e = this.targets.iterator();
        while (e.hasNext()) {
            Target target = (Target)e.next();
            if (target instanceof ClassTarget) {
                return null;
            }
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            if (pt != null) {
                return null;
            }
            pt = (PackageTarget)target;
        }
        if (pt == null) {
            return null;
        }
        return this.getProject().getPackage(pt.getQualifiedName());
    }

    protected List getChildren(boolean getUncached) {
        ArrayList<Package> children = new ArrayList<Package>();
        Iterator e = this.targets.iterator();
        while (e.hasNext()) {
            Target target = (Target)e.next();
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            PackageTarget pt = (PackageTarget)target;
            Package child = getUncached ? this.getProject().getPackage(pt.getQualifiedName()) : this.getProject().getCachedPackage(pt.getQualifiedName());
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    public void setStatus(String msg) {
        PkgMgrFrame.displayMessage(this, msg);
    }

    public void repaint() {
        if (this.editor != null) {
            this.editor.repaint();
        }
    }

    void setEditor(PackageEditor editor) {
        this.editor = editor;
    }

    public PackageEditor getEditor() {
        return this.editor;
    }

    public Properties getLastSavedProperties() {
        return this.lastSavedProps;
    }

    public Target[] getSelectedTargets() {
        Target[] targetArray = new Target[]{};
        LinkedList<Vertex> list = new LinkedList<Vertex>();
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            Vertex vertex = (Vertex)it.next();
            if (!(vertex instanceof Target) || !((Target)vertex).isSelected()) continue;
            list.add(vertex);
        }
        return list.toArray(targetArray);
    }

    public Dependency getSelectedDependency() {
        Iterator it = this.getEdges();
        while (it.hasNext()) {
            Dependency dependency;
            Edge edge = (Edge)it.next();
            if (!(edge instanceof Dependency) || !(dependency = (Dependency)edge).isSelected()) continue;
            return dependency;
        }
        return null;
    }

    private Set findTargets(File path) {
        int i;
        File[] srcFiles = path.listFiles(new JavaSourceFilter());
        File[] classFiles = path.listFiles(new JavaClassFilter());
        HashSet<String> interestingSet = new HashSet<String>();
        for (i = 0; i < srcFiles.length; ++i) {
            if (srcFiles[i].getName().startsWith("__SHELL")) {
                srcFiles[i].delete();
                continue;
            }
            String javaFileName = JavaNames.stripSuffix(srcFiles[i].getName(), ".java");
            if (!JavaNames.isIdentifier(javaFileName) || javaFileName.indexOf(36) != -1) continue;
            interestingSet.add(javaFileName);
        }
        for (i = 0; i < classFiles.length; ++i) {
            if (classFiles[i].getName().startsWith("__SHELL")) {
                classFiles[i].delete();
                continue;
            }
            String classFileName = JavaNames.stripSuffix(classFiles[i].getName(), ".class");
            if (!JavaNames.isIdentifier(classFileName) || classFileName.indexOf(36) != -1 || interestingSet.contains(classFileName)) continue;
            try {
                Class c = this.loadClass(this.getQualifiedName(classFileName));
                if (c == null || !Modifier.isPublic(c.getModifiers())) continue;
                interestingSet.add(classFileName);
                continue;
            }
            catch (LinkageError e) {
                Debug.message(e.toString());
            }
        }
        return interestingSet;
    }

    private void load() throws IOException {
        int i;
        ClassTarget ct;
        Target target;
        File pkgFile = new File(this.getPath(), pkgfileName);
        FileInputStream input = new FileInputStream(pkgFile);
        this.lastSavedProps.load(input);
        input.close();
        HashMap<String, Target> propTargets = new HashMap<String, Target>();
        int numTargets = 0;
        int numDependencies = 0;
        try {
            numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            numDependencies = Integer.parseInt(this.lastSavedProps.getProperty("package.numDependencies", "0"));
        }
        catch (Exception e) {
            Debug.reportError("Error loading from bluej.pkg file " + pkgFile + ": " + e);
            e.printStackTrace();
            return;
        }
        for (int i2 = 0; i2 < numTargets; ++i2) {
            String type = this.lastSavedProps.getProperty("target" + (i2 + 1) + ".type");
            String identifierName = this.lastSavedProps.getProperty("target" + (i2 + 1) + ".name");
            Target target2 = "PackageTarget".equals(type) ? new PackageTarget(this, identifierName) : new ClassTarget(this, identifierName);
            target2.load(this.lastSavedProps, "target" + (i2 + 1));
            propTargets.put(identifierName, target2);
        }
        this.addImmovableTargets();
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i3 = 0; i3 < subDirs.length; ++i3) {
            if (!JavaNames.isIdentifier(subDirs[i3].getName())) continue;
            Target target3 = (Target)propTargets.get(subDirs[i3].getName());
            if (target3 == null || !(target3 instanceof PackageTarget)) {
                target3 = new PackageTarget(this, subDirs[i3].getName());
                this.findSpaceForVertex(target3);
            }
            this.addTarget(target3);
        }
        Set interestingSet = this.findTargets(this.getPath());
        Iterator it = interestingSet.iterator();
        while (it.hasNext()) {
            String targetName = (String)it.next();
            target = (Target)propTargets.get(targetName);
            if (target == null || !(target instanceof ClassTarget)) {
                target = new ClassTarget(this, targetName);
                this.findSpaceForVertex(target);
            }
            this.addTarget(target);
        }
        Iterator targetIt = this.targets.iterator();
        while (targetIt.hasNext()) {
            target = targetIt.next();
            if (!(target instanceof ClassTarget)) continue;
            try {
                ct = (ClassTarget)target;
                if (!ct.hasSourceCode()) continue;
                ct.analyseSource();
                ct.enforcePackage(this.getQualifiedName());
            }
            catch (IOException ioe) {
                Debug.message(ioe.getLocalizedMessage());
            }
            catch (ClassCastException cce) {}
        }
        for (i = 0; i < numDependencies; ++i) {
            UsesDependency dep = null;
            String type = this.lastSavedProps.getProperty("dependency" + (i + 1) + ".type");
            if ("UsesDependency".equals(type)) {
                dep = new UsesDependency(this);
            }
            if (dep == null) continue;
            ((Dependency)dep).load(this.lastSavedProps, "dependency" + (i + 1));
            this.addDependency(dep, false);
        }
        this.recalcArrows();
        for (i = 0; i < numTargets; ++i) {
            String assoc = this.lastSavedProps.getProperty("target" + (i + 1) + ".association");
            String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
            if (assoc == null) continue;
            Target t1 = this.getTarget(identifierName);
            Target t2 = this.getTarget(assoc);
            if (t1 == null || t2 == null || !(t1 instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t1;
            dt.setAssociation((DependentTarget)t2);
        }
        it = this.targets.iterator();
        while (it.hasNext()) {
            Target target4 = (Target)it.next();
            if (!(target4 instanceof ClassTarget)) continue;
            ct = (ClassTarget)target4;
            Class cl = this.loadClass(ct.getQualifiedName());
            ct.determineRole(cl);
            if (cl == null || !ct.upToDate()) continue;
            ct.setState(0);
        }
    }

    public void positionNewTarget(Target t) {
        String targetName = t.getIdentifierName();
        try {
            int numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            for (int i = 0; i < numTargets; ++i) {
                String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
                if (!identifierName.equals(targetName)) continue;
                t.load(this.lastSavedProps, "target" + (i + 1));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.findSpaceForVertex(t);
    }

    private void addImmovableTargets() {
        Target t = new ReadmeTarget(this);
        ((Target)t).load(this.lastSavedProps, "readme");
        t.setPos(10, 10);
        this.addTarget(t);
        if (!this.isUnnamedPackage()) {
            t = new ParentPackageTarget(this);
            this.findSpaceForVertex(t);
            this.addTarget(t);
        }
    }

    public void reload() {
        ClassTarget ct;
        Target target;
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            Target target2;
            if (!JavaNames.isIdentifier(subDirs[i].getName()) || (target2 = this.targets.get(subDirs[i].getName())) != null) continue;
            PackageTarget newtarget = this.addPackage(subDirs[i].getName());
            this.findSpaceForVertex(newtarget);
        }
        Set interestingSet = this.findTargets(this.getPath());
        Iterator it = interestingSet.iterator();
        while (it.hasNext()) {
            String targetName = (String)it.next();
            Target target3 = this.targets.get(targetName);
            if (target3 != null) continue;
            ClassTarget newtarget = this.addClass(targetName);
            this.findSpaceForVertex(newtarget);
        }
        it = this.targets.iterator();
        while (it.hasNext()) {
            target = (Target)it.next();
            if (!(target instanceof ClassTarget)) continue;
            ct = (ClassTarget)target;
            ct.analyseSource();
        }
        it = this.targets.iterator();
        while (it.hasNext()) {
            Class cl;
            target = (Target)it.next();
            if (!(target instanceof ClassTarget) || (cl = this.loadClass((ct = (ClassTarget)target).getQualifiedName())) == null) continue;
            ct.determineRole(cl);
            if (ct.upToDate()) {
                ct.setState(0);
                continue;
            }
            ct.setState(1);
        }
        this.graphChanged();
    }

    public void reReadGraphLayout() throws IOException {
        File pkgFile = new File(this.getPath(), pkgfileName);
        FileInputStream input = new FileInputStream(pkgFile);
        SortedProperties props = new SortedProperties();
        props.load(input);
        input.close();
        int numTargets = 0;
        try {
            numTargets = Integer.parseInt(props.getProperty("package.numTargets", "0"));
        }
        catch (Exception e) {
            Debug.reportError("Error loading from bluej.pkg file " + pkgFile + ": " + e);
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            Target target = null;
            String identifierName = props.getProperty("target" + (i + 1) + ".name");
            int x = Integer.parseInt(props.getProperty("target" + (i + 1) + ".x"));
            int y = Integer.parseInt(props.getProperty("target" + (i + 1) + ".y"));
            int height = Integer.parseInt(props.getProperty("target" + (i + 1) + ".height"));
            int width = Integer.parseInt(props.getProperty("target" + (i + 1) + ".width"));
            target = this.getTarget(identifierName);
            if (target == null) continue;
            target.setPos(x, y);
            target.setSize(width, height);
        }
        this.repaint();
    }

    public boolean save(Properties frameProperties) {
        File dir = this.getPath();
        if (!dir.exists() && !dir.mkdir()) {
            Debug.reportError("Error creating directory " + dir);
            return false;
        }
        File file = new File(dir, pkgfileName);
        if (!file.canWrite()) {
            return false;
        }
        SortedProperties props = new SortedProperties();
        if (frameProperties != null) {
            props.putAll((Map<?, ?>)frameProperties);
        }
        props.put("package.numDependencies", String.valueOf(this.usesArrows.size()));
        int t_count = 0;
        Iterator t_enum = this.targets.iterator();
        int i = 0;
        while (t_enum.hasNext()) {
            Target t = (Target)t_enum.next();
            if (t.isSaveable()) {
                t.save(props, "target" + (t_count + 1));
                ++t_count;
            }
            ++i;
        }
        props.put("package.numTargets", String.valueOf(t_count));
        Target t = this.getTarget("@README");
        t.save(props, "readme");
        for (int i2 = 0; i2 < this.usesArrows.size(); ++i2) {
            Dependency d = (Dependency)this.usesArrows.get(i2);
            d.save(props, "dependency" + (i2 + 1));
        }
        try {
            FileOutputStream output = new FileOutputStream(file);
            props.store(output, "BlueJ package file");
            output.close();
        }
        catch (IOException e) {
            Debug.reportError("Error saving project file " + file + ": " + e);
            return false;
        }
        this.lastSavedProps = props;
        return true;
    }

    public int importFile(File aFile) {
        if (!aFile.exists()) {
            return 1;
        }
        String fileName = aFile.getName();
        if (!fileName.endsWith(".java")) {
            return 2;
        }
        String className = fileName.substring(0, fileName.length() - 5);
        if (this.getTarget(className) != null) {
            return 4;
        }
        File destFile = new File(this.getPath(), fileName);
        if (!FileUtility.copyFile(aFile, destFile)) {
            return 3;
        }
        ClassTarget t = this.addClass(className);
        this.findSpaceForVertex(t);
        t.analyseSource();
        return 0;
    }

    public ClassTarget addClass(String className) {
        ClassTarget target = new ClassTarget(this, className);
        this.addTarget(target);
        try {
            target.enforcePackage(this.getQualifiedName());
        }
        catch (IOException ioe) {
            Debug.message(ioe.getLocalizedMessage());
        }
        return target;
    }

    public PackageTarget addPackage(String packageName) {
        PackageTarget target = new PackageTarget(this, packageName);
        this.addTarget(target);
        return target;
    }

    public Debugger getDebugger() {
        return this.getProject().getDebugger();
    }

    public Class loadClass(String className) {
        return this.getProject().loadClass(className);
    }

    public Iterator getVertices() {
        return this.targets.sortediterator();
    }

    public Iterator getEdges() {
        ArrayList iterations = new ArrayList();
        if (this.showUses) {
            iterations.add(this.usesArrows.iterator());
        }
        if (this.showExtends) {
            iterations.add(this.extendsArrows.iterator());
        }
        return new MultiIterator(iterations);
    }

    public List getTestTargets() {
        ArrayList<ClassTarget> l = new ArrayList<ClassTarget>();
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target target = (Target)it.next();
            if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isUnitTest()) continue;
            l.add(ct);
        }
        return l;
    }

    public void compile() {
        boolean success;
        if (!this.checkCompile()) {
            return;
        }
        ArrayList<ClassTarget> toCompile = new ArrayList<ClassTarget>();
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target target = (Target)it.next();
            if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isInvalidState()) continue;
            toCompile.add(ct);
        }
        if (!toCompile.isEmpty()) {
            this.project.removeClassLoader();
            this.project.newRemoteClassLoader();
            CompilerWarningDialog.getDialog().reset();
        }
        for (int i = toCompile.size() - 1; i >= 0 && (success = this.searchCompile((ClassTarget)toCompile.get(i), 1, new Stack(), new PackageCompileObserver())); --i) {
        }
    }

    public void compile(ClassTarget ct) {
        if (!this.checkCompile()) {
            return;
        }
        if (ct.hasSourceCode()) {
            ct.setInvalidState();
        }
        this.project.removeClassLoader();
        this.project.newRemoteClassLoader();
        CompilerWarningDialog.getDialog().reset();
        this.searchCompile(ct, 1, new Stack(), new PackageCompileObserver());
        if (ct.getAssociation() != null) {
            ClassTarget assocTarget = (ClassTarget)ct.getAssociation();
            assocTarget.setInvalidState();
            this.searchCompile(assocTarget, 1, new Stack(), new QuietPackageCompileObserver());
        }
    }

    public void compileQuiet(ClassTarget ct) {
        if (!this.checkCompile()) {
            return;
        }
        ct.setInvalidState();
        this.searchCompile(ct, 1, new Stack(), new QuietPackageCompileObserver());
    }

    public void rebuild() {
        if (!this.checkCompile()) {
            return;
        }
        ArrayList<ClassTarget> compileTargets = new ArrayList<ClassTarget>();
        try {
            Iterator it = this.targets.iterator();
            while (it.hasNext()) {
                ClassTarget ct;
                Target target = (Target)it.next();
                if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).hasSourceCode()) continue;
                ct.ensureSaved();
                ct.setState(1);
                ct.setQueued(true);
                compileTargets.add(ct);
            }
            this.project.removeClassLoader();
            this.project.newRemoteClassLoader();
            CompilerWarningDialog.getDialog().reset();
            this.doCompile(compileTargets, new PackageCompileObserver());
        }
        catch (IOException ioe) {
            this.showMessageWithText("file-save-error-before-compile", ioe.getLocalizedMessage());
        }
    }

    public void saveFilesInEditors() throws IOException {
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Editor ed;
            Target target = (Target)it.next();
            if (!(target instanceof ClassTarget) || (ed = (ct = (ClassTarget)target).getEditor()) == null) continue;
            ed.save();
        }
    }

    private boolean searchCompile(ClassTarget t, int dfcount, Stack stack, CompileObserver observer) {
        if (!t.isInvalidState() || t.isQueued()) {
            return true;
        }
        try {
            t.ensureSaved();
            if (t.getPackage() != this) {
                return true;
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("file-save-error-before-compile", ioe.getLocalizedMessage());
            return false;
        }
        t.setQueued(true);
        t.dfn = dfcount;
        t.link = dfcount;
        stack.push(t);
        Iterator dependencies = t.dependencies();
        while (dependencies.hasNext()) {
            Dependency d = (Dependency)dependencies.next();
            if (!(d.getTo() instanceof ClassTarget)) continue;
            ClassTarget to = (ClassTarget)d.getTo();
            if (to.isQueued()) {
                if (to.dfn >= t.dfn || stack.search(to) == -1) continue;
                t.link = Math.min(t.link, to.dfn);
                continue;
            }
            if (!to.isInvalidState()) continue;
            boolean success = this.searchCompile(to, dfcount + 1, stack, observer);
            if (!success) {
                t.setQueued(false);
                return false;
            }
            t.link = Math.min(t.link, to.link);
        }
        if (t.link == t.dfn) {
            ClassTarget x;
            ArrayList<ClassTarget> compileTargets = new ArrayList<ClassTarget>();
            do {
                x = (ClassTarget)stack.pop();
                compileTargets.add(x);
            } while (x != t);
            this.doCompile(compileTargets, observer);
        }
        return true;
    }

    private void doCompile(List targetList, CompileObserver observer) {
        observer = new EventqueueCompileObserver(observer);
        if (targetList.size() == 0) {
            return;
        }
        File[] srcFiles = new File[targetList.size()];
        for (int i = 0; i < targetList.size(); ++i) {
            ClassTarget ct = (ClassTarget)targetList.get(i);
            srcFiles[i] = ct.getSourceFile();
        }
        this.removeBreakpoints();
        JobQueue.getJobQueue().addJob(srcFiles, observer, this.getProject().getClassLoader(), this.getProject().getProjectDir(), !PrefMgr.getFlag("bluej.compiler.showunchecked"));
    }

    public boolean isDebuggerIdle() {
        int status = this.getDebugger().getStatus();
        return status == 2 || status == 1;
    }

    private boolean checkCompile() {
        if (this.isDebuggerIdle()) {
            return true;
        }
        this.showMessage("compile-while-executing");
        return false;
    }

    public String generateDocumentation() {
        return this.project.generateDocumentation();
    }

    public void generateDocumentation(ClassTarget ct) {
        String filename = ct.getSourceFile().getPath();
        this.project.generateDocumentation(filename);
    }

    public void removeBreakpoints() {
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = (Target)it.next();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).removeBreakpoints();
        }
    }

    public void removeStepMarks() {
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = (Target)it.next();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).removeStepMark();
        }
    }

    public void addTarget(Target t) {
        if (t.getPackage() != this) {
            throw new IllegalArgumentException();
        }
        this.targets.add(t.getIdentifierName(), t);
        this.graphChanged();
    }

    public void removeTarget(Target t) {
        this.targets.remove(t.getIdentifierName());
        this.removedSelectableElement(t);
        t.setRemoved();
        this.graphChanged();
    }

    public void updateTargetIdentifier(Target t, String oldIdentifier, String newIdentifier) {
        if (t == null || newIdentifier == null) {
            Debug.reportError("cannot properly update target name...");
            return;
        }
        this.targets.remove(oldIdentifier);
        this.targets.add(newIdentifier, t);
    }

    public void removeClass(ClassTarget removableTarget) {
        this.removeTarget(removableTarget);
        this.graphChanged();
    }

    public void removePackage(PackageTarget removableTarget) {
        this.removeTarget(removableTarget);
        this.graphChanged();
    }

    public void removeArrow(Dependency d) {
        if (!(d instanceof UsesDependency)) {
            this.userRemoveDependency(d);
        }
        this.removeDependency(d, true);
        this.graphChanged();
    }

    public void addDependency(Dependency d, boolean recalc) {
        DependentTarget from = d.getFrom();
        DependentTarget to = d.getTo();
        if (from == null || to == null) {
            return;
        }
        if (d instanceof UsesDependency) {
            int index = this.usesArrows.indexOf(d);
            if (index != -1) {
                ((UsesDependency)this.usesArrows.get(index)).setFlag(true);
                return;
            }
            this.usesArrows.add(d);
        } else {
            if (this.extendsArrows.contains(d)) {
                return;
            }
            this.extendsArrows.add(d);
        }
        from.addDependencyOut(d, recalc);
        to.addDependencyIn(d, recalc);
    }

    public void userAddImplementsClassDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = info.getImplementsInsertSelection();
                ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List exists = this.getInterfaceTexts(ed, info.getInterfaceSelections());
                    if (!exists.contains(to.getBaseName())) {
                        ed.insertText(", " + to.getBaseName(), false);
                    }
                } else {
                    ed.insertText(" implements " + to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userAddImplementsInterfaceDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = info.getExtendsInsertSelection();
                ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List exists = this.getInterfaceTexts(ed, info.getInterfaceSelections());
                    if (!exists.contains(to.getBaseName())) {
                        ed.insertText(", " + to.getBaseName(), false);
                    }
                } else {
                    ed.insertText(" extends " + to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userAddExtendsClassDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                if (info.getSuperclass() == null) {
                    Selection s1 = info.getExtendsInsertSelection();
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText(" extends " + to.getBaseName(), false);
                } else {
                    Selection s1 = info.getSuperReplaceSelection();
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText(to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userRemoveDependency(Dependency d) {
        if (!(d.getFrom() instanceof ClassTarget) || !(d.getTo() instanceof ClassTarget)) {
            return;
        }
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = null;
                if (d instanceof ImplementsDependency) {
                    List vsels = info.getInterfaceSelections();
                    List vtexts = this.getInterfaceTexts(ed, vsels);
                    int where = vtexts.indexOf(to.getBaseName());
                    if (where == 1 && vsels.size() > 2) {
                        where = 2;
                    }
                    if (where > 0) {
                        s1 = (Selection)vsels.get(where - 1);
                        s1.combineWith((Selection)vsels.get(where));
                    }
                } else if (d instanceof ExtendsDependency) {
                    s1 = info.getExtendsReplaceSelection();
                    s1.combineWith(info.getSuperReplaceSelection());
                }
                if (s1 != null) {
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText("", false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    private List getInterfaceTexts(Editor ed, List selections) {
        ArrayList<String> r = new ArrayList<String>(selections.size());
        Iterator i = selections.iterator();
        while (i.hasNext()) {
            Selection sel = (Selection)i.next();
            String text = ed.getText(new LineColumn(sel.getLine() - 1, sel.getColumn() - 1), new LineColumn(sel.getEndLine() - 1, sel.getEndColumn() - 1));
            int taIndex = text.indexOf(60);
            if (taIndex != -1) {
                text = text.substring(0, taIndex);
            }
            text = text.trim();
            r.add(text);
        }
        return r;
    }

    public void removeDependency(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.usesArrows.remove(d);
        } else {
            this.extendsArrows.remove(d);
        }
        DependentTarget from = d.getFrom();
        from.removeDependencyOut(d, recalc);
        DependentTarget to = d.getTo();
        to.removeDependencyIn(d, recalc);
        this.removedSelectableElement(d);
    }

    public void recalcArrows() {
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            if (!(t instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t;
            dt.recalcInUses();
            dt.recalcOutUses();
        }
    }

    public Target getTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        return t;
    }

    public DependentTarget getDependentTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        if (t instanceof DependentTarget) {
            return (DependentTarget)t;
        }
        return null;
    }

    public final ArrayList getClassTargets() {
        ArrayList<Target> risul = new ArrayList<Target>();
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = (Target)it.next();
            if (!(target instanceof ClassTarget)) continue;
            risul.add(target);
        }
        return risul;
    }

    public List getAllClassnames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = (Target)it.next();
            if (!(t instanceof ClassTarget)) continue;
            ClassTarget ct = (ClassTarget)t;
            names.add(ct.getBaseName());
        }
        return names;
    }

    public List getAllClassnamesWithSource() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target t = (Target)it.next();
            if (!(t instanceof ClassTarget) || !(ct = (ClassTarget)t).hasSourceCode()) continue;
            names.add(ct.getBaseName());
        }
        return names;
    }

    public ClassTarget getTargetFromFilename(String filename) {
        this.getProject().convertPathToPackageName(filename);
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target t = (Target)it.next();
            if (!(t instanceof ClassTarget) || !filename.equals((ct = (ClassTarget)t).getSourceFile().getPath())) continue;
            return ct;
        }
        return null;
    }

    public void setShowUses(boolean state) {
        this.showUses = state;
    }

    public void setShowExtends(boolean state) {
        this.showExtends = state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public static boolean isBlueJPackage(File f) {
        if (f == null) {
            return false;
        }
        if (f.getPath().endsWith(":\\")) {
            return false;
        }
        if (!f.isDirectory()) {
            return false;
        }
        File packageFile = new File(f, pkgfileName);
        return packageFile.exists();
    }

    public void targetSelected(Target t) {
        if (t == null) {
            if (this.getState() != 0) {
                this.setState(0);
                this.setStatus(" ");
            }
            return;
        }
        switch (this.getState()) {
            case 1: {
                if (t instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)t;
                    this.setState(2);
                    this.setStatus(chooseUsesTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 2: {
                if (t == this.fromChoice || !(t instanceof DependentTarget)) break;
                this.setState(0);
                this.addDependency(new UsesDependency(this, this.fromChoice, (DependentTarget)t), true);
                this.setStatus(" ");
                break;
            }
            case 3: {
                if (t instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)t;
                    this.setState(4);
                    this.setStatus(chooseInhTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 4: {
                if (t == this.fromChoice) break;
                this.setState(0);
                if (t instanceof ClassTarget && this.fromChoice instanceof ClassTarget) {
                    ClassTarget from = (ClassTarget)this.fromChoice;
                    ClassTarget to = (ClassTarget)t;
                    if (to.isInterface()) {
                        ImplementsDependency d = new ImplementsDependency(this, from, to);
                        if (from.isInterface()) {
                            this.userAddImplementsInterfaceDependency(d);
                        } else {
                            this.userAddImplementsClassDependency(d);
                        }
                        this.addDependency(d, true);
                    } else if (!from.isInterface()) {
                        ExtendsDependency d = new ExtendsDependency(this, from, to);
                        this.userAddExtendsClassDependency(d);
                        this.addDependency(d, true);
                    }
                }
                this.setStatus(" ");
                break;
            }
        }
    }

    public void showError(String msgId) {
        PkgMgrFrame.showError(this, msgId);
    }

    public void showMessage(String msgId) {
        PkgMgrFrame.showMessage(this, msgId);
    }

    public void showMessageWithText(String msgId, String text) {
        PkgMgrFrame.showMessageWithText(this, msgId, text);
    }

    public void reportException(String text) {
        this.showMessageWithText("exception-thrown", text);
    }

    public void forgetLastSource() {
        this.lastSourceName = "";
    }

    public boolean showSource(String sourcename, int lineNo, String threadName, boolean breakpoint) {
        String msg = " ";
        if (breakpoint) {
            msg = "Thread \"" + threadName + "\" stopped at breakpoint.";
        }
        boolean bringToFront = !sourcename.equals(this.lastSourceName);
        this.lastSourceName = sourcename;
        if (!this.showEditorMessage(new File(this.getPath(), sourcename).getPath(), lineNo, msg, false, bringToFront, true, null)) {
            this.showMessageWithText("break-no-source", sourcename);
        }
        return bringToFront;
    }

    private boolean showEditorMessage(String filename, int lineNo, String message, boolean beep, boolean bringToFront, boolean setStepMark, String help) {
        Editor editor;
        ClassTarget t;
        String fullName = this.getProject().convertPathToPackageName(filename);
        String packageName = JavaNames.getPrefix(fullName);
        String className = JavaNames.getBase(fullName);
        if (packageName != this.getQualifiedName()) {
            Package pkg = this.getProject().getPackage(packageName);
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
            if (pmf == null) {
                pmf = PkgMgrFrame.createFrame(pkg);
            }
            pmf.setVisible(true);
            t = (ClassTarget)pkg.getTarget(className);
        } else {
            t = (ClassTarget)this.getTarget(className);
        }
        if (t == null) {
            return false;
        }
        if (bringToFront || !t.getEditor().isShowing()) {
            t.open();
        }
        if ((editor = t.getEditor()) != null) {
            editor.displayMessage(message, lineNo, 0, beep, setStepMark, help);
        } else {
            Debug.message(t.getDisplayName() + ", line" + lineNo + ": " + message);
        }
        return true;
    }

    public void hitBreakpoint(DebuggerThread thread) {
        this.showSource(thread.getClassSourceName(0), thread.getLineNumber(0), thread.getName(), true);
        this.getProject().getExecControls().showHide(true);
        this.getProject().getExecControls().makeSureThreadIsSelected(thread);
    }

    public void hitHalt(DebuggerThread thread) {
        this.showSourcePosition(thread);
        this.getProject().getExecControls().showHide(true);
        this.getProject().getExecControls().makeSureThreadIsSelected(thread);
    }

    public void showSourcePosition(DebuggerThread thread) {
        int frame = thread.getSelectedFrame();
        if (this.showSource(thread.getClassSourceName(frame), thread.getLineNumber(frame), thread.getName(), false)) {
            this.getProject().getExecControls().setVisible(true);
        }
    }

    public void exceptionMessage(List stack, String message) {
        SourceLocation loc;
        if (stack == null || stack.size() == 0) {
            return;
        }
        boolean done = false;
        Iterator iter = stack.iterator();
        boolean firstTime = true;
        while (!done && iter.hasNext()) {
            loc = (SourceLocation)iter.next();
            String filename = new File(this.getPath(), loc.getFileName()).getPath();
            int lineNo = loc.getLineNumber();
            done = this.showEditorMessage(filename, lineNo, message, true, true, false, "exception");
            if (!firstTime || done) continue;
            message = message + " (in " + loc.getClassName() + ")";
            firstTime = false;
        }
        if (!done) {
            loc = (SourceLocation)stack.get(0);
            this.showMessageWithText("error-in-file", loc.getClassName() + ":" + loc.getLineNumber() + "\n" + message);
        }
    }

    public void reportExit(String exitCode) {
        this.showMessageWithText("system-exit", exitCode);
    }

    public void closeAllEditors() {
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            EditableTarget et;
            Target t = (Target)it.next();
            if (!(t instanceof EditableTarget) || !(et = (EditableTarget)t).editorOpen()) continue;
            et.getEditor().close();
        }
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public String toString() {
        return "Package:" + this.getQualifiedName();
    }

    private class PackageCompileObserver
    extends QuietPackageCompileObserver {
        private PackageCompileObserver() {
        }

        public void errorMessage(String filename, int lineNo, String message) {
            super.errorMessage(filename, lineNo, message);
            if (!Package.this.showEditorMessage(filename, lineNo, message, true, true, false, Config.compilertype)) {
                Package.this.showMessageWithText("error-in-file", filename + ":" + lineNo + "\n" + message);
            }
        }

        public void warningMessage(String filename, int lineNo, String message) {
            super.warningMessage(filename, lineNo, message);
            CompilerWarningDialog.getDialog().addWarningMessage(message);
        }
    }

    private class QuietPackageCompileObserver
    implements CompileObserver {
        private QuietPackageCompileObserver() {
        }

        private void markAsCompiling(File[] sources) {
            for (int i = 0; i < sources.length; ++i) {
                String fileName = sources[i].getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(fileName);
                Target t = Package.this.getTarget(JavaNames.getBase(fullName));
                if (!(t instanceof ClassTarget)) continue;
                ClassTarget ct = (ClassTarget)t;
                ct.setState(2);
            }
        }

        private void sendEventToExtensions(String filename, int lineNo, String message, int eventType) {
            File[] sources = filename != null ? new File[]{new File(filename)} : new File[]{};
            CompileEvent aCompileEvent = new CompileEvent(eventType, sources);
            aCompileEvent.setErrorLineNumber(lineNo);
            aCompileEvent.setErrorMessage(message);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
        }

        public void startCompile(File[] sources) {
            CompileEvent aCompileEvent = new CompileEvent(1, sources);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
            Package.this.setStatus(compiling);
            this.markAsCompiling(sources);
        }

        public void errorMessage(String filename, int lineNo, String message) {
            this.sendEventToExtensions(filename, lineNo, message, 3);
        }

        public void warningMessage(String filename, int lineNo, String message) {
            this.sendEventToExtensions(filename, lineNo, message, 2);
        }

        public void endCompile(File[] sources, boolean successful) {
            for (int i = 0; i < sources.length; ++i) {
                String filename = sources[i].getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(filename);
                ClassTarget t = (ClassTarget)Package.this.targets.get(JavaNames.getBase(fullName));
                if (t == null) continue;
                boolean newCompiledState = successful;
                if (successful) {
                    t.endCompile();
                    try {
                        ClassInfo info = t.getSourceInfo().getInfo(t.getSourceFile(), t.getPackage());
                        if (info != null) {
                            FileOutputStream out = new FileOutputStream(t.getContextFile());
                            info.getComments().store(out, "BlueJ class context");
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    newCompiledState &= t.upToDate();
                }
                t.setState(newCompiledState ? 0 : 1);
                t.setQueued(false);
                if (!successful || !t.editorOpen()) continue;
                t.getEditor().setCompiled(true);
            }
            Package.this.setStatus(compileDone);
            Package.this.graphChanged();
            int eventId = successful ? 4 : 5;
            CompileEvent aCompileEvent = new CompileEvent(eventId, sources);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
        }
    }
}

