/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.JavaNames;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

class NewClassDialog
extends EscapeDialog {
    private JTextField textFld;
    ButtonGroup templateButtons;
    private String newClassName = "";
    private boolean ok;

    public NewClassDialog(JFrame parent) {
        super(parent, Config.getString("pkgmgr.newClass.title"), true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                NewClassDialog.this.ok = false;
                NewClassDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel newclassTag = new JLabel(Config.getString("pkgmgr.newClass.label"));
        newclassTag.setAlignmentX(0.0f);
        this.textFld = new JTextField(24);
        this.textFld.setAlignmentX(0.0f);
        mainPanel.add(newclassTag);
        mainPanel.add(this.textFld);
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new BoxLayout(choicePanel, 1));
        choicePanel.setAlignmentX(0.0f);
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("pkgmgr.newClass.classType")), BorderFactory.createEmptyBorder(0, 10, 0, 10));
        choicePanel.setBorder(b);
        this.addClassTypeButtons(choicePanel);
        choicePanel.setMaximumSize(new Dimension(this.textFld.getMaximumSize().width, choicePanel.getMaximumSize().height));
        choicePanel.setPreferredSize(new Dimension(this.textFld.getPreferredSize().width, choicePanel.getPreferredSize().height));
        mainPanel.add(choicePanel);
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewClassDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewClassDialog.this.doCancel();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private void addClassTypeButtons(JPanel panel) {
        String templateSuffix = ".tmpl";
        int suffixLength = templateSuffix.length();
        String templateString = Config.getPropString("bluej.classTemplates");
        StringTokenizer t = new StringTokenizer(templateString);
        ArrayList<String> templates = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            templates.add(t.nextToken());
        }
        File templateDir = Config.getClassTemplateDir();
        if (!templateDir.exists()) {
            DialogManager.showError(this, "error-no-templates");
        } else {
            String[] files = templateDir.list();
            for (int i = 0; i < files.length; ++i) {
                String template;
                if (!files[i].endsWith(templateSuffix) || templates.contains(template = files[i].substring(0, files[i].length() - suffixLength))) continue;
                templates.add(template);
            }
        }
        JRadioButton previousButton = null;
        this.templateButtons = new ButtonGroup();
        Iterator i = templates.iterator();
        while (i.hasNext()) {
            String template = (String)i.next();
            if (template.equals("enum") && !Config.isJava15()) continue;
            String label = Config.getString("pkgmgr.newClass." + template, template);
            JRadioButton button = new JRadioButton(label, previousButton == null);
            button.setActionCommand(template);
            this.templateButtons.add(button);
            panel.add(button);
            previousButton = button;
        }
    }

    public boolean display() {
        this.ok = false;
        this.textFld.requestFocus();
        this.setVisible(true);
        return this.ok;
    }

    public String getClassName() {
        return this.newClassName;
    }

    public String getTemplateName() {
        return this.templateButtons.getSelection().getActionCommand();
    }

    public void doOK() {
        this.newClassName = this.textFld.getText().trim();
        if (JavaNames.isIdentifier(this.newClassName)) {
            this.ok = true;
            this.setVisible(false);
        } else {
            DialogManager.showError((JFrame)this.getParent(), "invalid-class-name");
            this.textFld.selectAll();
            this.textFld.requestFocus();
        }
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }
}

