/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

class ExportDialog
extends EscapeDialog {
    private static final String dialogTitle = Config.getString("pkgmgr.export.title");
    private static final String helpLine1 = Config.getString("pkgmgr.export.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.export.helpLine2");
    private static final String classLabelText = Config.getString("pkgmgr.export.classLabel");
    private static final String libsLabel = Config.getString("pkgmgr.export.includeLibs");
    private static final String sourceLabel = Config.getString("pkgmgr.export.sourceLabel");
    private static final String pkgFilesLabel = Config.getString("pkgmgr.export.pkgFilesLabel");
    private static final String noClassText = Config.getString("pkgmgr.export.noClassText");
    private String mainClassName = "";
    private JComboBox classSelect;
    private JCheckBox sourceBox;
    private JCheckBox pkgFilesBox;
    private JCheckBox otherFilesBox;
    private UserLibInfo[] userLibs;
    private boolean ok;

    public ExportDialog(PkgMgrFrame parent) {
        super(parent, dialogTitle, true);
        this.makeDialog(parent.getProject());
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    public String getMainClass() {
        return this.mainClassName;
    }

    public List getSelectedLibs() {
        ArrayList<File> selected = new ArrayList<File>();
        if (this.userLibs != null) {
            for (int i = 0; i < this.userLibs.length; ++i) {
                if (!this.userLibs[i].isSelected()) continue;
                selected.add(this.userLibs[i].getFile());
            }
        }
        return selected;
    }

    public boolean includeSource() {
        return this.sourceBox.isSelected();
    }

    public boolean includePkgFiles() {
        return this.pkgFilesBox.isSelected();
    }

    private void doOK() {
        this.mainClassName = (String)this.classSelect.getSelectedItem();
        if (this.mainClassName.equals(noClassText)) {
            this.mainClassName = "";
        }
        this.ok = true;
        this.setVisible(false);
    }

    private void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    private void makeDialog(Project project) {
        this.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel helpText1 = new JLabel(helpLine1);
        mainPanel.add(helpText1);
        JLabel helpText2 = new JLabel(helpLine2);
        mainPanel.add(helpText2);
        Font smallFont = helpText1.getFont().deriveFont(2, 11.0f);
        helpText1.setFont(smallFont);
        helpText2.setFont(smallFont);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(new JSeparator());
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        inputPanel.setAlignmentX(0.0f);
        JPanel mainClassPanel = new JPanel();
        JLabel classLabel = new JLabel(classLabelText);
        mainClassPanel.add(classLabel);
        this.classSelect = this.makeClassPopup(project);
        mainClassPanel.add(this.classSelect);
        mainClassPanel.setAlignmentX(0.0f);
        inputPanel.add(mainClassPanel);
        inputPanel.add(Box.createVerticalStrut(5));
        JPanel userLibPanel = this.createUserLibPanel(project);
        if (userLibPanel != null) {
            userLibPanel.setAlignmentX(0.0f);
            inputPanel.add(userLibPanel);
            inputPanel.add(Box.createVerticalStrut(5));
        }
        this.sourceBox = new JCheckBox(sourceLabel, false);
        this.sourceBox.setAlignmentX(0.0f);
        inputPanel.add(this.sourceBox);
        inputPanel.add(Box.createVerticalStrut(5));
        this.pkgFilesBox = new JCheckBox(pkgFilesLabel);
        inputPanel.add(this.pkgFilesBox);
        mainPanel.add(inputPanel);
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton continueButton = BlueJTheme.getContinueButton();
        continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.doCancel();
            }
        });
        buttonPanel.add(continueButton);
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(continueButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private JComboBox makeClassPopup(Project project) {
        JComboBox<String> popup = new JComboBox<String>();
        popup.setFont(PrefMgr.getPopupMenuFont());
        popup.addItem(noClassText);
        List packageNames = project.getPackageNames();
        Collections.sort(packageNames);
        Iterator packages = packageNames.iterator();
        while (packages.hasNext()) {
            Iterator classes;
            String pkgName = (String)packages.next();
            List classNames = project.getPackage(pkgName).getAllClassnames();
            Collections.sort(classNames);
            if (pkgName.length() > 0) {
                classes = classNames.iterator();
                while (classes.hasNext()) {
                    popup.addItem(pkgName + "." + classes.next());
                }
                continue;
            }
            classes = classNames.iterator();
            while (classes.hasNext()) {
                popup.addItem((String)classes.next());
            }
        }
        return popup;
    }

    private JPanel createUserLibPanel(Project project) {
        ArrayList<UserLibInfo> userlibList = new ArrayList<UserLibInfo>();
        ArrayList libList = PrefMgrDialog.getInstance().getUserConfigLibPanel().getUserConfigContent();
        libList.addAll(Project.getUserlibContent());
        Iterator it = libList.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            try {
                File file = new File(new URI(url.toString()));
                if (file == null || file.isDirectory()) continue;
                userlibList.add(new UserLibInfo(file));
            }
            catch (URISyntaxException use) {
                Debug.reportError("ExportDialog.createUserLibPanel(Project) invalid url=" + url.getPath());
            }
        }
        if (userlibList.size() < 1) {
            return null;
        }
        this.userLibs = userlibList.toArray(new UserLibInfo[userlibList.size()]);
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(libsLabel), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        for (int i = 0; i < this.userLibs.length; ++i) {
            panel.add(this.userLibs[i].getCheckBox());
        }
        return panel;
    }

    class UserLibInfo {
        private File sourceFile;
        private JCheckBox checkBox;

        public UserLibInfo(File source) {
            this.sourceFile = source;
            this.checkBox = new JCheckBox(this.sourceFile.getName(), false);
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public File getFile() {
            return this.sourceFile;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }
    }
}

