/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import antlr.collections.AST;
import bluej.parser.EscapedUnicodeReader;
import bluej.parser.JavaTokenFilter;
import bluej.parser.SourceSpan;
import bluej.parser.TextParser;
import bluej.parser.ast.LocatableAST;
import bluej.parser.ast.LocatableToken;
import bluej.parser.ast.gen.JavaLexer;
import bluej.parser.ast.gen.JavaRecognizer;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.ClassScope;
import bluej.parser.symtab.PackageScope;
import bluej.parser.symtab.Scope;
import bluej.parser.symtab.Selection;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ClassParser {
    private ClassInfo classInfo;
    private List classInfoList = new ArrayList();

    public static ClassInfo parse(File file) throws RecognitionException {
        return ClassParser.parse(file, null);
    }

    public static ClassInfo parse(File file, List packageClasses) throws RecognitionException {
        FileInputStream fr = null;
        try {
            fr = new FileInputStream(file);
            ClassInfo classInfo = ClassParser.parse(new InputStreamReader(fr), packageClasses);
            return classInfo;
        }
        catch (FileNotFoundException fnfe) {
            throw new RecognitionException();
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static ClassInfo parse(InputStreamReader ir, List packageClasses) throws RecognitionException {
        return ClassParser.getClassParser(ir, packageClasses).getInfo();
    }

    public static List parseList(InputStreamReader ir, List packageClasses) throws RecognitionException {
        return ClassParser.getClassParser(ir, packageClasses).getInfoList();
    }

    public static ClassParser getClassParser(InputStreamReader ir, List packageClasses) throws RecognitionException {
        try {
            EscapedUnicodeReader eur = new EscapedUnicodeReader(ir);
            JavaLexer lexer = new JavaLexer(eur);
            lexer.setTokenObjectClass("bluej.parser.ast.LocatableToken");
            lexer.setTabSize(1);
            eur.setAttachedScanner(lexer);
            JavaTokenFilter filter = new JavaTokenFilter(lexer);
            JavaRecognizer parser = new JavaRecognizer(filter);
            parser.setASTNodeClass("bluej.parser.ast.LocatableAST");
            parser.compilationUnit();
            AST node = parser.getAST();
            ClassParser cp = new ClassParser();
            try {
                cp.getClassInfo(node, packageClasses);
                return cp;
            }
            catch (RecognitionException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RecognitionException();
            }
        }
        catch (TokenStreamException tse) {
            throw new RecognitionException();
        }
    }

    static Selection tokenBeginSelection(Token t) {
        int line = t.getLine();
        int col = t.getColumn();
        return new Selection(line, col);
    }

    static Selection tokenEndSelection(Token t) {
        int line = t.getLine();
        int col = t.getColumn() + t.getText().length();
        return new Selection(line, col);
    }

    private ClassParser() {
    }

    public ClassInfo getInfo() {
        return this.classInfo;
    }

    public List getInfoList() {
        return this.classInfoList;
    }

    public void getClassInfo(AST node, List packageClasses) throws RecognitionException {
        int nodeType;
        if (node == null) {
            return;
        }
        LocatableAST packageDefNode = null;
        if (node.getType() == 16) {
            packageDefNode = (LocatableAST)node;
            node = node.getNextSibling();
        }
        PackageScope packageScope = new PackageScope();
        if (packageClasses != null) {
            Iterator i = packageClasses.iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                packageScope.addType(className);
            }
        }
        Scope compUnitScope = new Scope(packageScope);
        while (node != null && ((nodeType = node.getType()) == 30 || nodeType == 45)) {
            AST impFirst;
            AST impSecond;
            AST importNode;
            if (nodeType == 30 && (importNode = node.getFirstChild()).getType() == 68 && (impSecond = (impFirst = importNode.getFirstChild()).getNextSibling()).getType() == 69) {
                String importName = TextParser.combineDotNames(importNode, '.');
                compUnitScope.addType(importName);
            }
            node = node.getNextSibling();
        }
        while (node != null) {
            int ntype = node.getType();
            if (ntype != 14 && ntype != 15 && ntype != 46) {
                node = node.getNextSibling();
                continue;
            }
            AST cnode = node.getFirstChild();
            boolean isPublic = false;
            boolean isAbstract = false;
            if (cnode != null && cnode.getType() == 5) {
                for (AST ccnode = cnode.getFirstChild(); ccnode != null; ccnode = ccnode.getNextSibling()) {
                    if (ccnode.getType() == 89) {
                        isPublic = true;
                        continue;
                    }
                    if (ccnode.getType() != 40) continue;
                    isAbstract = true;
                }
                cnode = cnode.getNextSibling();
            }
            if (cnode != null && cnode.getType() == 69) {
                LocatableAST nameNode = (LocatableAST)cnode;
                String name = nameNode.getText();
                compUnitScope.addType(name);
                ClassInfo info = new ClassInfo();
                info.setName(name, isPublic);
                info.setAbstract(isAbstract);
                info.setInterface(ntype == 15);
                info.setEnum(ntype == 46);
                cnode = cnode.getNextSibling();
                if (cnode != null && cnode.getType() == 56) {
                    LocatableAST tparsNode = (LocatableAST)cnode;
                    LocatableToken langle = tparsNode.getImportantToken(0);
                    Selection tparsSelection = ClassParser.tokenBeginSelection((Token)langle);
                    Selection endSel = new Selection(tparsNode.getEndLine(), tparsNode.getEndColumn());
                    tparsSelection.combineWith(endSel);
                    info.setTypeParametersSelection(tparsSelection);
                    ArrayList<String> tpNames = new ArrayList<String>();
                    for (AST tpAst = tparsNode.getFirstChild(); tpAst != null; tpAst = tpAst.getNextSibling()) {
                        if (tpAst.getType() != 69) continue;
                        tpNames.add(this.getTypeParamString(tpAst));
                    }
                    info.setTypeParameterTexts(tpNames);
                    cnode = cnode.getNextSibling();
                }
                if (cnode != null && cnode.getType() == 18) {
                    switch (ntype) {
                        case 15: {
                            this.processIfaceExtendsClause(cnode, nameNode, info);
                            break;
                        }
                        default: {
                            this.processClassExtendsClause(cnode, nameNode, info);
                        }
                    }
                    cnode = cnode.getNextSibling();
                }
                if (cnode != null && cnode.getType() == 19) {
                    this.processClassImplementsClause(cnode, nameNode, info);
                    cnode = cnode.getNextSibling();
                }
                if (cnode != null && cnode.getType() == 6) {
                    this.processObjBlock(cnode, new ClassScope(info, compUnitScope));
                }
                this.classInfoList.add(info);
                if (this.classInfo == null || isPublic) {
                    this.classInfo = info;
                }
            }
            node = node.getNextSibling();
        }
        Iterator ci = this.classInfoList.iterator();
        while (ci.hasNext()) {
            ClassInfo cinfo = (ClassInfo)ci.next();
            Iterator i = packageScope.getReferences().iterator();
            while (i.hasNext()) {
                cinfo.addUsed(i.next().toString());
            }
            if (packageDefNode == null) continue;
            this.storePackageInfo(packageDefNode, cinfo);
        }
    }

    private void storePackageInfo(LocatableAST packageNode, ClassInfo info) throws RecognitionException {
        if (packageNode != null) {
            LocatableAST packageNameNode = (LocatableAST)packageNode.getFirstChild();
            String pkgName = this.getQualifiedName((AST)packageNameNode);
            LocatableToken semi = packageNode.getImportantToken(0);
            Selection pkgSel = new Selection(packageNode.getLine(), packageNode.getColumn(), packageNode.getLength());
            Selection pkgNameSel = this.getTypeSel(packageNameNode);
            Selection semiSel = new Selection(semi.getLine(), semi.getColumn(), semi.getLength());
            info.setPackageSelections(pkgSel, pkgNameSel, pkgName, semiSel);
        }
    }

    private void processIfaceExtendsClause(AST cnode, LocatableAST nameNode, ClassInfo info) throws RecognitionException {
        LocatableAST superNode = (LocatableAST)cnode.getFirstChild();
        if (superNode != null) {
            LocatableAST extendsN = (LocatableAST)cnode;
            LocatableToken extendsTok = extendsN.getImportantToken(0);
            Selection sel = new Selection(extendsTok.getLine(), extendsTok.getColumn(), extendsTok.getLength());
            ArrayList<Selection> superInterfaces = new ArrayList<Selection>();
            superInterfaces.add(sel);
            Selection lastSel = null;
            while (superNode != null) {
                String superName = this.getQualifiedName((AST)superNode);
                info.addImplements(superName);
                sel = this.getTypeSel(superNode);
                if (lastSel != null) {
                    SourceSpan commaSpan = new SourceSpan(lastSel.getEndLocation(), sel.getStartLocation());
                    Selection commaSel = new Selection(commaSpan);
                    superInterfaces.add(commaSel);
                }
                superInterfaces.add(sel);
                lastSel = sel;
                superNode = (LocatableAST)superNode.getNextSibling();
            }
            info.setExtendsInsertSelection(new Selection(lastSel.getEndLine(), lastSel.getEndColumn()));
            info.setInterfaceSelections(superInterfaces);
        } else {
            Selection tparSel = info.getTypeParametersSelection();
            Selection s = tparSel == null ? new Selection(nameNode.getLine(), nameNode.getEndColumn()) : new Selection(tparSel.getEndLine(), tparSel.getEndColumn());
            info.setExtendsInsertSelection(s);
            info.setInterfaceSelections(Collections.EMPTY_LIST);
        }
    }

    private void processClassImplementsClause(AST cnode, LocatableAST nameNode, ClassInfo info) throws RecognitionException {
        LocatableAST superNode = (LocatableAST)cnode.getFirstChild();
        if (superNode != null) {
            ArrayList<Selection> superInterfaces = new ArrayList<Selection>();
            LocatableAST implementsN = (LocatableAST)cnode;
            LocatableToken implementsTok = implementsN.getImportantToken(0);
            Selection sel = new Selection(implementsTok.getLine(), implementsTok.getColumn(), implementsTok.getText().length());
            superInterfaces.add(sel);
            Selection lastSel = null;
            while (superNode != null) {
                String superName = this.getQualifiedName((AST)superNode);
                info.addImplements(superName);
                sel = this.getTypeSel(superNode);
                if (lastSel != null) {
                    SourceSpan commaSpan = new SourceSpan(lastSel.getEndLocation(), sel.getStartLocation());
                    Selection commaSel = new Selection(commaSpan);
                    superInterfaces.add(commaSel);
                }
                superInterfaces.add(sel);
                lastSel = sel;
                superNode = (LocatableAST)superNode.getNextSibling();
            }
            info.setImplementsInsertSelection(new Selection(lastSel.getEndLine(), lastSel.getEndColumn()));
            info.setInterfaceSelections(superInterfaces);
        } else {
            Selection tparsSel;
            Selection superSel = info.getSuperReplaceSelection();
            Selection s = superSel == null ? ((tparsSel = info.getTypeParametersSelection()) == null ? new Selection(nameNode.getLine(), nameNode.getColumn() + nameNode.getText().length()) : new Selection(tparsSel.getEndLine(), tparsSel.getEndColumn())) : new Selection(superSel.getEndLine(), superSel.getEndColumn());
            info.setImplementsInsertSelection(s);
            info.setInterfaceSelections(Collections.EMPTY_LIST);
        }
    }

    private void processClassExtendsClause(AST cnode, LocatableAST nameNode, ClassInfo info) throws RecognitionException {
        LocatableAST superNode = (LocatableAST)cnode.getFirstChild();
        if (superNode != null) {
            String superName = this.getQualifiedName((AST)superNode);
            info.setSuperclass(superName);
            Selection sel = this.getTypeSel(superNode);
            info.setSuperReplaceSelection(sel);
            LocatableAST extendsN = (LocatableAST)cnode;
            LocatableToken extendsTok = extendsN.getImportantToken(0);
            sel = new Selection(extendsTok.getLine(), extendsTok.getColumn(), extendsTok.getText().length());
            info.setExtendsReplaceSelection(sel);
        } else {
            Selection tparSel = info.getTypeParametersSelection();
            Selection s = tparSel == null ? new Selection(nameNode.getLine(), nameNode.getColumn() + nameNode.getText().length()) : new Selection(tparSel.getEndLine(), tparSel.getEndColumn());
            info.setExtendsInsertSelection(s);
        }
    }

    private void processObjBlock(AST node, Scope scope) {
        int cnodeType;
        AST cnode;
        block11: for (cnode = node.getFirstChild(); cnode != null; cnode = cnode.getNextSibling()) {
            cnodeType = cnode.getType();
            switch (cnodeType) {
                case 10: {
                    AST vnode = cnode.getFirstChild();
                    vnode = vnode.getNextSibling();
                    vnode = vnode.getNextSibling();
                    scope.addVariable(vnode.getText());
                    continue block11;
                }
                case 14: 
                case 15: 
                case 46: {
                    AST cdnode = cnode.getFirstChild();
                    cdnode = cdnode.getNextSibling();
                    continue block11;
                }
            }
        }
        block12: for (cnode = node.getFirstChild(); cnode != null; cnode = cnode.getNextSibling()) {
            cnodeType = cnode.getType();
            switch (cnodeType) {
                case 10: {
                    this.processVarDef(cnode, scope);
                    continue block12;
                }
                case 8: 
                case 9: {
                    this.processMethodDef(cnode, scope);
                    continue block12;
                }
                case 47: {
                    this.processEnumConstantDef(cnode, scope);
                    continue block12;
                }
                case 11: 
                case 12: {
                    this.processCodeBlock(cnode.getFirstChild(), new Scope(scope));
                    continue block12;
                }
                case 14: 
                case 15: 
                case 46: {
                    this.processTypeDef(cnode, scope);
                    continue block12;
                }
                default: {
                    Debug.message("ClassParser: Unhandled node type: " + cnodeType);
                }
            }
        }
    }

    private void processEnumConstantDef(AST node, Scope scope) {
        node = node.getFirstChild();
        while (node.getType() != 69) {
            node = node.getNextSibling();
        }
        String name = node.getText();
        scope.addVariable(name);
        node = node.getNextSibling();
        if (node != null && node.getType() == 34) {
            this.processExpressionList(node, scope);
            node = node.getNextSibling();
        }
        if (node != null && node.getType() == 6) {
            Scope newScope = new Scope(scope);
            this.processObjBlock(node, newScope);
        }
    }

    private void processTypeDef(AST node, Scope scope) {
        AST cnode = node.getFirstChild();
        while (cnode.getType() != 6) {
            cnode = cnode.getNextSibling();
        }
        this.processObjBlock(cnode, new Scope(scope));
    }

    private void processCodeBlock(AST node, Scope scope) {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.processStatement(node, scope);
        }
    }

    private void processStatement(AST node, Scope scope) {
        int ntype = node.getType();
        switch (ntype) {
            case 28: {
                this.processExpression(node, scope);
                break;
            }
            case 22: {
                node = node.getFirstChild();
                node = node.getNextSibling();
                this.processStatement(node, scope);
            }
            case 42: 
            case 43: {
                this.processExpressionList(node.getFirstChild(), scope);
                break;
            }
            case 7: {
                this.processCodeBlock(node, new Scope(scope));
                break;
            }
            case 10: {
                this.processVarDef(node, scope);
                AST cnode = node.getFirstChild();
                cnode = cnode.getNextSibling();
                String varName = cnode.getNextSibling().getText();
                scope.addVariable(varName);
                break;
            }
            case 14: 
            case 15: 
            case 46: {
                this.processTypeDef(node, scope);
                break;
            }
            case 111: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                this.processStatement(node, scope);
                node = node.getNextSibling();
                if (node == null) break;
                this.processStatement(node, scope);
                break;
            }
            case 48: {
                AST iteratorNode;
                AST conditionNode;
                Scope forScope = new Scope(scope);
                node = node.getFirstChild();
                AST cnode = node.getFirstChild();
                if (cnode != null) {
                    this.processStatement(node.getFirstChild(), forScope);
                }
                if ((conditionNode = (node = node.getNextSibling()).getFirstChild()) != null) {
                    this.processExpression(conditionNode, forScope);
                }
                if ((iteratorNode = (node = node.getNextSibling()).getFirstChild()) != null) {
                    this.processExpressionList(iteratorNode, forScope);
                }
                node = node.getNextSibling();
                this.processStatement(node, forScope);
                break;
            }
            case 34: {
                this.processExpressionList(node, scope);
                break;
            }
            case 49: {
                node = node.getFirstChild();
                Scope forScope = new Scope(scope);
                this.processParameterDef(node, forScope);
                node = node.getNextSibling();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                this.processStatement(node, forScope);
                break;
            }
            case 113: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                this.processStatement(node, scope);
                break;
            }
            case 114: {
                node = node.getFirstChild();
                this.processStatement(node, scope);
                node = node.getNextSibling();
                this.processExpression(node, scope);
                break;
            }
            case 118: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                Scope switchScope = new Scope(scope);
                for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
                    for (AST caseNode = node.getFirstChild(); caseNode != null; caseNode = caseNode.getNextSibling()) {
                        int caseNodeType = caseNode.getType();
                        if (caseNodeType == 122) {
                            this.processExpression(caseNode.getFirstChild(), switchScope);
                            continue;
                        }
                        if (caseNodeType != 7) continue;
                        this.processCodeBlock(caseNode, switchScope);
                    }
                }
                break;
            }
            case 123: {
                node = node.getFirstChild();
                this.processStatement(node, scope);
                for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
                    if (node.getType() != 125) continue;
                    AST cnode = node.getFirstChild();
                    AST tnode = cnode.getFirstChild().getNextSibling();
                    String catchTypeName = this.getFirstLevelName(tnode.getFirstChild());
                    String catchVarName = tnode.getNextSibling().getText();
                    scope.checkType(catchTypeName);
                    Scope catchBlockScope = new Scope(scope);
                    catchBlockScope.addVariable(catchVarName);
                    this.processStatement(cnode.getNextSibling(), catchBlockScope);
                }
                break;
            }
            case 119: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                break;
            }
            case 117: {
                AST cnode = node.getFirstChild();
                if (cnode == null) break;
                this.processExpression(cnode, scope);
                break;
            }
            case 93: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                this.processStatement(node.getNextSibling(), scope);
            }
            case 120: {
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.processExpression(node, scope);
                }
            }
            case 38: 
            case 115: 
            case 116: {
                break;
            }
            default: {
                Debug.message("ClassParser (processCodeBlock) unhandled node type: " + ntype);
            }
        }
    }

    private void processParameterDef(AST node, Scope scope, List paramTypeList, List paramNameList) {
        boolean isVarArg = node.getType() == 44;
        AST tnode = node.getFirstChild().getNextSibling();
        String typeName = this.getFirstLevelName(tnode.getFirstChild());
        scope.checkType(typeName);
        if (paramTypeList != null) {
            String paramType = this.getCompleteTypeString(tnode.getFirstChild());
            if (isVarArg) {
                paramType = paramType + " ...";
            }
            paramTypeList.add(paramType);
        }
        String paramName = tnode.getNextSibling().getText();
        scope.addVariable(paramName);
        if (paramNameList != null) {
            paramNameList.add(paramName);
        }
    }

    private void processParameterDef(AST node, Scope scope) {
        this.processParameterDef(node, scope, null, null);
    }

    private void processVarDef(AST node, Scope scope) {
        AST cnode = node.getFirstChild();
        cnode = cnode.getNextSibling();
        String typeName = this.getFirstLevelName(cnode.getFirstChild());
        scope.checkType(typeName);
        AST initializerNode = cnode.getNextSibling().getNextSibling();
        if (initializerNode != null) {
            this.processExpression(initializerNode.getFirstChild(), scope);
        }
    }

    private void processExpression(AST node, Scope scope) {
        if (node.getType() == 28) {
            node = node.getFirstChild();
        }
        int ntype = node.getType();
        switch (ntype) {
            case 69: {
                String name = node.getText();
                if (scope.checkVariable(name)) break;
                scope.checkType(name);
                break;
            }
            case 68: {
                node = node.getFirstChild();
                AST secondChild = node.getNextSibling();
                if (secondChild.getType() == 101) {
                    while (node.getType() == 17) {
                        node = node.getFirstChild();
                    }
                    String className = this.getFirstLevelName(node);
                    scope.checkType(className);
                    break;
                }
                this.processExpression(node, scope);
                if (secondChild.getType() != 158) break;
                node = secondChild.getFirstChild();
                node = node.getNextSibling();
                this.processExpressionList(node, scope);
                break;
            }
            case 42: {
                node = node.getFirstChild();
                this.processExpression(node.getFirstChild(), scope);
                this.processExpressionList(node.getNextSibling(), scope);
                break;
            }
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 151: 
            case 152: 
            case 154: {
                this.processExpression(node.getFirstChild(), scope);
                break;
            }
            case 24: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 87: 
            case 98: 
            case 104: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                this.processExpression(node, scope);
                break;
            }
            case 70: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                this.processExpression(node, scope);
                break;
            }
            case 145: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                node = node.getNextSibling();
                String tname = this.getFirstLevelName(node.getFirstChild());
                scope.checkType(tname);
                break;
            }
            case 27: {
                node = node.getFirstChild();
                this.processExpression(node, scope);
                this.processExpressionList(node.getNextSibling(), scope);
                break;
            }
            case 23: {
                node = node.getFirstChild();
                String typeName = this.getFirstLevelName(node.getFirstChild());
                scope.checkType(typeName);
                this.processExpression(node.getNextSibling(), scope);
                break;
            }
            case 158: {
                node = node.getFirstChild();
                String typeName = this.getFirstLevelName(node);
                scope.checkType(typeName);
                node = node.getNextSibling();
                if (node.getType() == 34) {
                    this.processExpressionList(node, scope);
                    break;
                }
                for (AST anode = node.getFirstChild(); anode != null && anode.getType() == 17; anode = anode.getFirstChild()) {
                    AST exprNode = anode.getNextSibling();
                    if (exprNode == null) continue;
                    this.processExpression(exprNode, scope);
                }
                if ((node = node.getNextSibling()) == null) break;
                this.processExpression(node, scope);
                break;
            }
            case 29: {
                this.processExpressionList(node, scope);
                break;
            }
            case 72: 
            case 107: 
            case 155: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                break;
            }
            default: {
                Debug.message("ClassParser: Unhandled node type (expression) : " + ntype);
            }
        }
    }

    private void processExpressionList(AST node, Scope scope) {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.processExpression(node, scope);
        }
    }

    private void processMethodDef(AST node, Scope scope) {
        String rtypeName;
        Token commentToken;
        boolean hasModifiers;
        boolean isConstructor = node.getType() == 8;
        ArrayList paramTypes = new ArrayList();
        ArrayList paramNames = new ArrayList();
        String typeParams = null;
        AST cnode = node.getFirstChild();
        boolean bl = hasModifiers = cnode.getFirstChild() != null;
        if (hasModifiers) {
            commentToken = this.getHiddenBefore(cnode);
            cnode = cnode.getNextSibling();
        } else {
            cnode = cnode.getNextSibling();
            commentToken = this.getHiddenBefore(cnode);
        }
        if (cnode.getType() == 56) {
            typeParams = this.getTypeParamList(cnode);
            cnode = cnode.getNextSibling();
        }
        if (!isConstructor) {
            rtypeName = this.getFirstLevelName(cnode.getFirstChild());
            scope.checkType(rtypeName);
            rtypeName = this.getCompleteTypeString(cnode.getFirstChild());
            cnode = cnode.getNextSibling();
        } else {
            rtypeName = null;
        }
        String methodName = cnode.getText();
        cnode = cnode.getNextSibling();
        Scope methodScope = new Scope(scope);
        for (AST paramDef = cnode.getFirstChild(); paramDef != null; paramDef = paramDef.getNextSibling()) {
            this.processParameterDef(paramDef, methodScope, paramTypes, paramNames);
        }
        while (cnode != null) {
            if (cnode.getType() == 7) {
                this.processCodeBlock(cnode, methodScope);
                break;
            }
            cnode = cnode.getNextSibling();
        }
        String commentText = null;
        if (commentToken != null) {
            commentText = commentToken.getText();
        }
        scope.addMethod(methodName, typeParams, rtypeName, paramTypes, paramNames, commentText);
    }

    private String getTypeParamList(AST node) {
        String r = "<";
        node = node.getFirstChild();
        r = r + this.getTypeParamString(node);
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            r = r + "," + this.getTypeParamString(node);
        }
        r = r + ">";
        return r;
    }

    private String getTypeParamString(AST node) {
        String tpar = node.getText();
        if ((node = node.getFirstChild()) != null) {
            tpar = tpar + " extends ";
            node = node.getFirstChild();
            tpar = tpar + this.getCompleteTypeString(node);
            for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
                tpar = tpar + " & " + this.getCompleteTypeString(node);
            }
        }
        return tpar;
    }

    private String getCompleteTypeString(AST node) {
        String tstring;
        if (node.getType() == 13) {
            node = node.getFirstChild();
        }
        AST arrayNode = node.getNextSibling();
        int ntype = node.getType();
        if (ntype == 68) {
            node = node.getFirstChild();
            AST second = node.getNextSibling();
            tstring = this.getCompleteTypeString(node) + "." + this.getCompleteTypeString(second);
            node = second.getNextSibling();
        } else {
            tstring = node.getText();
            if ((node = node.getFirstChild()) != null && node.getType() == 55) {
                tstring = tstring + "<";
                tstring = tstring + this.getTypeArgString(node);
                for (node = node.getNextSibling(); node != null && node.getType() == 55; node = node.getNextSibling()) {
                    tstring = tstring + "," + this.getTypeArgString(node);
                }
                tstring = tstring + ">";
            }
        }
        while (arrayNode != null && arrayNode.getType() == 17) {
            tstring = tstring + "[]";
            arrayNode = arrayNode.getNextSibling();
        }
        return tstring;
    }

    private String getTypeArgString(AST node) {
        if ((node = node.getFirstChild()).getType() == 57) {
            String targ = "?";
            if ((node = node.getFirstChild()) != null) {
                targ = node.getType() == 58 ? targ + " extends " : targ + " super ";
                targ = targ + this.getCompleteTypeString(node.getFirstChild());
            }
            return targ;
        }
        return this.getCompleteTypeString(node);
    }

    private Token getHiddenBefore(AST node) {
        while (node instanceof LocatableAST) {
            LocatableAST lnode = (LocatableAST)node;
            LocatableToken r = lnode.getHiddenBefore();
            if (r != null) {
                return r;
            }
            node = node.getFirstChild();
        }
        return null;
    }

    private String getFirstLevelName(AST node) {
        while (node.getType() == 68) {
            node = node.getFirstChild();
        }
        return node.getText();
    }

    private String getQualifiedName(AST node) throws RecognitionException {
        if (node.getType() == 69) {
            return node.getText();
        }
        if (node.getType() != 68) {
            throw new RecognitionException();
        }
        AST cnode = node.getFirstChild();
        String name = this.getQualifiedName(cnode);
        name = name + "." + cnode.getNextSibling().getText();
        return name;
    }

    private Selection getTypeSel(LocatableAST node) throws RecognitionException {
        if (node.getType() == 69) {
            Selection s = new Selection(node.getLine(), node.getColumn(), node.getLength());
            LocatableAST c = (LocatableAST)node.getFirstChild();
            if (c != null && c.getType() == 55 && c.getImportantTokenCount() != 0) {
                LocatableToken tend = c.getImportantToken(0);
                int line = tend.getLine();
                int col = tend.getEndColumn();
                s.extendEnd(line, col);
            }
            return s;
        }
        if (node.getType() != 68) {
            throw new RecognitionException();
        }
        LocatableAST lnode = (LocatableAST)node.getFirstChild();
        LocatableAST rnode = (LocatableAST)lnode.getNextSibling();
        Selection s = this.getTypeSel(rnode);
        while (lnode.getType() == 68) {
            node = lnode;
            lnode = (LocatableAST)node.getFirstChild();
        }
        if (lnode.getType() != 69) {
            throw new RecognitionException();
        }
        Selection ns = new Selection(lnode.getLine(), lnode.getColumn(), lnode.getLength());
        ns.combineWith(s);
        return ns;
    }
}

