/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.actions.ValidateCvsConnectionAction;
import bluej.groupwork.ui.MiksGridLayout;
import bluej.groupwork.ui.TeamPanelFocusPolicy;
import bluej.groupwork.ui.TeamSettingsDialog;
import java.awt.BorderLayout;
import java.awt.FocusTraversalPolicy;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TeamSettingsPanel
extends JPanel {
    private static final int fieldsize = 20;
    private final String pserverLabel = Config.getString("team.settings.pserver");
    private final String extLabel = Config.getString("team.settings.ext");
    private final String[] conTypes = new String[]{this.extLabel, this.pserverLabel};
    private TeamSettingsController teamSettingsController;
    private TeamSettingsDialog teamSettingsDialog;
    JTextField userField;
    JPasswordField passwordField;
    JTextField groupField;
    JTextField prefixField;
    JTextField serverField;
    JComboBox protocolComboBox;
    JButton validateButton;
    JCheckBox useAsDefault;
    JLabel groupLabel;
    JLabel prefixLabel;
    JLabel serverLabel;
    JLabel protocolLabel;
    private boolean okEnabled = true;

    public TeamSettingsPanel(TeamSettingsController teamSettingsController, TeamSettingsDialog dialog) {
        this.teamSettingsController = teamSettingsController;
        this.teamSettingsDialog = dialog;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.generalBorder);
        this.add(Box.createVerticalGlue());
        this.add(this.makePersonalPanel());
        this.add(Box.createVerticalStrut(5));
        this.add(this.makeLocationPanel());
        this.add(Box.createVerticalStrut(5));
        this.useAsDefault = new JCheckBox(Config.getString("team.settings.rememberSettings"));
        this.add(this.useAsDefault);
        this.add(Box.createVerticalStrut(5));
        this.validateButton = new JButton(new ValidateCvsConnectionAction(Config.getString("team.settings.checkConnection"), this, dialog));
        this.add(this.validateButton);
        DocumentListener changeListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }

            public void insertUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }

            public void removeUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }
        };
        this.userField.getDocument().addDocumentListener(changeListener);
        this.serverField.getDocument().addDocumentListener(changeListener);
        this.add(Box.createVerticalGlue());
        this.setupContent();
        this.checkOkEnabled();
        if (!teamSettingsController.hasProject()) {
            this.useAsDefault.setSelected(true);
        }
    }

    public FocusTraversalPolicy getTraversalPolicy(FocusTraversalPolicy delegate) {
        if (this.getUser().length() != 0) {
            return new TeamPanelFocusPolicy(this.passwordField, delegate);
        }
        return delegate;
    }

    public void disableRepositorySettings() {
        this.groupField.setEnabled(false);
        this.prefixField.setEnabled(false);
        this.serverField.setEnabled(false);
        this.protocolComboBox.setEnabled(false);
        this.groupLabel.setEnabled(false);
        this.prefixLabel.setEnabled(false);
        this.serverLabel.setEnabled(false);
        this.protocolLabel.setEnabled(false);
    }

    private JPanel makePersonalPanel() {
        JPanel authentificationPanel = new JPanel();
        authentificationPanel.setLayout(new MiksGridLayout(3, 2, 10, 5));
        String docTitle = Config.getString("team.settings.personal");
        authentificationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        authentificationPanel.setAlignmentX(0.0f);
        JLabel userLabel = new JLabel(Config.getString("team.settings.user"));
        this.userField = new JTextField(20);
        JLabel passwordLabel = new JLabel(Config.getString("team.settings.password"));
        this.passwordField = new JPasswordField(20);
        this.groupLabel = new JLabel(Config.getString("team.settings.group"));
        this.groupField = new JTextField(20);
        userLabel.setMaximumSize(userLabel.getMinimumSize());
        this.userField.setMaximumSize(this.userField.getMinimumSize());
        passwordLabel.setMaximumSize(passwordLabel.getMinimumSize());
        this.passwordField.setMaximumSize(this.passwordField.getMinimumSize());
        this.groupLabel.setMaximumSize(this.groupLabel.getMinimumSize());
        this.groupField.setMaximumSize(this.groupField.getMinimumSize());
        authentificationPanel.add(userLabel);
        authentificationPanel.add(this.userField);
        authentificationPanel.add(passwordLabel);
        authentificationPanel.add(this.passwordField);
        authentificationPanel.add(this.groupLabel);
        authentificationPanel.add(this.groupField);
        return authentificationPanel;
    }

    private JPanel makeLocationPanel() {
        JPanel locationPanel = new JPanel(new BorderLayout(5, 0));
        locationPanel.setLayout(new MiksGridLayout(3, 2, 10, 5));
        String docTitle2 = Config.getString("team.settings.location");
        locationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle2), BlueJTheme.generalBorder));
        locationPanel.setAlignmentX(0.0f);
        this.serverLabel = new JLabel(Config.getString("team.settings.server"));
        this.serverField = new JTextField(20);
        this.prefixLabel = new JLabel(Config.getString("team.settings.prefix"));
        this.prefixField = new JTextField(20);
        this.protocolLabel = new JLabel(Config.getString("team.settings.protocol"));
        this.protocolComboBox = new JComboBox<String>(this.conTypes);
        this.protocolComboBox.setEditable(false);
        this.prefixLabel.setMaximumSize(this.prefixLabel.getMinimumSize());
        this.prefixField.setMaximumSize(this.prefixField.getMinimumSize());
        this.serverLabel.setMaximumSize(this.serverLabel.getMinimumSize());
        this.serverField.setMaximumSize(this.serverField.getMinimumSize());
        locationPanel.add(this.serverLabel);
        locationPanel.add(this.serverField);
        locationPanel.add(this.prefixLabel);
        locationPanel.add(this.prefixField);
        locationPanel.add(this.protocolLabel);
        locationPanel.add(this.protocolComboBox);
        return locationPanel;
    }

    private void setupContent() {
        String protocol;
        String useAsDefault;
        String server;
        String prefix;
        String group;
        String password;
        String user = this.teamSettingsController.getPropString("bluej.teamsettings.user");
        if (user != null) {
            this.setUser(user);
        }
        if ((password = this.teamSettingsController.getPasswordString()) != null) {
            this.setPassword(password);
        }
        if ((group = this.teamSettingsController.getPropString("bluej.teamsettings.groupname")) != null) {
            this.setGroup(group);
        }
        if ((prefix = this.teamSettingsController.getPropString("bluej.teamsettings.cvs.repositoryPrefix")) != null) {
            this.setPrefix(prefix);
        }
        if ((server = this.teamSettingsController.getPropString("bluej.teamsettings.cvs.server")) != null) {
            this.setServer(server);
        }
        if ((useAsDefault = this.teamSettingsController.getPropString("bluej.teamsettings.useAsDefault")) != null) {
            this.setUseAsDefault(Boolean.getBoolean(useAsDefault));
        }
        if ((protocol = this.teamSettingsController.getPropString("bluej.teamsettings.cvs.protocol")) != null) {
            this.setProtocol(protocol);
        }
    }

    private void checkOkEnabled() {
        boolean newOkEnabled = this.userField.getText().length() != 0;
        if ((newOkEnabled &= this.serverField.getText().length() != 0) != this.okEnabled) {
            this.okEnabled = newOkEnabled;
            this.teamSettingsDialog.setOkButtonEnabled(this.okEnabled);
        }
    }

    private void setUser(String user) {
        this.userField.setText(user);
    }

    private void setPassword(String password) {
        this.passwordField.setText(password);
    }

    private void setGroup(String group) {
        this.groupField.setText(group);
    }

    private void setPrefix(String prefix) {
        this.prefixField.setText(prefix);
    }

    private void setServer(String server) {
        this.serverField.setText(server);
    }

    private void setProtocol(String connectionType) {
        this.protocolComboBox.setSelectedItem(connectionType);
    }

    private void setUseAsDefault(boolean use) {
        this.useAsDefault.setSelected(use);
    }

    public String getUser() {
        return this.userField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public String getGroup() {
        return this.groupField.getText();
    }

    public String getPrefix() {
        return this.prefixField.getText();
    }

    public String getServer() {
        return this.serverField.getText();
    }

    public String getProtocol() {
        return (String)this.protocolComboBox.getSelectedItem();
    }

    public boolean getUseAsDefault() {
        return this.useAsDefault.isSelected();
    }
}

