/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.cvsnb.ProtocolMapper;
import bluej.groupwork.ui.TeamSettingsPanel;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TeamSettingsDialog
extends EscapeDialog {
    private String title = Config.getString("team.settings.title");
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private TeamSettingsController teamSettingsController;
    private TeamSettingsPanel teamSettingsPanel;
    private int event;
    private JButton okButton;

    public TeamSettingsDialog(TeamSettingsController controller) {
        this.teamSettingsController = controller;
        this.event = 1;
        if (this.teamSettingsController.hasProject()) {
            this.title = this.title + " - " + this.teamSettingsController.getProject().getProjectName();
        }
        this.setTitle(this.title);
        this.setModal(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = this.makeButtonPanel();
        this.teamSettingsPanel = new TeamSettingsPanel(this.teamSettingsController, this);
        this.setFocusTraversalPolicy(this.teamSettingsPanel.getTraversalPolicy(this.getFocusTraversalPolicy()));
        mainPanel.add(this.teamSettingsPanel);
        mainPanel.add(buttonPanel);
        this.setContentPane(mainPanel);
        this.pack();
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        this.okButton = BlueJTheme.getOkButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String userKey = "bluej.teamsettings.user";
                String userValue = TeamSettingsDialog.this.teamSettingsPanel.getUser();
                TeamSettingsDialog.this.teamSettingsController.setPropString(userKey, userValue);
                String passValue = TeamSettingsDialog.this.teamSettingsPanel.getPassword();
                TeamSettingsDialog.this.teamSettingsController.setPasswordString(passValue);
                String serverKey = "bluej.teamsettings.cvs.server";
                String serverValue = TeamSettingsDialog.this.teamSettingsPanel.getServer();
                TeamSettingsDialog.this.teamSettingsController.setPropString(serverKey, serverValue);
                String prefixKey = "bluej.teamsettings.cvs.repositoryPrefix";
                String prefixValue = TeamSettingsDialog.this.teamSettingsPanel.getPrefix();
                TeamSettingsDialog.this.teamSettingsController.setPropString(prefixKey, prefixValue);
                String groupKey = "bluej.teamsettings.groupname";
                String groupValue = TeamSettingsDialog.this.teamSettingsPanel.getGroup();
                TeamSettingsDialog.this.teamSettingsController.setPropString(groupKey, groupValue);
                String protocolKey = "bluej.teamsettings.cvs.protocol";
                String protocolValue = ProtocolMapper.getProtocol(TeamSettingsDialog.this.teamSettingsPanel.getProtocol());
                TeamSettingsDialog.this.teamSettingsController.setPropString(protocolKey, protocolValue);
                String useAsDefaultKey = "bluej.teamsettings.useAsDefault";
                Config.putPropString(useAsDefaultKey, Boolean.toString(TeamSettingsDialog.this.teamSettingsPanel.getUseAsDefault()));
                if (TeamSettingsDialog.this.teamSettingsPanel.getUseAsDefault()) {
                    Config.putPropString(userKey, userValue);
                    Config.putPropString(serverKey, serverValue);
                    Config.putPropString(prefixKey, prefixValue);
                    Config.putPropString(groupKey, groupValue);
                    Config.putPropString(protocolKey, protocolValue);
                }
                if (TeamSettingsDialog.this.teamSettingsController != null && TeamSettingsDialog.this.teamSettingsController.hasProject()) {
                    TeamSettingsDialog.this.teamSettingsController.writeToProject();
                }
                TeamSettingsDialog.this.event = 0;
                TeamSettingsDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TeamSettingsDialog.this.event = 1;
                TeamSettingsDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public void disableRepositorySettings() {
        this.teamSettingsPanel.disableRepositorySettings();
    }

    public int doTeamSettings() {
        this.setVisible(true);
        return this.event;
    }

    public void setOkButtonEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }
}

