/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.ui.ResourceDescriptor;
import bluej.pkgmgr.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class StatusTableModel
extends AbstractTableModel {
    static final String resourceLabel = Config.getString("team.status.resource");
    static final String statusLabel = Config.getString("team.status.status");
    static final String versionLabel = Config.getString("team.status.version");
    private Project project;
    private List resources;

    public StatusTableModel(Project project, int initialRows) {
        this.project = project;
        this.resources = new ArrayList();
        for (int i = 0; i < initialRows; ++i) {
            this.resources.add(new TeamStatusInfo());
        }
    }

    public StatusTableModel(List teamResources) {
        this.resources = teamResources;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return resourceLabel;
        }
        if (col == 1) {
            return versionLabel;
        }
        if (col == 2) {
            return statusLabel;
        }
        throw new IllegalArgumentException("bad column number in StatusTableModel::getColumnName()");
    }

    public int getRowCount() {
        return this.resources.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int col) {
        TeamStatusInfo info = (TeamStatusInfo)this.resources.get(row);
        if (col == 0) {
            return ResourceDescriptor.getResource(this.project, info, false);
        }
        if (col == 1) {
            return info.getLocalVersion();
        }
        if (col == 2) {
            return new Integer(info.getStatus());
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
    }

    public void clear() {
        this.resources.clear();
        this.fireTableDataChanged();
    }

    public void setStatusData(List statusResources) {
        this.resources = statusResources;
        this.fireTableDataChanged();
    }
}

