/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.groupwork.TeamStatusInfo;
import bluej.pkgmgr.Project;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class StatusMessageCellRenderer
extends DefaultTableCellRenderer {
    private static final Color UPTODATE = Color.BLACK;
    private static final Color NEEDSUPDATE;
    private static final Color NEEDSCHECKOUT;
    private static final Color REMOVED;
    private static final Color NEEDSMERGE;
    private static final Color NEEDSCOMMIT;
    private static final Color NEEDSADD;
    private static final Color DELETED;
    private static final Color CONFLICT;
    Project project;

    public StatusMessageCellRenderer(Project project) {
        this.project = project;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(jTable, object, isSelected, hasFocus, row, column);
        int status = this.getStatus(jTable, row);
        this.setForeground(this.getStatusColour(status));
        String statusLabel = this.getStatusString(object, status, row, column);
        this.setText(statusLabel);
        this.setForeground(this.getStatusColour(status));
        return this;
    }

    private int getStatus(JTable table, int row) {
        int status = 0;
        Object val = table.getModel().getValueAt(row, 2);
        if (val instanceof Integer) {
            status = (Integer)val;
        }
        return status;
    }

    private String getStatusString(Object value, int statusValue, int row, int col) {
        if (col == 0 || col == 1) {
            return value.toString();
        }
        return TeamStatusInfo.getStatusString(statusValue);
    }

    private Color getStatusColour(int statusValue) {
        Color color = Color.BLACK;
        color = statusValue == 0 ? UPTODATE : (statusValue == 1 ? NEEDSCHECKOUT : (statusValue == 2 ? DELETED : (statusValue == 3 ? NEEDSUPDATE : (statusValue == 4 ? NEEDSCOMMIT : (statusValue == 5 ? NEEDSMERGE : (statusValue == 6 ? NEEDSADD : (statusValue == 7 ? REMOVED : CONFLICT)))))));
        return color;
    }

    static {
        NEEDSCHECKOUT = NEEDSUPDATE = new Color(11, 57, 120);
        REMOVED = new Color(135, 150, 170);
        NEEDSMERGE = new Color(137, 13, 19);
        NEEDSADD = NEEDSCOMMIT = new Color(10, 85, 15);
        DELETED = new Color(122, 143, 123);
        CONFLICT = NEEDSMERGE;
    }
}

