/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.CommitFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.CommitAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.FileRenderer;
import bluej.pkgmgr.Project;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class CommitCommentsFrame
extends EscapeDialog {
    private JList commitFiles;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JTextArea commitText;
    private JButton commitButton;
    private JCheckBox includeLayout;
    private ActivityIndicator progressBar;
    private CommitAction commitAction;
    private CommitWorker commitWorker;
    private Project project;
    private Repository repository;
    private DefaultListModel commitListModel;
    private Set changedLayoutFiles;
    private static String noFilesToCommit = Config.getString("team.nocommitfiles");

    public CommitCommentsFrame(Project proj) {
        this.project = proj;
        this.changedLayoutFiles = new HashSet();
        this.createUI();
        DialogManager.centreDialog(this);
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        if (show) {
            this.commitAction.setEnabled(false);
            this.commitText.setEnabled(false);
            this.includeLayout.setSelected(false);
            this.includeLayout.setEnabled(false);
            this.changedLayoutFiles.clear();
            this.commitListModel.removeAllElements();
            this.repository = this.project.getRepository();
            if (this.repository != null) {
                this.project.saveAllEditors();
                this.project.saveAllGraphLayout();
                this.startProgress();
                this.commitWorker = new CommitWorker();
                this.commitWorker.start();
            } else {
                super.setVisible(false);
            }
        }
    }

    protected void createUI() {
        this.setTitle(Config.getString("team.commit.title"));
        this.commitListModel = new DefaultListModel();
        this.setLocation(Config.getLocation("bluej.commitdisplay"));
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.commitdisplay", CommitCommentsFrame.this.getLocation());
            }
        });
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setBorder(BlueJTheme.generalBorderWithStatusBar);
        splitPane.setResizeWeight(0.5);
        this.topPanel = new JPanel();
        JScrollPane commitFileScrollPane = new JScrollPane();
        this.topPanel.setLayout(new BorderLayout());
        JLabel commitFilesLabel = new JLabel(Config.getString("team.commit.files"));
        commitFilesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.topPanel.add((Component)commitFilesLabel, "North");
        this.commitFiles = new JList(this.commitListModel);
        this.commitFiles.setCellRenderer(new FileRenderer(this.project));
        this.commitFiles.setEnabled(false);
        commitFileScrollPane.setViewportView(this.commitFiles);
        this.topPanel.add((Component)commitFileScrollPane, "Center");
        splitPane.setTopComponent(this.topPanel);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        JLabel commentLabel = new JLabel(Config.getString("team.commit.comment"));
        commentLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.bottomPanel.add((Component)commentLabel, "North");
        this.commitText = new JTextArea("");
        this.commitText.setRows(6);
        this.commitText.setColumns(42);
        Dimension size = this.commitText.getPreferredSize();
        size.width = this.commitText.getMinimumSize().width;
        this.commitText.setMinimumSize(size);
        JScrollPane commitTextScrollPane = new JScrollPane(this.commitText);
        commitTextScrollPane.setMinimumSize(size);
        this.bottomPanel.add((Component)commitTextScrollPane, "Center");
        this.commitAction = new CommitAction(this);
        this.commitButton = BlueJTheme.getOkButton();
        this.commitButton.setAction(this.commitAction);
        this.getRootPane().setDefaultButton(this.commitButton);
        JButton closeButton = BlueJTheme.getCancelButton();
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommitCommentsFrame.this.commitWorker.abort();
                CommitCommentsFrame.this.commitAction.cancel();
                CommitCommentsFrame.this.setVisible(false);
            }
        });
        DBox buttonPanel = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.5f);
        buttonPanel.setBorder(BlueJTheme.generalBorder);
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        DBox checkBoxPanel = new DBox(DBoxLayout.Y_AXIS, 0, 5, 0.5f);
        this.includeLayout = new JCheckBox(Config.getString("team.commit.includelayout"));
        this.includeLayout.setEnabled(false);
        this.includeLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox layoutCheck = (JCheckBox)e.getSource();
                if (layoutCheck.isSelected()) {
                    CommitCommentsFrame.this.addModifiedLayouts();
                    if (!CommitCommentsFrame.this.commitButton.isEnabled()) {
                        CommitCommentsFrame.this.commitAction.setEnabled(true);
                    }
                } else {
                    CommitCommentsFrame.this.removeModifiedLayouts();
                    if (CommitCommentsFrame.this.isCommitListEmpty()) {
                        CommitCommentsFrame.this.commitAction.setEnabled(false);
                    }
                }
            }
        });
        checkBoxPanel.add(this.includeLayout);
        checkBoxPanel.add(buttonPanel);
        buttonPanel.add(this.progressBar);
        buttonPanel.add(this.commitButton);
        buttonPanel.add(closeButton);
        this.bottomPanel.add((Component)checkBoxPanel, "South");
        splitPane.setBottomComponent(this.bottomPanel);
        this.getContentPane().add(splitPane);
        this.pack();
    }

    public String getComment() {
        return this.commitText.getText();
    }

    public void setComment(String newComment) {
        this.commitText.setText(newComment);
    }

    public void reset() {
        this.commitListModel.clear();
        this.setComment("");
    }

    private void removeModifiedLayouts() {
        Iterator it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            this.commitListModel.removeElement(it.next());
        }
        if (this.commitListModel.isEmpty()) {
            this.commitListModel.addElement(noFilesToCommit);
            this.commitText.setEnabled(false);
        }
    }

    private boolean isCommitListEmpty() {
        return this.commitListModel.isEmpty() || this.commitListModel.contains(noFilesToCommit);
    }

    private void addModifiedLayouts() {
        if (this.commitListModel.contains(noFilesToCommit)) {
            this.commitListModel.removeElement(noFilesToCommit);
            this.commitText.setEnabled(true);
        }
        Iterator it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            this.commitListModel.addElement(it.next());
        }
    }

    public Set getChangedLayoutFiles() {
        HashSet<File> files = new HashSet<File>();
        Iterator it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            TeamStatusInfo info = (TeamStatusInfo)it.next();
            files.add(info.getFile());
        }
        return files;
    }

    public boolean includeLayout() {
        return this.includeLayout != null && this.includeLayout.isSelected();
    }

    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    public void stopProgress() {
        this.progressBar.setRunning(false);
    }

    public Project getProject() {
        return this.project;
    }

    private void setLayoutChanged(boolean hasChanged) {
        this.includeLayout.setEnabled(hasChanged);
    }

    class CommitWorker
    extends SwingWorker
    implements StatusListener {
        List response = new ArrayList();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;

        public CommitWorker() {
            Set files = CommitCommentsFrame.this.project.getTeamSettingsController().getProjectFiles(true);
            this.command = CommitCommentsFrame.this.repository.getStatus(this, files, false);
        }

        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        public void finished() {
            CommitCommentsFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    TeamUtils.handleServerResponse(this.result, CommitCommentsFrame.this);
                    CommitCommentsFrame.this.setVisible(false);
                } else if (this.response != null) {
                    HashSet filesToCommit = new HashSet();
                    HashSet filesToAdd = new HashSet();
                    HashSet filesToDelete = new HashSet();
                    HashSet mergeConflicts = new HashSet();
                    HashSet deleteConflicts = new HashSet();
                    HashSet otherConflicts = new HashSet();
                    HashSet needsMerge = new HashSet();
                    HashSet modifiedLayoutFiles = new HashSet();
                    List info = this.response;
                    this.getCommitFileSets(info, filesToCommit, filesToAdd, filesToDelete, mergeConflicts, deleteConflicts, otherConflicts, needsMerge, modifiedLayoutFiles);
                    if (!(mergeConflicts.isEmpty() && deleteConflicts.isEmpty() && otherConflicts.isEmpty() && needsMerge.isEmpty())) {
                        this.handleConflicts(mergeConflicts, deleteConflicts, otherConflicts, needsMerge);
                        return;
                    }
                    CommitCommentsFrame.this.commitAction.setFiles(filesToCommit);
                    CommitCommentsFrame.this.commitAction.setNewFiles(filesToAdd);
                    CommitCommentsFrame.this.commitAction.setDeletedFiles(filesToDelete);
                }
                if (CommitCommentsFrame.this.commitListModel.isEmpty()) {
                    CommitCommentsFrame.this.commitListModel.addElement(noFilesToCommit);
                } else {
                    CommitCommentsFrame.this.commitText.setEnabled(true);
                    CommitCommentsFrame.this.commitText.requestFocusInWindow();
                    CommitCommentsFrame.this.commitAction.setEnabled(true);
                }
            }
        }

        private void handleConflicts(Set mergeConflicts, Set deleteConflicts, Set otherConflicts, Set needsMerge) {
            String filesList;
            String dlgLabel;
            if (!mergeConflicts.isEmpty()) {
                dlgLabel = "team-resolve-merge-conflicts";
                filesList = this.buildConflictsList(mergeConflicts);
            } else if (!deleteConflicts.isEmpty()) {
                dlgLabel = "team-resolve-conflicts-delete";
                filesList = this.buildConflictsList(deleteConflicts);
            } else if (!otherConflicts.isEmpty()) {
                dlgLabel = "team-update-first";
                filesList = this.buildConflictsList(otherConflicts);
            } else {
                CommitCommentsFrame.this.stopProgress();
                DialogManager.showMessage(CommitCommentsFrame.this, "team-uptodate-failed");
                CommitCommentsFrame.this.setVisible(false);
                return;
            }
            CommitCommentsFrame.this.stopProgress();
            DialogManager.showMessageWithText(CommitCommentsFrame.this, dlgLabel, filesList);
            CommitCommentsFrame.this.setVisible(false);
        }

        private String buildConflictsList(Set conflicts) {
            String filesList = "";
            Iterator i = conflicts.iterator();
            for (int j = 0; j < 10 && i.hasNext(); ++j) {
                File conflictFile = (File)i.next();
                filesList = filesList + "    " + conflictFile.getName() + "\n";
            }
            if (i.hasNext()) {
                filesList = filesList + "    " + Config.getString("team.commit.moreFiles");
            }
            return filesList;
        }

        private void getCommitFileSets(List info, Set filesToCommit, Set filesToAdd, Set filesToRemove, Set mergeConflicts, Set deleteConflicts, Set otherConflicts, Set needsMerge, Set modifiedLayoutFiles) {
            CommitFilter filter = new CommitFilter();
            Iterator it = info.iterator();
            while (it.hasNext()) {
                TeamStatusInfo statusInfo = (TeamStatusInfo)it.next();
                int status = statusInfo.getStatus();
                if (filter.accept(statusInfo)) {
                    if (!statusInfo.getFile().getName().equals("bluej.pkg") || status == 6 || status == 2) {
                        CommitCommentsFrame.this.commitListModel.addElement(statusInfo);
                        filesToCommit.add(statusInfo.getFile());
                    }
                    if (status == 6) {
                        filesToAdd.add(statusInfo.getFile());
                        continue;
                    }
                    if (status == 2) {
                        filesToRemove.add(statusInfo.getFile());
                        continue;
                    }
                    if (!statusInfo.getFile().getName().equals("bluej.pkg")) continue;
                    modifiedLayoutFiles.add(statusInfo.getFile());
                    CommitCommentsFrame.this.changedLayoutFiles.add(statusInfo);
                    CommitCommentsFrame.this.setLayoutChanged(true);
                    continue;
                }
                if (statusInfo.getFile().getName().equals("bluej.pkg") && !CommitCommentsFrame.this.includeLayout()) continue;
                if (status == 9) {
                    mergeConflicts.add(statusInfo.getFile());
                }
                if (status == 8 || status == 12 || status == 13) {
                    deleteConflicts.add(statusInfo.getFile());
                }
                if (status == 14) {
                    otherConflicts.add(statusInfo.getFile());
                }
                if (status != 5) continue;
                needsMerge.add(statusInfo.getFile());
            }
        }
    }
}

