/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.cvsnb.CvsRepository;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.utility.DBox;
import bluej.utility.EscapeDialog;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;

public class CheckConnectionDialog
extends EscapeDialog {
    private ActivityIndicator activityIndicator;
    private String cvsRoot;
    private JLabel connLabel;
    private JButton closeButton;

    public CheckConnectionDialog(Dialog owner, String cvsRoot) {
        super(owner, true);
        this.setTitle(Config.getString("team.settings.checkConnection"));
        this.cvsRoot = cvsRoot;
        this.buildUI();
        this.setLocationRelativeTo(owner);
    }

    private void buildUI() {
        DBox contentPane = new DBox(DBox.Y_AXIS, 0, 11, 0.0f);
        contentPane.setBorder(BlueJTheme.dialogBorder);
        this.setContentPane(contentPane);
        this.connLabel = new JLabel(Config.getString("team.checkconn.checking"));
        contentPane.add(this.connLabel);
        this.activityIndicator = new ActivityIndicator();
        this.activityIndicator.setRunning(true);
        contentPane.add(this.activityIndicator);
        this.closeButton = BlueJTheme.getCancelButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckConnectionDialog.this.setVisible(false);
            }
        });
        contentPane.add(this.closeButton);
        this.pack();
    }

    public void setVisible(boolean vis) {
        if (vis) {
            new Thread(){

                public void run() {
                    final boolean res = CheckConnectionDialog.this.validateConnection();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (res) {
                                CheckConnectionDialog.this.connLabel.setText(Config.getString("team.checkconn.ok"));
                            } else {
                                CheckConnectionDialog.this.connLabel.setText(Config.getString("team.checkconn.bad"));
                            }
                            CheckConnectionDialog.this.activityIndicator.setRunning(false);
                            CheckConnectionDialog.this.closeButton.setText(BlueJTheme.getCloseLabel());
                            CheckConnectionDialog.this.pack();
                        }
                    });
                }
            }.start();
        }
        super.setVisible(vis);
    }

    private boolean validateConnection() {
        return CvsRepository.validateConnection(this.cvsRoot);
    }
}

