/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsCommand;
import bluej.groupwork.cvsnb.CvsRepository;
import bluej.groupwork.cvsnb.StatusServerResponse;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class CvsStatusCommand
extends CvsCommand {
    private StatusListener listener;
    private Set files;
    private boolean includeRemote;

    public CvsStatusCommand(CvsRepository repository, StatusListener listener, Set files, boolean includeRemote) {
        super(repository);
        this.listener = listener;
        this.files = files;
        this.includeRemote = includeRemote;
    }

    protected BasicServerResponse doCommand() throws CommandAbortedException, CommandException, AuthenticationException {
        Set remoteDirs;
        LinkedList<TeamStatusInfo> returnInfo = new LinkedList<TeamStatusInfo>();
        File projectPath = this.repository.getProjectPath();
        BlueJCvsClient client = this.getClient();
        if (this.includeRemote) {
            remoteDirs = new HashSet();
            List remoteFiles = this.repository.getRemoteFiles(client, remoteDirs);
            this.files.addAll(remoteFiles);
        } else {
            remoteDirs = this.repository.getRemoteDirs(client);
        }
        client = null;
        Iterator i = this.files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            File parent = file.getParentFile();
            if (remoteDirs.contains(parent) || this.repository.isDirectoryUnderCVS(parent)) continue;
            i.remove();
            TeamStatusInfo teamInfo = new TeamStatusInfo(file, "", null, 6);
            returnInfo.add(teamInfo);
        }
        StatusServerResponse statusServerResponse = this.repository.getStatus(this.getClient(), this.files, remoteDirs);
        List statusInfo = statusServerResponse.getStatusInformation();
        Iterator i2 = statusInfo.iterator();
        while (i2.hasNext()) {
            String reposRev;
            File file;
            String reposName;
            StatusInformation sinfo = (StatusInformation)i2.next();
            boolean deletedInRepos = false;
            FileStatus fstatus = sinfo.getStatus();
            String workingRev = sinfo.getWorkingRevision();
            if (workingRev == null || workingRev.startsWith("No entry")) {
                workingRev = "";
            }
            if ((reposName = sinfo.getRepositoryFileName()) != null) {
                String fname;
                File parentDir;
                String reposRoot;
                if (reposName.endsWith(",v")) {
                    reposName = reposName.substring(0, reposName.length() - 2);
                }
                if (!(reposRoot = this.repository.getRepositoryRoot()).endsWith("/")) {
                    reposRoot = reposRoot + "/";
                }
                if ((parentDir = (file = new File(projectPath, fname = reposName.substring((reposRoot = reposRoot + projectPath.getName() + "/").length()))).getParentFile()).getName().equals("Attic")) {
                    file = new File(parentDir.getParentFile(), file.getName());
                    deletedInRepos = true;
                }
            } else {
                file = sinfo.getFile();
            }
            int status = fstatus == FileStatus.NEEDS_CHECKOUT ? (workingRev.length() > 0 ? (workingRev.equals(reposRev = sinfo.getRepositoryRevision()) ? 2 : 14) : 1) : (fstatus == FileStatus.NEEDS_PATCH ? 3 : (fstatus == FileStatus.NEEDS_MERGE ? 5 : (fstatus == FileStatus.MODIFIED || fstatus == FileStatus.ADDED ? 4 : (fstatus == FileStatus.UNKNOWN ? 6 : (fstatus == FileStatus.UP_TO_DATE ? 0 : (fstatus == FileStatus.INVALID ? 7 : (fstatus == FileStatus.UNRESOLVED_CONFLICT ? (deletedInRepos ? 13 : (workingRev.length() == 0 ? 12 : 8)) : (fstatus == FileStatus.HAS_CONFLICTS ? 9 : (fstatus == FileStatus.REMOVED ? 4 : 10)))))))));
            if (!this.files.remove(file)) continue;
            TeamStatusInfo teamInfo = new TeamStatusInfo(file, workingRev, sinfo.getRepositoryRevision(), status);
            returnInfo.add(teamInfo);
        }
        i2 = this.files.iterator();
        while (i2.hasNext()) {
            File file = (File)i2.next();
            TeamStatusInfo teamInfo = new TeamStatusInfo(file, "", null, 6);
            returnInfo.add(teamInfo);
        }
        if (this.listener != null) {
            while (!returnInfo.isEmpty()) {
                TeamStatusInfo teamInfo = (TeamStatusInfo)returnInfo.removeFirst();
                this.listener.gotStatus(teamInfo);
            }
        }
        return statusServerResponse;
    }
}

