/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.LogServerResponse;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJAdminHandler;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsCheckoutCommand;
import bluej.groupwork.cvsnb.CvsCommitAllCommand;
import bluej.groupwork.cvsnb.CvsLogCommand;
import bluej.groupwork.cvsnb.CvsModulesCommand;
import bluej.groupwork.cvsnb.CvsShareProjectCmd;
import bluej.groupwork.cvsnb.CvsStatusCommand;
import bluej.groupwork.cvsnb.CvsUpdateCommand;
import bluej.groupwork.cvsnb.CvsUpdateResult;
import bluej.groupwork.cvsnb.EmptyAdminHandler;
import bluej.groupwork.cvsnb.StatusServerResponse;
import bluej.groupwork.cvsnb.UpdateServerResponse;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.modules.versioning.system.cvss.SSHConnection;

public class CvsRepository
implements Repository {
    private boolean reconnectBetweenCommands = true;
    private CVSRoot cvsroot;
    private GlobalOptions globalOptions;
    private boolean printCommand = true;
    private File projectPath;
    private BlueJAdminHandler adminHandler;

    public CvsRepository(File projectPath, String cvsrootString, BlueJAdminHandler adminHandler) {
        this.projectPath = projectPath;
        this.globalOptions = new GlobalOptions();
        this.setCvsRoot(cvsrootString);
        this.adminHandler = adminHandler;
    }

    static File[] listToFileArray(Collection fileList) {
        File[] files = new File[fileList.size()];
        int j = 0;
        Iterator i = fileList.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            files[j++] = file;
        }
        return files;
    }

    public File getProjectPath() {
        return this.projectPath;
    }

    private void setCvsRoot(String cvsrootString) {
        this.cvsroot = CVSRoot.parse((String)cvsrootString);
        this.globalOptions.setCVSRoot(this.cvsroot.toString());
    }

    BlueJCvsClient getClient() {
        BlueJCvsClient client = new BlueJCvsClient(null, (AdminHandler)this.adminHandler);
        client.dontUseGzipFileHandler();
        return client;
    }

    void setupConnection(Client client) throws CommandAbortedException, AuthenticationException {
        Connection connection = CvsRepository.getConnection(this.cvsroot);
        if (connection != null) {
            connection.open();
            client.setConnection(connection);
        } else {
            Debug.message("Repository.setupConnection: connection is null");
        }
    }

    private void disconnect(Client client) {
        if (this.reconnectBetweenCommands) {
            try {
                client.getConnection().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public TeamworkCommand checkout(File projectPath) {
        return new CvsCheckoutCommand(this, projectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BasicServerResponse doCheckout(Client client, File projectPath) throws AuthenticationException, CommandAbortedException, CommandException {
        CheckoutCommand checkoutCommand = new CheckoutCommand(true, projectPath.getName());
        checkoutCommand.setRecursive(true);
        checkoutCommand.setPruneDirectories(false);
        BasicServerResponse basicServerResponse = new BasicServerResponse();
        client.getEventManager().addCVSListener((CVSListener)basicServerResponse);
        client.setLocalPath(projectPath.getParent());
        this.printCommand((Command)checkoutCommand, client);
        try {
            client.executeCommand((Command)checkoutCommand, this.globalOptions);
            basicServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)basicServerResponse);
            this.disconnect(client);
        }
        return basicServerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicServerResponse addToRepository(Client client, File[] files, boolean binary) throws CommandException, CommandAbortedException, AuthenticationException {
        BasicServerResponse basicServerResponse = new BasicServerResponse();
        if (files.length < 1) {
            basicServerResponse.commandTerminated(null);
            return basicServerResponse;
        }
        AddCommand addCommand = new AddCommand();
        addCommand.setFiles(files);
        KeywordSubstitutionOptions kso = binary ? KeywordSubstitutionOptions.BINARY : KeywordSubstitutionOptions.DEFAULT;
        addCommand.setKeywordSubst(kso);
        client.getEventManager().addCVSListener((CVSListener)basicServerResponse);
        client.setLocalPath(this.projectPath.toString());
        this.printCommand((Command)addCommand, client);
        try {
            client.executeCommand((Command)addCommand, this.globalOptions);
            basicServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)basicServerResponse);
            this.disconnect(client);
        }
        return basicServerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicServerResponse commitToRepository(Client client, Collection files, String comment) throws CommandException, CommandAbortedException, AuthenticationException {
        BasicServerResponse basicServerResponse = new BasicServerResponse();
        if (files.size() < 1) {
            basicServerResponse.commandTerminated(null);
            return basicServerResponse;
        }
        CommitCommand commitCommand = new CommitCommand();
        commitCommand.setMessage(comment);
        commitCommand.setFiles(CvsRepository.listToFileArray(files));
        client.getEventManager().addCVSListener((CVSListener)basicServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)commitCommand, client);
        try {
            client.executeCommand((Command)commitCommand, this.globalOptions);
            basicServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)basicServerResponse);
            this.disconnect(client);
        }
        return basicServerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicServerResponse importInRepository(Client client) throws CommandException, CommandAbortedException, AuthenticationException {
        ImportCommand importCommand = new ImportCommand();
        importCommand.setModule(this.projectPath.getName());
        importCommand.setReleaseTag("init");
        importCommand.setLogMessage("logMessage");
        importCommand.setVendorTag("vendor");
        importCommand.addIgnoredFile("*");
        BasicServerResponse basicServerResponse = new BasicServerResponse();
        client.getEventManager().addCVSListener((CVSListener)basicServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)importCommand, client);
        try {
            client.executeCommand((Command)importCommand, this.globalOptions);
            basicServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)basicServerResponse);
            this.disconnect(client);
        }
        return basicServerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicServerResponse removeFromRepository(Client client, Collection files) throws CommandException, CommandAbortedException, AuthenticationException {
        BasicServerResponse basicServerResponse = new BasicServerResponse();
        if (files.size() < 1) {
            basicServerResponse.commandTerminated(null);
            return basicServerResponse;
        }
        RemoveCommand removeCommand = new RemoveCommand();
        removeCommand.setFiles(CvsRepository.listToFileArray(files));
        client.getEventManager().addCVSListener((CVSListener)basicServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)removeCommand, client);
        try {
            this.adminHandler.setMildManneredMode(true);
            client.executeCommand((Command)removeCommand, this.globalOptions);
            basicServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)basicServerResponse);
            this.disconnect(client);
            this.adminHandler.setMildManneredMode(false);
        }
        return basicServerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateServerResponse getUpdateServerResponse(Client client, String path) throws CommandException, CommandAbortedException, AuthenticationException {
        UpdateCommand updateCommand = new UpdateCommand();
        UpdateServerResponse updateServerResponse = new UpdateServerResponse(null, null);
        GlobalOptions globalOptions = new GlobalOptions();
        updateCommand.setRecursive(true);
        updateCommand.setBuildDirectories(true);
        updateCommand.setPruneDirectories(true);
        updateCommand.setCleanCopy(false);
        globalOptions.setCVSRoot(this.cvsroot.toString());
        globalOptions.setDoNoChanges(true);
        globalOptions.setModeratelyQuiet(true);
        client.setLocalPath(path);
        client.getEventManager().addCVSListener((CVSListener)updateServerResponse);
        this.printCommand((Command)updateCommand, client);
        try {
            client.executeCommand((Command)updateCommand, globalOptions);
            updateServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)updateServerResponse);
            this.disconnect(client);
        }
        return updateServerResponse;
    }

    private void printCommand(Command command, Client client) {
        if (this.printCommand) {
            System.out.println("cvsCommand: " + command.getCVSCommand() + " localpath: " + client.getLocalPath());
        }
    }

    boolean isDirectoryUnderCVS(File dir) {
        String apath = this.adminHandler.getMetaDataPath(dir.getAbsolutePath());
        dir = new File(apath);
        return new File(dir, "CVS").isDirectory();
    }

    public TeamworkCommand commitAll(Set newFiles, Set binaryNewFiles, Set deletedFiles, Set files, String commitComment) {
        return new CvsCommitAllCommand(this, newFiles, binaryNewFiles, deletedFiles, files, commitComment);
    }

    public TeamworkCommand updateFiles(UpdateListener listener, Set theFiles, Set forceFiles) {
        return new CvsUpdateCommand(this, listener, theFiles, forceFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UpdateServerResponse doUpdateAll(BlueJCvsClient client, UpdateListener listener) throws CommandAbortedException, CommandException, AuthenticationException {
        UpdateCommand command = new UpdateCommand();
        command.setCleanCopy(false);
        command.setRecursive(true);
        command.setBuildDirectories(true);
        command.setPruneDirectories(true);
        UpdateServerResponse updateServerResponse = new UpdateServerResponse(listener, client);
        client.getEventManager().addCVSListener((CVSListener)updateServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)command, client);
        try {
            client.executeCommand((Command)command, this.globalOptions);
            updateServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)updateServerResponse);
            this.disconnect(client);
        }
        updateServerResponse.setConflictMap(client.getConflictFiles());
        return updateServerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UpdateServerResponse doUpdateFiles(BlueJCvsClient client, UpdateListener listener, Set theFiles, boolean force) throws CommandAbortedException, CommandException, AuthenticationException {
        UpdateCommand command = new UpdateCommand();
        command.setFiles(CvsRepository.listToFileArray(theFiles));
        command.setCleanCopy(force);
        command.setRecursive(false);
        command.setBuildDirectories(true);
        command.setPruneDirectories(true);
        UpdateServerResponse updateServerResponse = new UpdateServerResponse(listener, client);
        client.getEventManager().addCVSListener((CVSListener)updateServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)command, client);
        try {
            client.executeCommand((Command)command, this.globalOptions);
            updateServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)updateServerResponse);
            this.disconnect(client);
        }
        updateServerResponse.setConflictMap(client.getConflictFiles());
        return updateServerResponse;
    }

    public TeamworkCommand shareProject() {
        return new CvsShareProjectCmd(this);
    }

    public static boolean validateConnection(String cvsrootStr) {
        boolean status = false;
        Connection connection = null;
        try {
            CVSRoot cvsroot = CVSRoot.parse((String)cvsrootStr);
            connection = CvsRepository.getConnection(cvsroot);
            if (connection != null) {
                connection.verify();
                status = true;
            }
        }
        catch (AuthenticationException e) {
            status = false;
        }
        catch (IllegalArgumentException iae) {
            status = false;
        }
        return status;
    }

    private static Connection getConnection(CVSRoot cvsRoot) {
        SocketFactory socketFactory = SocketFactory.getDefault();
        if ("ext".equals(cvsRoot.getMethod())) {
            int port = 22;
            if (cvsRoot.getPort() != 0) {
                port = cvsRoot.getPort();
            }
            SSHConnection sshConnection = new SSHConnection(socketFactory, cvsRoot.getHostName(), port, cvsRoot.getUserName(), cvsRoot.getPassword());
            sshConnection.setRepository(cvsRoot.getRepository());
            return sshConnection;
        }
        if ("pserver".equals(cvsRoot.getMethod())) {
            PServerConnection pConnection = new PServerConnection(cvsRoot, socketFactory);
            return pConnection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getRemoteFiles(Client client, Set remoteDirs) throws AuthenticationException, CommandException {
        LinkedList files = new LinkedList();
        this.adminHandler.setMildManneredMode(true);
        try {
            this.getRemoteFiles(client, files, this.projectPath, remoteDirs, false);
        }
        finally {
            this.adminHandler.setMildManneredMode(false);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set getRemoteDirs(Client client) throws AuthenticationException, CommandException {
        this.adminHandler.setMildManneredMode(true);
        HashSet remoteDirs = new HashSet();
        try {
            this.getRemoteFiles(client, null, this.projectPath, remoteDirs, true);
        }
        finally {
            this.adminHandler.setMildManneredMode(false);
        }
        return remoteDirs;
    }

    private void getRemoteFiles(Client client, List files, File path, Set remoteDirs, boolean localDirs) throws AuthenticationException, CommandAbortedException, CommandException {
        UpdateServerResponse updateResponse = this.getUpdateServerResponse(client, path.getAbsolutePath());
        List updated = updateResponse.getUpdated();
        Iterator i = updated.iterator();
        while (i.hasNext()) {
            CvsUpdateResult ur = (CvsUpdateResult)i.next();
            File f = new File(path, ur.getFilename());
            remoteDirs.add(f.getParentFile());
            if (files == null || f.exists()) continue;
            files.add(f);
        }
        List newDirs = updateResponse.getNewDirectoryNames();
        i = newDirs.iterator();
        while (i.hasNext()) {
            String newDirName = i.next().toString();
            File localPath = new File(path, newDirName);
            if (localDirs && !localPath.isDirectory()) continue;
            remoteDirs.add(localPath);
            this.getRemoteFiles(client, files, localPath, remoteDirs, localDirs);
        }
    }

    public TeamworkCommand getStatus(StatusListener listener, Set files, boolean includeRemote) {
        return new CvsStatusCommand(this, listener, files, includeRemote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusServerResponse getStatus(Client client, Set files, Set remoteDirs) throws CommandAbortedException, CommandException, AuthenticationException {
        StatusCommand statusCommand = new StatusCommand();
        statusCommand.setFiles(CvsRepository.listToFileArray(files));
        StatusServerResponse statusServerResponse = new StatusServerResponse();
        client.getEventManager().addCVSListener((CVSListener)statusServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)statusCommand, client);
        this.adminHandler.setMildManneredMode(true);
        try {
            client.executeCommand((Command)statusCommand, this.globalOptions);
            statusServerResponse.waitForExecutionToFinish();
        }
        finally {
            this.adminHandler.setMildManneredMode(false);
            client.getEventManager().removeCVSListener((CVSListener)statusServerResponse);
            this.disconnect(client);
        }
        return statusServerResponse;
    }

    public TeamworkCommand getModules(List modules) {
        return new CvsModulesCommand(this, modules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UpdateServerResponse doGetModules(Client client, List modules) throws AuthenticationException, CommandAbortedException, CommandException {
        client.setAdminHandler((AdminHandler)new EmptyAdminHandler());
        CheckoutCommand checkoutCommand = new CheckoutCommand(true, ".");
        checkoutCommand.setRecursive(true);
        checkoutCommand.setPruneDirectories(false);
        this.globalOptions.setDoNoChanges(true);
        UpdateServerResponse updateServerResponse = new UpdateServerResponse(null, null);
        client.getEventManager().addCVSListener((CVSListener)updateServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)checkoutCommand, client);
        try {
            client.executeCommand((Command)checkoutCommand, this.globalOptions);
            updateServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)updateServerResponse);
            this.disconnect(client);
            client.setAdminHandler((AdminHandler)this.adminHandler);
            this.globalOptions.setDoNoChanges(false);
        }
        List projects = updateServerResponse.getNewDirectoryNames();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            String projectName = i.next().toString();
            if (projectName.equals("CVSROOT")) continue;
            modules.add(projectName);
        }
        return updateServerResponse;
    }

    public void getLocallyDeletedFiles(Set set, File dir) throws IOException {
        Iterator i = this.adminHandler.getEntries(dir);
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            File file = new File(dir, entry.getName());
            if (file.exists() || entry.isDirectory()) continue;
            set.add(new File(dir, entry.getName()));
        }
    }

    public TeamworkCommand getLogHistory(LogHistoryListener listener) {
        return new CvsLogCommand(this, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LogServerResponse doGetLogHistory(Client client) throws AuthenticationException, CommandAbortedException, CommandException {
        LogCommand logCommand = new LogCommand();
        LogServerResponse logServerResponse = new LogServerResponse();
        client.getEventManager().addCVSListener((CVSListener)logServerResponse);
        client.setLocalPath(this.projectPath.getAbsolutePath());
        this.printCommand((Command)logCommand, client);
        try {
            client.executeCommand((Command)logCommand, this.globalOptions);
            logServerResponse.waitForExecutionToFinish();
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)logServerResponse);
            this.disconnect(client);
        }
        return logServerResponse;
    }

    String getRepositoryRoot() {
        return this.cvsroot.getRepository();
    }
}

