/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.LogInformation;
import bluej.groupwork.LogServerResponse;
import bluej.groupwork.Revision;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsCommand;
import bluej.groupwork.cvsnb.CvsRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class CvsLogCommand
extends CvsCommand {
    private LogHistoryListener listener;

    public CvsLogCommand(CvsRepository repository, LogHistoryListener listener) {
        super(repository);
        this.listener = listener;
    }

    protected BasicServerResponse doCommand() throws CommandAbortedException, CommandException, AuthenticationException {
        BlueJCvsClient client = this.getClient();
        LogServerResponse response = this.repository.doGetLogHistory(client);
        if (!response.isError()) {
            List infoList = response.getInfoList();
            Iterator i = infoList.iterator();
            while (i.hasNext()) {
                org.netbeans.lib.cvsclient.command.log.LogInformation cvsInfo = (org.netbeans.lib.cvsclient.command.log.LogInformation)i.next();
                List cvsRevisionList = cvsInfo.getRevisionList();
                ArrayList<Revision> revisionList = new ArrayList<Revision>(cvsRevisionList.size());
                Iterator j = cvsRevisionList.iterator();
                while (j.hasNext()) {
                    LogInformation.Revision cvsRev = (LogInformation.Revision)j.next();
                    Revision rev = new Revision(cvsRev.getAuthor(), cvsRev.getNumber(), cvsRev.getDateString(), cvsRev.getMessage());
                    revisionList.add(rev);
                }
                LogInformation info = new LogInformation(cvsInfo.getFile(), revisionList);
                this.listener.logInfoAvailable(info);
            }
        }
        return response;
    }
}

