/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.utility.Debug;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.GlobalOptions;

public class BlueJAdminHandler
extends StandardAdminHandler {
    File projectDir;
    private boolean mode = false;

    public BlueJAdminHandler(File projectDir) {
        this.projectDir = projectDir;
    }

    public void setMildManneredMode(boolean mode) {
        this.mode = mode;
    }

    public void prepareDeleteDir(File dir) {
        File cvsDir = new File(dir, "CVS");
        if (cvsDir.isDirectory()) {
            String relPath = this.getRelativePath(dir.getAbsolutePath());
            File newMetaDir = new File(this.projectDir, "CVS");
            newMetaDir = new File(newMetaDir, "deleted");
            newMetaDir = new File(newMetaDir, relPath);
            newMetaDir.mkdirs();
            if (!cvsDir.renameTo(new File(newMetaDir, "CVS"))) {
                Debug.message("Rename of meta-data directory failed: " + cvsDir);
            }
        }
    }

    public void prepareCreateDir(File dir) {
        String relPath = this.getRelativePath(dir.getAbsolutePath());
        File newMetaDir = new File(this.projectDir, "CVS");
        newMetaDir = new File(newMetaDir, "deleted");
        if ((newMetaDir = new File(newMetaDir, relPath)).exists()) {
            File cvsDir = new File(newMetaDir, "CVS");
            if (!cvsDir.renameTo(new File(dir, "CVS"))) {
                Debug.message("Rename of meta-data directory failed: " + cvsDir);
            }
            while (newMetaDir.delete()) {
                newMetaDir = newMetaDir.getParentFile();
            }
        }
    }

    private String getRelativePath(String directory) {
        String projDirString = this.projectDir.toString();
        if (!directory.startsWith(projDirString)) {
            return null;
        }
        if ((directory = directory.substring(projDirString.length())).startsWith(File.pathSeparator)) {
            directory = directory.substring(1);
        }
        return directory;
    }

    public String getMetaDataPath(String directory) {
        String relativeDir = this.getRelativePath(directory);
        if (relativeDir == null) {
            return directory;
        }
        File deletedFile = new File(this.projectDir, "CVS");
        deletedFile = new File(deletedFile, "deleted");
        File deletedFileMd = new File(deletedFile = new File(deletedFile, relativeDir), "CVS");
        if (deletedFileMd.exists()) {
            return deletedFile.getPath();
        }
        return directory;
    }

    private String getMetaDataPathForFile(String absFilePath) {
        String relativeDir = this.getRelativePath(absFilePath);
        if (relativeDir == null) {
            return absFilePath;
        }
        File deletedFile = new File(this.projectDir, "CVS");
        deletedFile = new File(deletedFile, "deleted");
        File deletedFileMd = new File((deletedFile = new File(deletedFile, relativeDir)).getParentFile(), "CVS");
        if (deletedFileMd.exists()) {
            return deletedFile.getPath();
        }
        return absFilePath;
    }

    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry, GlobalOptions globalOptions) throws IOException {
        localDirectory = this.getMetaDataPath(localDirectory);
        super.updateAdminData(localDirectory, repositoryPath, entry, globalOptions);
    }

    public boolean exists(File file) {
        File nFile = new File(this.getMetaDataPath(file.getAbsolutePath()));
        boolean result = super.exists(nFile);
        if (!result) {
            result = super.exists(file);
        }
        return result;
    }

    public Entry getEntry(File file) throws IOException {
        file = new File(this.getMetaDataPathForFile(file.getAbsolutePath()));
        try {
            return super.getEntry(file);
        }
        catch (IOException ioe) {
            if (this.mode) {
                return null;
            }
            throw ioe;
        }
    }

    public Entry[] getEntriesAsArray(File directory) throws IOException {
        directory = new File(this.getMetaDataPath(directory.getAbsolutePath()));
        return super.getEntriesAsArray(directory);
    }

    public Iterator getEntries(File directory) throws IOException {
        directory = new File(this.getMetaDataPath(directory.getAbsolutePath()));
        try {
            return super.getEntries(directory);
        }
        catch (IOException ioe) {
            if (this.mode) {
                return Collections.EMPTY_LIST.iterator();
            }
            throw ioe;
        }
    }

    public void setEntry(File file, Entry entry) throws IOException {
        file = new File(this.getMetaDataPathForFile(file.getAbsolutePath()));
        super.setEntry(file, entry);
    }

    public void removeEntry(File file) throws IOException {
        file = new File(this.getMetaDataPathForFile(file.getAbsolutePath()));
        super.removeEntry(file);
        if (!super.getEntries(file.getParentFile()).hasNext()) {
            File pDir = file.getParentFile();
            File cvsDir = new File(pDir, "CVS");
            FileUtility.deleteDir(cvsDir);
            while (pDir.delete()) {
                pDir = pDir.getParentFile();
            }
        }
    }

    public String getRepositoryForDirectory(String directory, String repository) throws IOException {
        directory = this.getMetaDataPath(directory);
        try {
            return super.getRepositoryForDirectory(directory, repository);
        }
        catch (IOException ioe) {
            if (this.mode) {
                File f = new File(directory);
                String parentFile = f.getParent();
                if (parentFile == null) {
                    throw ioe;
                }
                String parentRepository = this.getRepositoryForDirectory(f.getParent(), repository);
                return parentRepository + "/" + f.getName();
            }
            throw ioe;
        }
    }

    public Set getAllFiles(File directory) throws IOException {
        directory = new File(this.getMetaDataPath(directory.getAbsolutePath()));
        if (this.mode && !directory.exists()) {
            return Collections.EMPTY_SET;
        }
        Set s = super.getAllFiles(directory);
        TreeSet<File> newSet = new TreeSet<File>();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            f = new File(directory, f.getName());
            newSet.add(f);
        }
        return newSet;
    }

    public String getStickyTagForDirectory(File directory) {
        directory = new File(this.getMetaDataPath(directory.getAbsolutePath()));
        return super.getStickyTagForDirectory(directory);
    }
}

