/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResult;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.ui.ConflictsDialog;
import bluej.groupwork.ui.UpdateFilesFrame;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.SwingWorker;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class UpdateAction
extends AbstractAction {
    private Project project;
    private boolean includeLayout = true;
    private UpdateFilesFrame updateFrame;
    private UpdateWorker worker;
    private Set filesToUpdate;
    private Set filesToForceUpdate;
    private List removedPackages;

    public UpdateAction(UpdateFilesFrame updateFrame) {
        super(Config.getString("team.update"));
        this.putValue("ShortDescription", Config.getString("tooltip.update"));
        this.updateFrame = updateFrame;
    }

    public void setFilesToUpdate(Set files) {
        this.filesToUpdate = files;
    }

    public void setFilesToForceUpdate(Set files) {
        this.filesToForceUpdate = files;
    }

    public void actionPerformed(ActionEvent event) {
        this.project = this.updateFrame.getProject();
        if (this.project != null) {
            this.project.saveAllEditors();
            this.updateFrame.startProgress();
            PkgMgrFrame.displayMessage(this.project, Config.getString("team.update.statusMessage"));
            this.worker = new UpdateWorker(this.project, this.filesToUpdate, this.filesToForceUpdate);
            this.worker.start();
        }
    }

    public void cancel() {
        if (this.worker != null) {
            this.worker.abort();
        }
        this.setEnabled(true);
    }

    private String filenameToTargetIdentifier(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return filename.substring(0, lastDot);
    }

    private class UpdateWorker
    extends SwingWorker
    implements UpdateListener {
        private Repository repository;
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private boolean aborted;

        public UpdateWorker(Project project, Set filesToUpdate, Set filesToForceUpdate) {
            this.repository = project.getRepository();
            if (this.repository != null) {
                this.command = this.repository.updateFiles(this, filesToUpdate, filesToForceUpdate);
            }
        }

        public Object construct() {
            UpdateAction.this.removedPackages = new ArrayList();
            this.result = this.command.getResult();
            return this.result;
        }

        public void fileAdded(final File f) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UpdateAction.this.project.prepareCreateDir(f.getParentFile());
                    String fileName = f.getName();
                    if (!(fileName.endsWith(".java") || fileName.endsWith(".class") || fileName.equals("bluej.pkg"))) {
                        return;
                    }
                    String packageName = UpdateAction.this.project.getPackageForFile(f);
                    if (packageName == null) {
                        return;
                    }
                    if (fileName.equals("bluej.pkg")) {
                        if (packageName.length() > 0) {
                            String parentPackageName = JavaNames.getPrefix(packageName);
                            Package parentPackage = UpdateAction.this.project.getCachedPackage(parentPackageName);
                            if (parentPackage != null) {
                                PackageTarget t = parentPackage.addPackage(JavaNames.getBase(packageName));
                                parentPackage.positionNewTarget(t);
                            }
                        }
                    } else {
                        int n = fileName.lastIndexOf(".");
                        String name = fileName.substring(0, n);
                        if (!JavaNames.isIdentifier(name)) {
                            return;
                        }
                        Package pkg = UpdateAction.this.project.getCachedPackage(packageName);
                        if (pkg == null) {
                            return;
                        }
                        Target t = pkg.getTarget(name);
                        if (t != null && !(t instanceof ClassTarget)) {
                            return;
                        }
                        ClassTarget ct = (ClassTarget)t;
                        if (ct == null) {
                            ct = pkg.addClass(name);
                            pkg.positionNewTarget(ct);
                        }
                        ct.reload();
                    }
                }
            });
        }

        public void fileRemoved(final File f) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String fileName = f.getName();
                    if (!(fileName.endsWith(".java") || fileName.endsWith(".class") || fileName.equals("bluej.pkg"))) {
                        return;
                    }
                    String packageName = UpdateAction.this.project.getPackageForFile(f);
                    if (packageName == null) {
                        return;
                    }
                    if (fileName.equals("bluej.pkg")) {
                        UpdateAction.this.removedPackages.add(packageName);
                    } else {
                        int n = fileName.lastIndexOf(".");
                        String name = fileName.substring(0, n);
                        Package pkg = UpdateAction.this.project.getCachedPackage(packageName);
                        if (pkg == null) {
                            return;
                        }
                        Target t = pkg.getTarget(name);
                        if (!(t instanceof ClassTarget)) {
                            return;
                        }
                        ClassTarget ct = (ClassTarget)t;
                        if (ct.hasSourceCode() && !fileName.endsWith(".java")) {
                            ct.setInvalidState();
                        } else {
                            ct.remove();
                        }
                    }
                }
            });
        }

        public void fileUpdated(final File f) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String fileName = f.getName();
                    if (!(fileName.endsWith(".java") || fileName.endsWith(".class") || fileName.equals("bluej.pkg"))) {
                        return;
                    }
                    String packageName = UpdateAction.this.project.getPackageForFile(f);
                    if (packageName == null) {
                        return;
                    }
                    Package pkg = UpdateAction.this.project.getCachedPackage(packageName);
                    if (pkg == null) {
                        return;
                    }
                    if (fileName.equals("bluej.pkg")) {
                        try {
                            if (UpdateAction.this.includeLayout) {
                                pkg.reReadGraphLayout();
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    } else {
                        int n = fileName.lastIndexOf(".");
                        String name = fileName.substring(0, n);
                        if (pkg == null) {
                            return;
                        }
                        Target t = pkg.getTarget(name);
                        if (!(t instanceof ClassTarget)) {
                            return;
                        }
                        ClassTarget ct = (ClassTarget)t;
                        ct.reload();
                    }
                }
            });
        }

        public void handleConflicts(final UpdateResults updateServerResponse) {
            if (updateServerResponse == null) {
                return;
            }
            if (updateServerResponse.getConflicts().size() <= 0) {
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        HashSet<File> filesToOverride = new HashSet<File>();
                        Iterator i = updateServerResponse.getBinaryConflicts().iterator();
                        while (i.hasNext()) {
                            File f = (File)i.next();
                            if (f.getName().equals("bluej.pkg")) {
                                filesToOverride.add(f);
                                continue;
                            }
                            int answer = DialogManager.askQuestion(PkgMgrFrame.getMostRecent(), "team-binary-conflict", new String[]{f.getName()});
                            if (answer == 0) continue;
                            filesToOverride.add(f);
                        }
                        updateServerResponse.overrideFiles(filesToOverride);
                        LinkedList<String> blueJconflicts = new LinkedList<String>();
                        LinkedList<String> nonBlueJConflicts = new LinkedList<String>();
                        LinkedList<Target> targets = new LinkedList<Target>();
                        Iterator i2 = updateServerResponse.getConflicts().iterator();
                        while (i2.hasNext()) {
                            String targetId;
                            String pkg;
                            File file;
                            UpdateResult updateResult = (UpdateResult)i2.next();
                            String fileName = updateResult.getFilename();
                            int n = fileName.lastIndexOf(47);
                            String baseName = n != -1 ? fileName.substring(n + 1) : fileName;
                            if (baseName.equals("bluej.pkg")) continue;
                            Target target = null;
                            if (baseName.endsWith(".java") || baseName.endsWith(".class")) {
                                file = new File(UpdateAction.this.project.getProjectDir(), fileName);
                                pkg = UpdateAction.this.project.getPackageForFile(file);
                                if (pkg != null) {
                                    targetId = UpdateAction.this.filenameToTargetIdentifier(baseName);
                                    targetId = JavaNames.combineNames(pkg, targetId);
                                    target = UpdateAction.this.project.getTarget(targetId);
                                }
                            } else if (baseName.equals("README.TXT")) {
                                file = new File(UpdateAction.this.project.getProjectDir(), fileName);
                                pkg = UpdateAction.this.project.getPackageForFile(file);
                                if (pkg != null) {
                                    targetId = "@README";
                                    targetId = JavaNames.combineNames(pkg, targetId);
                                    target = UpdateAction.this.project.getTarget(targetId);
                                }
                            }
                            if (target == null) {
                                nonBlueJConflicts.add(fileName);
                                continue;
                            }
                            blueJconflicts.add(fileName);
                            targets.add(target);
                        }
                        if (!blueJconflicts.isEmpty() || !nonBlueJConflicts.isEmpty()) {
                            UpdateAction.this.project.clearAllSelections();
                            UpdateAction.this.project.selectTargetsInGraphs(targets);
                            ConflictsDialog conflictsDialog = new ConflictsDialog(UpdateAction.this.project, blueJconflicts, nonBlueJConflicts);
                            conflictsDialog.setVisible(true);
                        }
                    }
                });
            }
            catch (InvocationTargetException ite) {
                throw new Error(ite);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        public void finished() {
            this.handleRemovedPkgs();
            UpdateAction.this.updateFrame.stopProgress();
            if (!this.result.isError() && !this.aborted) {
                PkgMgrFrame.displayMessage(UpdateAction.this.project, Config.getString("team.update.statusDone"));
            } else {
                PkgMgrFrame.displayMessage(UpdateAction.this.project, "");
                TeamUtils.handleServerResponse(this.result, UpdateAction.this.updateFrame);
            }
            if (!this.aborted) {
                UpdateAction.this.updateFrame.setVisible(false);
                UpdateAction.this.updateFrame.dispose();
                UpdateAction.this.setEnabled(true);
            }
        }

        private void handleRemovedPkgs() {
            Iterator i = UpdateAction.this.removedPackages.iterator();
            while (i.hasNext()) {
                String packageName = i.next().toString();
                String parentPackage = JavaNames.getPrefix(packageName);
                String baseName = JavaNames.getBase(packageName);
                File packageDir = JavaNames.convertQualifiedNameToFile(packageName);
                if (packageDir.exists()) continue;
                Package pkg = UpdateAction.this.project.getPackage(parentPackage);
                if (pkg == null) {
                    return;
                }
                Target target = pkg.getTarget(baseName);
                if (!(target instanceof PackageTarget)) continue;
                pkg.removeTarget(target);
            }
        }
    }
}

