/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.CommitCommentsFrame;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.SwingWorker;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;

public class CommitAction
extends AbstractAction {
    private Set newFiles;
    private Set deletedFiles;
    private Set files;
    private CommitCommentsFrame commitCommentsFrame;
    private CommitWorker worker;

    public CommitAction(CommitCommentsFrame frame) {
        super(Config.getString("team.commit"));
        this.commitCommentsFrame = frame;
    }

    public void setNewFiles(Set newFiles) {
        this.newFiles = newFiles;
    }

    public void setDeletedFiles(Set deletedFiles) {
        this.deletedFiles = deletedFiles;
    }

    public void setFiles(Set files) {
        this.files = files;
    }

    public Set getFiles() {
        return this.files;
    }

    public void actionPerformed(ActionEvent event) {
        Project project = this.commitCommentsFrame.getProject();
        if (project != null) {
            this.commitCommentsFrame.startProgress();
            PkgMgrFrame.displayMessage(project, Config.getString("team.commit.statusMessage"));
            project.saveAllEditors();
            this.setEnabled(false);
            this.worker = new CommitWorker(project);
            this.worker.start();
        }
    }

    public void cancel() {
        this.setEnabled(true);
        if (this.worker != null) {
            this.worker.abort();
            this.worker = null;
        }
    }

    private class CommitWorker
    extends SwingWorker {
        private Repository repository;
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private boolean aborted;

        public CommitWorker(Project project) {
            this.repository = project.getRepository();
            String comment = CommitAction.this.commitCommentsFrame.getComment();
            if (CommitAction.this.commitCommentsFrame.includeLayout()) {
                CommitAction.this.files.addAll(CommitAction.this.commitCommentsFrame.getChangedLayoutFiles());
            }
            Set binFiles = TeamUtils.extractBinaryFilesFromSet(CommitAction.this.newFiles);
            this.command = project.getRepository().commitAll(CommitAction.this.newFiles, binFiles, CommitAction.this.deletedFiles, CommitAction.this.files, comment);
        }

        public Object construct() {
            this.result = this.command.getResult();
            return this.result;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        public void finished() {
            final Project project = CommitAction.this.commitCommentsFrame.getProject();
            if (!this.aborted) {
                CommitAction.this.commitCommentsFrame.stopProgress();
                if (!this.result.isError() && !this.result.wasAborted()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            PkgMgrFrame.displayMessage(project, Config.getString("team.commit.statusDone"));
                        }
                    });
                }
            }
            TeamUtils.handleServerResponse(this.result, CommitAction.this.commitCommentsFrame);
            if (!this.aborted) {
                CommitAction.this.setEnabled(true);
                CommitAction.this.commitCommentsFrame.setVisible(false);
            }
        }
    }
}

