/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.cvsnb.CvsServerMessageTranslator;
import bluej.utility.DialogManager;
import java.awt.Window;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TeamUtils {
    public static void handleServerResponse(TeamworkCommandResult result, Window window) {
        if (result != null) {
            if (result.wasAuthFailure()) {
                DialogManager.showError(window, "team-authentication-problem");
            } else if (result.isError() && !result.wasAborted()) {
                String message = result.getErrorMessage();
                String translatedMessage = CvsServerMessageTranslator.translate(message);
                if (translatedMessage != null) {
                    DialogManager.showError(window, translatedMessage);
                } else {
                    DialogManager.showErrorText(window, message);
                }
            }
        }
    }

    public static Set extractBinaryFilesFromSet(Set files) {
        HashSet<File> binFiles = new HashSet<File>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            String fname = f.getName();
            if (fname.endsWith(".txt") || fname.endsWith(".java")) continue;
            binFiles.add(f);
            i.remove();
        }
        return binFiles;
    }
}

