/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import bluej.groupwork.CodeFileFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.cvsnb.BlueJAdminHandler;
import bluej.groupwork.cvsnb.CvsRepository;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.filefilter.DirectoryFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TeamSettingsController {
    private Project project;
    private File projectDir;
    private Properties teamProperties;
    private TeamSettingsDialog teamSettingsDialog;
    private BlueJAdminHandler adminHandler;
    private String password;
    private File teamdefs;
    private CvsRepository repository;

    public TeamSettingsController(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.teamProperties = new Properties();
        this.readSetupFile();
    }

    public TeamSettingsController(File projectDir) {
        this.projectDir = projectDir;
        this.teamProperties = new Properties();
    }

    public void setProject(Project proj) {
        this.project = proj;
        this.projectDir = proj.getProjectDir();
        this.repository = null;
        this.adminHandler = null;
        this.checkTeamSettingsDialog();
    }

    public Repository getRepository() {
        String cvsroot;
        if (this.repository == null && (cvsroot = this.getCvsRoot()) != null) {
            this.repository = new CvsRepository(this.projectDir, cvsroot, this.getAdminHandler());
        }
        return this.repository;
    }

    public Set getProjectFiles(boolean includeLayout) {
        Set files = this.project.getFilesInProject(includeLayout);
        if (this.repository != null) {
            LinkedList<File> stack = new LinkedList<File>();
            stack.add(this.project.getProjectDir());
            HashSet tempSet = new HashSet();
            FilenameFilter filter = this.getFileFilter(true);
            while (!stack.isEmpty()) {
                File dir = (File)stack.remove(0);
                File[] subDirs = dir.listFiles(new DirectoryFilter());
                for (int i = 0; i < subDirs.length; ++i) {
                    if (subDirs[i].getName().equals("CVS")) continue;
                    stack.add(subDirs[i]);
                }
                try {
                    this.repository.getLocallyDeletedFiles(tempSet, dir);
                    Iterator i = tempSet.iterator();
                    while (i.hasNext()) {
                        File file = (File)i.next();
                        if (!filter.accept(dir, file.getName())) continue;
                        files.add(file);
                    }
                    tempSet.clear();
                }
                catch (IOException ioe) {}
            }
            File delDir = new File(this.project.getProjectDir(), "CVS");
            if ((delDir = new File(delDir, "deleted")).exists()) {
                stack.add(delDir);
            }
            while (!stack.isEmpty()) {
                File dir = (File)stack.remove(0);
                File[] subDirs = dir.listFiles(new DirectoryFilter());
                for (int i = 0; i < subDirs.length; ++i) {
                    if (subDirs[i].getName().equals("CVS")) continue;
                    stack.add(subDirs[i]);
                }
                try {
                    this.repository.getLocallyDeletedFiles(tempSet, dir);
                    Iterator i = tempSet.iterator();
                    while (i.hasNext()) {
                        File file = (File)i.next();
                        if (!filter.accept(dir, file.getName())) continue;
                        String fileStr = file.getPath();
                        fileStr = fileStr.substring(delDir.getPath().length());
                        file = new File(this.project.getProjectDir(), fileStr);
                        files.add(file);
                    }
                    tempSet.clear();
                }
                catch (IOException ioe) {}
            }
        }
        return files;
    }

    public FilenameFilter getFileFilter(boolean includeLayout) {
        return new CodeFileFilter(this.getIgnoreFiles(), includeLayout);
    }

    private void readSetupFile() {
        this.teamdefs = new File(this.projectDir + "/team.defs");
        try {
            this.teamProperties.load(new FileInputStream(this.teamdefs));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BlueJAdminHandler getAdminHandler() {
        if (this.adminHandler == null) {
            this.adminHandler = new BlueJAdminHandler(this.projectDir);
        }
        return this.adminHandler;
    }

    public void prepareDeleteDir(File dir) {
        BlueJAdminHandler adminHandler = this.getAdminHandler();
        adminHandler.prepareDeleteDir(dir);
    }

    public void prepareCreateDir(File dir) {
        BlueJAdminHandler adminHandler = this.getAdminHandler();
        adminHandler.prepareCreateDir(dir);
    }

    public String getCvsRoot() {
        if (this.password == null) {
            this.getTeamSettingsDialog().doTeamSettings();
            if (this.password == null) {
                return null;
            }
        }
        String protocol = this.getPropString("bluej.teamsettings.cvs.protocol");
        String user = this.getPropString("bluej.teamsettings.user");
        String server = this.getPropString("bluej.teamsettings.cvs.server");
        String repositoryPrefix = this.getPropString("bluej.teamsettings.cvs.repositoryPrefix");
        String groupname = this.getPropString("bluej.teamsettings.groupname");
        if (!repositoryPrefix.endsWith("/") && groupname.length() != 0) {
            repositoryPrefix = repositoryPrefix + "/";
        } else if (repositoryPrefix.endsWith("/") && groupname.length() == 0) {
            int nlen = repositoryPrefix.length();
            repositoryPrefix = repositoryPrefix.substring(0, nlen - 1);
        }
        String cvsRoot = ":" + protocol + ":" + user + ":" + this.password + "@" + server + ":" + repositoryPrefix + groupname;
        return cvsRoot;
    }

    public TeamSettingsDialog getTeamSettingsDialog() {
        if (this.teamSettingsDialog == null) {
            this.teamSettingsDialog = new TeamSettingsDialog(this);
            this.teamSettingsDialog.setLocationRelativeTo(PkgMgrFrame.getMostRecent());
            this.checkTeamSettingsDialog();
        }
        return this.teamSettingsDialog;
    }

    private void checkTeamSettingsDialog() {
        if (this.teamSettingsDialog != null && this.project != null) {
            this.teamSettingsDialog.disableRepositorySettings();
        }
    }

    public void writeToProject() {
        if (this.projectDir == null) {
            return;
        }
        File cfgFile = new File(this.projectDir + "/team.defs");
        if (!cfgFile.exists()) {
            this.addIgnoreFilePatterns(this.teamProperties);
        }
        try {
            this.teamProperties.store(new FileOutputStream(cfgFile), null);
            this.repository = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addIgnoreFilePatterns(Properties teamProperties) {
        teamProperties.put("bluej.teamsettings.cvs.ignore1", ".*\\.class");
        teamProperties.put("bluej.teamsettings.cvs.ignore2", "bluej\\.pkh");
        teamProperties.put("bluej.teamsettings.cvs.ignore3", "team\\.defs");
        teamProperties.put("bluej.teamsettings.cvs.ignore4", ".*\\.ctxt");
        teamProperties.put("bluej.teamsettings.cvs.ignore5", ".*\\~");
        teamProperties.put("bluej.teamsettings.cvs.ignore6", ".*\\#");
        teamProperties.put("bluej.teamsettings.cvs.ignore7", ".*\\#backup");
        teamProperties.put("bluej.teamsettings.cvs.ignore8", "\\.DS_Store");
    }

    public String getPropString(String strname) {
        String result = this.teamProperties.getProperty(strname);
        if (result != null) {
            return result;
        }
        result = Config.getPropString(strname, null);
        return result;
    }

    public void setPropString(String key, String value) {
        this.teamProperties.setProperty(key, value);
    }

    public String getPasswordString() {
        return this.password;
    }

    public void setPasswordString(String password) {
        this.password = password;
    }

    public boolean hasPasswordString() {
        return this.password != null;
    }

    public List getIgnoreFiles() {
        Enumeration<Object> keys = this.teamProperties.keys();
        LinkedList<String> patterns = new LinkedList<String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("bluej.teamsettings.cvs.ignore")) continue;
            patterns.add(this.teamProperties.getProperty(key));
        }
        return patterns;
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public Project getProject() {
        return this.project;
    }
}

