/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CodeFileFilter
implements FilenameFilter {
    boolean includePkgFiles;
    List patterns = null;

    public CodeFileFilter(List ignore, boolean includePkgFiles) {
        this.includePkgFiles = includePkgFiles;
        this.patterns = this.makePatterns(ignore);
    }

    private List makePatterns(List ignore) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        Iterator i = ignore.iterator();
        while (i.hasNext()) {
            String patternString = (String)i.next();
            try {
                Pattern p = Pattern.compile(patternString);
                patterns.add(p);
            }
            catch (PatternSyntaxException pse) {
                System.err.println("couldn't parse: " + patternString);
            }
        }
        return patterns;
    }

    private boolean matchesPatterns(String input) {
        Iterator i = this.patterns.iterator();
        while (i.hasNext()) {
            Pattern pattern = (Pattern)i.next();
            Matcher matcher = pattern.matcher(input);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        boolean result = true;
        if (name.equals("doc") || dir.getName().equals("doc")) {
            result = false;
        }
        if (name.equals("CVS") || dir.getName().equals("CVS")) {
            result = false;
        }
        if (name.equals("CVSROOT") || dir.getName().equalsIgnoreCase("CVSROOT")) {
            result = false;
        }
        if (!this.includePkgFiles && name.equals("bluej.pkg")) {
            result = false;
        }
        if (name.equals("bluej.pkh")) {
            result = false;
        }
        if (name.equals("team.defs")) {
            result = false;
        }
        if (name.equals(".DS_Store")) {
            result = false;
        }
        if (this.getFileType(name).equals("ctxt")) {
            result = false;
        }
        if (name.charAt(name.length() - 1) == '~') {
            result = false;
        }
        if (name.charAt(name.length() - 1) == '#') {
            result = false;
        }
        if (name.endsWith("#backup")) {
            result = false;
        }
        if (name.startsWith(".#")) {
            result = false;
        }
        if (this.matchesPatterns(name)) {
            result = false;
        }
        if (result) {
            // empty if block
        }
        return result;
    }

    private String getFileType(String filename) {
        int lastDotIndex = filename.lastIndexOf(46);
        if (lastDotIndex > -1 && lastDotIndex < filename.length()) {
            return filename.substring(lastDotIndex + 1);
        }
        return "";
    }
}

