/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.texteval;

import bluej.Config;
import bluej.debugmgr.texteval.TextEvalPane;
import bluej.pkgmgr.PkgMgrFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;

public final class TextEvalArea
extends JScrollPane
implements KeyListener,
FocusListener {
    private static final Color selectionColour = Config.getSelectionColour();
    private TextEvalPane text;

    public TextEvalArea(PkgMgrFrame frame, Font font) {
        this.createComponent(frame, font);
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
    }

    public void clear() {
        this.text.clear();
        this.text.clearVars();
    }

    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            this.setBorder(Config.focusBorder);
            this.repaint();
        }
    }

    public void focusLost(FocusEvent e) {
        this.setBorder(Config.normalBorder);
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        int DEL = 127;
        if (ch == '\b' || ch == '\t' || ch == '\u007f') {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private void createComponent(PkgMgrFrame frame, Font font) {
        this.text = new TextEvalPane(frame);
        this.text.setMargin(new Insets(2, 2, 2, 2));
        this.text.addKeyListener(this);
        this.text.addFocusListener(this);
        this.text.setFont(font);
        this.text.setSelectionColor(selectionColour);
        this.setViewportView(this.text);
        this.setVerticalScrollBarPolicy(22);
        this.setPreferredSize(new Dimension(300, 100));
    }
}

