/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.texteval;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DragAndDropHelper
implements MouseListener,
MouseMotionListener {
    private static final Image plusDragImage = Config.getImageAsIcon("image.eval.dragobject-plus").getImage();
    private static final Image noPlusDragImage = Config.getImageAsIcon("image.eval.dragobject-noplus").getImage();
    private static final int imageWidth = plusDragImage.getWidth(null);
    private static final int imageHeight = plusDragImage.getHeight(null);
    private static DragAndDropHelper instance;
    private PkgMgrFrame frame;
    private Component eventSource;
    private DragGlassPane glassPane;
    private ObjectBench target;
    private DebuggerObject object;
    private InvokerRecord invokerRecord;
    private boolean targetHiLightOn;
    private Image dragImage;
    private MouseMotionListener[] mml;

    public static DragAndDropHelper getInstance() {
        if (instance == null) {
            instance = new DragAndDropHelper();
        }
        return instance;
    }

    private DragAndDropHelper() {
    }

    public void startDrag(Component source, PkgMgrFrame frame, DebuggerObject object, InvokerRecord invokerRecord) {
        this.eventSource = source;
        this.frame = frame;
        this.target = frame.getObjectBench();
        this.glassPane = new DragGlassPane();
        frame.setGlassPane(this.glassPane);
        this.dragImage = noPlusDragImage;
        this.object = object;
        this.invokerRecord = invokerRecord;
        this.registerListeners();
        this.glassPane.setVisible(true);
    }

    private void stopDrag(int x, int y) {
        this.glassPane.setVisible(false);
        this.deregisterListeners();
        if (this.pointInTarget(x, y)) {
            this.frame.getPackage().getEditor().raisePutOnBenchEvent(this.target, this.object, this.object.getGenType(), this.invokerRecord);
        }
        this.target.showFocusHiLight(false);
    }

    private void checkTargetHiLight(int x, int y) {
        if (this.pointInTarget(x, y)) {
            if (!this.targetHiLightOn) {
                this.target.showFocusHiLight(true);
                this.dragImage = plusDragImage;
            }
        } else if (!this.targetHiLightOn) {
            this.target.showFocusHiLight(false);
            this.dragImage = noPlusDragImage;
        }
    }

    private boolean pointInTarget(int x, int y) {
        Point pt = SwingUtilities.convertPoint(this.eventSource, x, y, this.target);
        return this.target.contains(pt);
    }

    private void registerListeners() {
        this.eventSource.addMouseListener(this);
        this.mml = this.eventSource.getMouseMotionListeners();
        for (int i = 0; i < this.mml.length; ++i) {
            this.eventSource.removeMouseMotionListener(this.mml[i]);
        }
        this.eventSource.addMouseMotionListener(this);
    }

    private void deregisterListeners() {
        this.eventSource.removeMouseMotionListener(this);
        this.eventSource.removeMouseListener(this);
        for (int i = 0; i < this.mml.length; ++i) {
            this.eventSource.addMouseMotionListener(this.mml[i]);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (!evt.isPopupTrigger() && (evt.getModifiers() & 0x10) != 0) {
            int x = evt.getX();
            int y = evt.getY();
            this.checkTargetHiLight(x, y);
            Point pt = SwingUtilities.convertPoint(this.eventSource, x, y, this.glassPane);
            this.glassPane.setObjectLocation(pt);
            this.glassPane.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
        this.stopDrag(evt.getX(), evt.getY());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    class DragGlassPane
    extends JComponent {
        private Point objectLocation;

        DragGlassPane() {
        }

        protected void paintComponent(Graphics g) {
            if (this.objectLocation != null) {
                g.drawImage(DragAndDropHelper.this.dragImage, this.objectLocation.x - 30, this.objectLocation.y - 30, null);
            }
        }

        public void setObjectLocation(Point p) {
            this.objectLocation = p;
        }
    }
}

