/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiArray;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

public class JdiObject
extends DebuggerObject {
    static boolean jvmSupportsGenerics = Config.isJava15();
    ObjectReference obj;
    GenTypeClass genType = null;
    List fields;

    public static JdiObject getDebuggerObject(ObjectReference obj) {
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj);
        }
        return new JdiObject(obj);
    }

    public static JdiObject getDebuggerObject(ObjectReference obj, JavaType expectedType) {
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj, expectedType);
        }
        if (expectedType instanceof GenTypeClass) {
            return new JdiObject(obj, (GenTypeClass)expectedType);
        }
        return new JdiObject(obj);
    }

    public static JdiObject getDebuggerObject(ObjectReference obj, Field field, JdiObject parent) {
        if (!jvmSupportsGenerics) {
            return JdiObject.getDebuggerObject(obj);
        }
        JavaType expectedType = JdiReflective.fromField(field, parent);
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj, expectedType);
        }
        if (expectedType instanceof GenTypeClass) {
            return new JdiObject(obj, (GenTypeClass)expectedType);
        }
        return new JdiObject(obj);
    }

    protected JdiObject() {
    }

    private JdiObject(ObjectReference obj) {
        this.obj = obj;
        obj.disableCollection();
        this.getRemoteFields();
    }

    private JdiObject(ObjectReference obj, GenTypeClass expectedType) {
        this.obj = obj;
        obj.disableCollection();
        this.getRemoteFields();
        if (obj != null) {
            JdiReflective reflective = new JdiReflective(obj.referenceType());
            if (expectedType.isGeneric()) {
                this.genType = expectedType.mapToDerived(reflective);
            }
        }
    }

    protected void finalize() {
        this.obj.enableCollection();
    }

    public String toString() {
        return JdiUtils.getJdiUtils().getValueString(this.obj);
    }

    public String getClassName() {
        if (this.obj == null) {
            return "";
        }
        return this.obj.referenceType().name();
    }

    public String getGenClassName() {
        if (this.obj == null) {
            return "";
        }
        if (this.genType != null) {
            return this.genType.toString();
        }
        return this.getClassName();
    }

    public String getStrippedGenClassName() {
        if (this.obj == null) {
            return "";
        }
        if (this.genType != null) {
            return this.genType.toString(true);
        }
        return JavaNames.stripPrefix(this.getClassName());
    }

    private boolean isRaw() {
        if (JdiUtils.getJdiUtils().hasGenericSig(this.obj)) {
            if (this.genType == null) {
                return true;
            }
            return this.genType.isRaw();
        }
        return false;
    }

    public DebuggerClass getClassRef() {
        if (this.obj == null) {
            return null;
        }
        return new JdiClass(this.obj.referenceType());
    }

    public GenTypeClass getGenType() {
        if (this.genType != null) {
            return this.genType;
        }
        JdiReflective r = new JdiReflective(this.obj.referenceType());
        return new GenTypeClass(r);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNullObject() {
        return this.obj == null;
    }

    public int getStaticFieldCount() {
        return this.getFieldCount(true);
    }

    public int getInstanceFieldCount() {
        return this.getFieldCount(false);
    }

    public String getStaticFieldName(int slot) {
        return this.getField(true, slot).name();
    }

    public String getInstanceFieldName(int slot) {
        return this.getField(false, slot).name();
    }

    public DebuggerObject getStaticFieldObject(int slot) {
        Field field = this.getField(true, slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    public DebuggerObject getInstanceFieldObject(int slot) {
        Field field = this.getField(false, slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    public DebuggerObject getInstanceFieldObject(int slot, JavaType expectedType) {
        Field field = this.getField(false, slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, expectedType);
    }

    public DebuggerObject getFieldObject(int slot) {
        Field field = (Field)this.fields.get(slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    public DebuggerObject getFieldObject(int slot, JavaType expectedType) {
        Field field = (Field)this.fields.get(slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, expectedType);
    }

    public DebuggerObject getFieldObject(String name) {
        Field field = this.obj.referenceType().fieldByName(name);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    public String getFieldValueString(int slot) {
        Field field = (Field)this.fields.get(slot);
        Value val = this.obj.getValue(field);
        return JdiUtils.getJdiUtils().getValueString(val);
    }

    public String getFieldValueTypeString(int slot) {
        Field field = (Field)this.fields.get(slot);
        Value val = this.obj.getValue(field);
        return val.type().name();
    }

    public ObjectReference getObjectReference() {
        return this.obj;
    }

    public List getStaticFields(boolean includeModifiers) {
        return this.getFields(false, true, includeModifiers);
    }

    public List getInstanceFields(boolean includeModifiers) {
        return this.getFields(false, false, includeModifiers);
    }

    public List getAllFields(boolean includeModifiers) {
        return this.getFields(true, true, includeModifiers);
    }

    public boolean staticFieldIsPublic(int slot) {
        return this.getField(true, slot).isPublic();
    }

    public boolean instanceFieldIsPublic(int slot) {
        return this.getField(false, slot).isPublic();
    }

    public boolean staticFieldIsObject(int slot) {
        return this.checkFieldForObject(true, slot);
    }

    public boolean instanceFieldIsObject(int slot) {
        return this.checkFieldForObject(false, slot);
    }

    public boolean fieldIsObject(int slot) {
        Field field = (Field)this.fields.get(slot);
        Value val = this.obj.getValue(field);
        return val instanceof ObjectReference;
    }

    private int getFieldCount(boolean getStatic) {
        int count = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (this.checkIgnoreField(field) || field.isStatic() != getStatic) continue;
            ++count;
        }
        return count;
    }

    private List getFields(boolean getAll, boolean getStatic, boolean includeModifiers) {
        ArrayList<String> fieldStrings = new ArrayList<String>(this.fields.size());
        if (this.obj == null) {
            return fieldStrings;
        }
        ReferenceType cls = this.obj.referenceType();
        List<Field> visible = cls.visibleFields();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (this.checkIgnoreField(field) || !getAll && field.isStatic() != getStatic) continue;
            Value val = this.obj.getValue(field);
            String valString = JdiUtils.getJdiUtils().getValueString(val);
            String fieldString = "";
            if (includeModifiers) {
                if (field.isPrivate()) {
                    fieldString = "private ";
                }
                if (field.isProtected()) {
                    fieldString = "protected ";
                }
                if (field.isPublic()) {
                    fieldString = "public ";
                }
            }
            fieldString = jvmSupportsGenerics ? fieldString + JdiReflective.fromField(field, this).toString(true) : fieldString + JavaNames.stripPrefix(field.typeName());
            if (!visible.contains(field)) {
                fieldString = fieldString + " (hidden)";
            }
            fieldString = fieldString + " " + field.name() + " = " + valString;
            fieldStrings.add(fieldString);
        }
        return fieldStrings;
    }

    private Field getField(boolean getStatic, int slot) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (this.checkIgnoreField(field) || field.isStatic() != getStatic) continue;
            if (slot == 0) {
                return field;
            }
            --slot;
        }
        Debug.reportError("invalid slot in remote object");
        return null;
    }

    private boolean checkIgnoreField(Field f) {
        return f.name().indexOf(36) >= 0;
    }

    protected void getRemoteFields() {
        ReferenceType cls;
        if (this.obj != null && (cls = this.obj.referenceType()) != null) {
            this.fields = cls.allFields();
            return;
        }
        this.fields = new ArrayList();
    }

    private boolean checkFieldForObject(boolean getStatic, int slot) {
        Field field = this.getField(getStatic, slot);
        Value val = this.obj.getValue(field);
        return val instanceof ObjectReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JdiObject test = (JdiObject)o;
        return ((Object)this.obj).equals(test.obj);
    }

    public int hashCode() {
        return ((Object)this.obj).hashCode();
    }
}

