/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import [Ljava.lang.String;;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.JavacErrorWriter;
import bluej.compiler.WriterOutputStream;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;

class JavacCompilerInternal
extends Compiler {
    public JavacCompilerInternal() {
        this.setDebug(true);
        this.setDeprecation(true);
    }

    public boolean compile(File[] sources, CompileObserver watcher, boolean internal) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCompileOptions());
        for (int i = 0; i < sources.length; ++i) {
            args.add(sources[i].getPath());
        }
        int length = args.size();
        String[] params = new String[length];
        args.toArray(params);
        Class<?> compiler = null;
        Method compileMethod = null;
        boolean compileMethodTakesPrintWriter = false;
        try {
            compiler = Class.forName("com.sun.tools.javac.Main");
            if (compiler == null) {
                return false;
            }
            Class[] ppw = new Class[]{String;.class, PrintWriter.class};
            Class[] p = new Class[]{String;.class};
            try {
                compileMethod = compiler.getMethod("compile", ppw);
                compileMethodTakesPrintWriter = true;
            }
            catch (NoSuchMethodException nsme) {
                compileMethod = compiler.getMethod("compile", p);
            }
        }
        catch (ClassNotFoundException e) {
            Debug.message("com.sun.tools.javac.Main compiler is not available");
            return false;
        }
        catch (NoSuchMethodException e) {
            Debug.message("com.sun.tools.javac.Main compile method could not be found");
            return false;
        }
        if (compileMethod == null) {
            return false;
        }
        PrintStream systemErr = System.err;
        JavacErrorWriter output = new JavacErrorWriter(internal);
        WriterOutputStream outputS = null;
        if (!compileMethodTakesPrintWriter) {
            outputS = new WriterOutputStream(output);
            System.setErr(new PrintStream(outputS));
        }
        int result = 1;
        try {
            Object objResult;
            if (compileMethodTakesPrintWriter) {
                Object[] arguments = new Object[]{params, new PrintWriter(output)};
                objResult = compileMethod.invoke(compiler.newInstance(), arguments);
            } else {
                Object[] arguments = new Object[]{params};
                objResult = compileMethod.invoke(compiler.newInstance(), arguments);
            }
            result = (Integer)objResult;
        }
        catch (Throwable e) {
            System.setErr(systemErr);
            e.printStackTrace(System.out);
            return false;
        }
        if (!compileMethodTakesPrintWriter) {
            try {
                outputS.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            System.setErr(systemErr);
        }
        if (output.hasError()) {
            watcher.errorMessage(output.getFilename(), output.getLineNo(), output.getMessage());
        }
        if (output.hasWarnings()) {
            watcher.warningMessage(output.getFilename(), output.getLineNo(), output.getWarning());
        }
        return result == 0;
    }
}

