/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.JavacErrorWriter;
import bluej.utility.DialogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

class JavacCompiler
extends Compiler {
    private String executable;

    public JavacCompiler(String executable) {
        this.executable = executable;
        this.setDebug(true);
        this.setDeprecation(true);
    }

    public boolean compile(File[] sources, CompileObserver watcher, boolean internal) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable);
        args.addAll(this.getCompileOptions());
        for (int i = 0; i < sources.length; ++i) {
            args.add(sources[i].getPath());
        }
        int length = args.size();
        String[] params = new String[length];
        args.toArray(params);
        boolean result = false;
        try {
            result = this.executeCompiler(params, watcher, internal);
        }
        catch (Exception ioe) {
            DialogManager.showErrorWithText(null, "cannot-run-compiler", this.executable);
        }
        return result;
    }

    private boolean executeCompiler(String[] params, CompileObserver watcher, boolean internal) throws IOException, InterruptedException {
        String line;
        int processresult = 0;
        boolean readerror = false;
        Process compiler = Runtime.getRuntime().exec(params);
        BufferedReader d = new BufferedReader(new InputStreamReader(compiler.getErrorStream()));
        JavacErrorWriter output = new JavacErrorWriter(internal);
        while ((line = d.readLine()) != null) {
            output.write(line);
        }
        if (output.hasError()) {
            watcher.errorMessage(output.getFilename(), output.getLineNo(), output.getMessage());
        }
        if (output.hasWarnings()) {
            watcher.warningMessage(output.getFilename(), output.getLineNo(), output.getWarning());
        }
        return (processresult = compiler.waitFor()) == 0 && !readerror;
    }
}

