/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Properties;

public class PropParser {
    private static final int MAX_DEPTH = 10;

    public static String parsePropString(String value, Properties subvars) {
        StringBuffer outBuffer = new StringBuffer();
        PropParser.parsePropString(value, outBuffer, subvars, 0);
        return outBuffer.toString();
    }

    private static void parsePropString(String value, StringBuffer outBuffer, Properties subvars, int depth) {
        if (depth > 10) {
            outBuffer.append(value);
            return;
        }
        StringIter iter = new StringIter(value);
        while (iter.hasNext()) {
            char cc = iter.next();
            if (cc == '$') {
                if (iter.hasNext()) {
                    cc = iter.next();
                    if (cc == '$') {
                        outBuffer.append('$');
                        continue;
                    }
                    if (cc == '{') {
                        PropParser.processVar(iter, outBuffer, subvars, depth);
                        while (iter.hasNext() && (cc = iter.next()) != '}') {
                        }
                        continue;
                    }
                    iter.backup();
                    PropParser.processVar(iter, outBuffer, subvars, depth);
                    continue;
                }
                outBuffer.append('$');
                continue;
            }
            outBuffer.append(cc);
        }
    }

    private static boolean isNameChar(char cc) {
        if (Character.isWhitespace(cc)) {
            return false;
        }
        if (cc == '/' || cc == '\\' || cc == '{' || cc == '}' || cc == '\"' || cc == '$') {
            return false;
        }
        return cc != ',';
    }

    private static void processVar(StringIter iter, StringBuffer outBuffer, Properties subvars, int depth) {
        String varName;
        StringBuffer varNameBuf = new StringBuffer();
        while (iter.hasNext()) {
            char cc = iter.next();
            if (PropParser.isNameChar(cc)) {
                varNameBuf.append(cc);
                continue;
            }
            if (cc == '$' && iter.hasNext()) {
                cc = iter.next();
                varNameBuf.append(cc);
                continue;
            }
            iter.backup();
            break;
        }
        if ((varName = varNameBuf.toString()).equals("filePath")) {
            String arg = PropParser.processStringArg(iter, subvars, depth);
            if (arg != null) {
                File f = new File(arg);
                do {
                    if ((arg = PropParser.processStringArg(iter, subvars, depth)) == null) continue;
                    f = new File(f, arg);
                } while (arg != null);
                outBuffer.append(f.getAbsolutePath());
            }
        } else if (varName.equals("fileUrl")) {
            String arg = PropParser.processStringArg(iter, subvars, depth);
            if (arg != null) {
                File f = new File(arg);
                try {
                    String fileUrl = f.toURI().toURL().toString();
                    outBuffer.append(fileUrl);
                }
                catch (MalformedURLException mfue) {}
            }
        } else {
            String nval = subvars.getProperty(varName);
            if (nval != null) {
                PropParser.parsePropString(nval, outBuffer, subvars, depth + 1);
            }
        }
    }

    private static String processStringArg(StringIter iter, Properties subvars, int depth) {
        char cc;
        do {
            if (iter.hasNext()) continue;
            return null;
        } while (Character.isWhitespace(cc = iter.next()));
        if (cc == '}') {
            return null;
        }
        if (cc == '\"') {
            StringBuffer result = new StringBuffer();
            while (iter.hasNext() && (cc = iter.next()) != '\"') {
                result.append(cc);
            }
            return result.toString();
        }
        StringBuffer outBuffer = new StringBuffer();
        iter.backup();
        do {
            if ((cc = iter.next()) == '$' && iter.hasNext()) {
                cc = iter.next();
                if (Character.isWhitespace(cc) || cc == '}' || cc == '\"') {
                    outBuffer.append(cc);
                    continue;
                }
                if (cc == '{') {
                    PropParser.processVar(iter, outBuffer, subvars, depth);
                    while (iter.hasNext() && (cc = iter.next()) != '}') {
                    }
                    continue;
                }
                iter.backup();
                PropParser.processVar(iter, outBuffer, subvars, depth);
                continue;
            }
            if (Character.isWhitespace(cc) || cc == '}') {
                iter.backup();
                break;
            }
            if (cc == '\"') {
                while (iter.hasNext() && (cc = iter.next()) != '\"') {
                    outBuffer.append(cc);
                }
            } else {
                outBuffer.append(cc);
            }
        } while (iter.hasNext());
        return outBuffer.toString();
    }

    private static class StringIter {
        private String string;
        private int curpos;
        private int limit;

        StringIter(String string) {
            this.string = string;
            this.limit = string.length();
        }

        public boolean hasNext() {
            return this.curpos < this.limit;
        }

        public char next() {
            return this.string.charAt(this.curpos++);
        }

        public void backup() {
            --this.curpos;
        }

        public String remaining() {
            return this.string.substring(this.curpos - 1);
        }
    }
}

