/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BluejURLStreamHandlerFactory;
import bluej.Boot;
import bluej.Config;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.io.File;
import java.net.URL;
import java.util.Properties;

public class Main {
    private int FIRST_X_LOCATION = 20;
    private int FIRST_Y_LOCATION = 20;

    public Main() {
        String osname;
        Boot boot = Boot.getInstance();
        String[] args = boot.getArgs();
        Properties commandLineProps = boot.getCommandLineProperties();
        File bluejLibDir = boot.getBluejLibDir();
        Config.initialise(bluejLibDir, commandLineProps, boot.isGreenfoot());
        if (!Config.isGreenfoot()) {
            Config.setVMIconsName("vm.icns");
            Config.setVMDockName("BlueJ Virtual Machine");
        } else {
            Config.setVMIconsName("greenfootvm.icns");
            Config.setVMDockName("Greenfoot");
        }
        if (Config.getPropBoolean("bluej.windows.customUNCHandler") && (osname = System.getProperty("os.name", "")).startsWith("Windows")) {
            URL.setURLStreamHandlerFactory(new BluejURLStreamHandlerFactory());
        }
        this.processArgs(args);
    }

    private void processArgs(String[] args) {
        boolean openOrphans;
        boolean oneOpened = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Project openProj;
                if (args[i].startsWith("-") || (openProj = Project.openProject(args[i])) == null) continue;
                oneOpened = true;
                Package pkg = openProj.getPackage(openProj.getInitialPackageName());
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(pkg);
                pmf.setLocation(i * 30 + this.FIRST_X_LOCATION, i * 30 + this.FIRST_Y_LOCATION);
                pmf.setVisible(true);
            }
        }
        if (!oneOpened && (openOrphans = "true".equals(Config.getPropString("bluej.autoOpenLastProject"))) && PkgMgrFrame.hadOrphanPackages()) {
            String exists = "";
            int i = 1;
            while (exists != null) {
                Project openProj;
                exists = Config.getPropString("bluej.openPackage" + i, null);
                if (exists != null && (openProj = Project.openProject(exists)) != null) {
                    Package pkg = openProj.getPackage(openProj.getInitialPackageName());
                    PkgMgrFrame.createFrame(pkg);
                    oneOpened = true;
                }
                ++i;
            }
        }
        if (!oneOpened && !Config.isGreenfoot()) {
            this.openEmptyFrame();
        }
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)new ApplicationEvent(1));
    }

    private void openEmptyFrame() {
        PkgMgrFrame frame = PkgMgrFrame.createFrame();
        frame.setLocation(this.FIRST_X_LOCATION, this.FIRST_Y_LOCATION);
        frame.setVisible(true);
    }

    public static void exit() {
        if (PkgMgrFrame.frameCount() > 0) {
            Debug.reportError("Frame count was not zero when exiting. Work may not have been saved");
        }
        Config.handleExit();
        System.exit(0);
    }
}

