/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions.event;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BPackage;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.event.ExtensionEvent;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;

public class InvocationEvent
implements ExtensionEvent {
    public static final int UNKNOWN_EXIT = 0;
    public static final int NORMAL_EXIT = 1;
    public static final int FORCED_EXIT = 2;
    public static final int EXCEPTION_EXIT = 3;
    public static final int TERMINATED_EXIT = 4;
    private String className;
    private String objectName;
    private String methodName;
    private JavaType[] signature;
    private String[] parameters;
    private int invocationStatus = 0;
    private Package bluej_pkg;
    private DebuggerObject resultObj;

    public InvocationEvent(ExecutionEvent exevent) {
        String resultType = exevent.getResult();
        if (resultType == "Normal exit") {
            this.invocationStatus = 1;
        }
        if (resultType == "Forced exit") {
            this.invocationStatus = 2;
        }
        if (resultType == "An exception occurred") {
            this.invocationStatus = 3;
        }
        if (resultType == "User terminated") {
            this.invocationStatus = 4;
        }
        this.bluej_pkg = exevent.getPackage();
        this.className = exevent.getClassName();
        this.objectName = exevent.getObjectName();
        this.methodName = exevent.getMethodName();
        this.signature = exevent.getSignature();
        this.parameters = exevent.getParameters();
        this.resultObj = exevent.getResultObject();
    }

    public int getInvocationStatus() {
        return this.invocationStatus;
    }

    public BPackage getPackage() {
        return this.bluej_pkg.getBPackage();
    }

    public String getClassName() {
        return this.className;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getSignature() {
        if (this.signature == null) {
            return new Class[0];
        }
        Class[] risul = new Class[this.signature.length];
        for (int index = 0; index < this.signature.length; ++index) {
            JavaType sig = this.signature[index];
            if (sig.isPrimitive()) {
                if (sig == JavaPrimitiveType.getBoolean()) {
                    risul[index] = Boolean.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getByte()) {
                    risul[index] = Byte.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getChar()) {
                    risul[index] = Character.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getDouble()) {
                    risul[index] = Double.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getFloat()) {
                    risul[index] = Float.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getInt()) {
                    risul[index] = Integer.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getLong()) {
                    risul[index] = Long.TYPE;
                    continue;
                }
                if (sig != JavaPrimitiveType.getShort()) continue;
                risul[index] = Short.TYPE;
                continue;
            }
            String className = sig.asClass().rawName();
            risul[index] = this.bluej_pkg.getProject().loadClass(className);
        }
        return risul;
    }

    public String[] getParameters() {
        if (this.parameters == null) {
            return new String[0];
        }
        return this.parameters;
    }

    public Object getResult() {
        if (this.resultObj == null) {
            return null;
        }
        if (this.methodName != null) {
            return this.getMethodResult();
        }
        PkgMgrFrame pmf = PkgMgrFrame.findFrame((Package)this.bluej_pkg);
        ObjectWrapper wrapper = ObjectWrapper.getWrapper((PkgMgrFrame)pmf, (ObjectBench)pmf.getObjectBench(), (DebuggerObject)this.resultObj, (GenTypeClass)this.resultObj.getGenType(), (String)this.objectName);
        return ExtensionBridge.newBObject(wrapper);
    }

    private Object getMethodResult() {
        ObjectReference objRef = this.resultObj.getObjectReference();
        ReferenceType type = objRef.referenceType();
        Field thisField = type.fieldByName("result");
        if (thisField == null) {
            return null;
        }
        PkgMgrFrame aFrame = PkgMgrFrame.findFrame((Package)this.bluej_pkg);
        return ExtensionBridge.getVal(aFrame, "", objRef.getValue(thisField));
    }

    public String toString() {
        StringBuffer aRisul = new StringBuffer(500);
        aRisul.append("ResultEvent:");
        if (this.invocationStatus == 1) {
            aRisul.append(" NORMAL_EXIT");
        }
        if (this.invocationStatus == 2) {
            aRisul.append(" FORCED_EXIT");
        }
        if (this.invocationStatus == 3) {
            aRisul.append(" EXCEPTION_EXIT");
        }
        if (this.invocationStatus == 4) {
            aRisul.append(" TERMINATED_EXIT");
        }
        if (this.className != null) {
            aRisul.append(" BClass=" + this.className);
        }
        if (this.objectName != null) {
            aRisul.append(" objectName=" + this.objectName);
        }
        if (this.methodName != null) {
            aRisul.append(" methodName=" + this.methodName);
        }
        Object aResult = this.getResult();
        if (this.resultObj != null) {
            aRisul.append(" resultObj=" + aResult);
        }
        return aRisul.toString();
    }
}

