/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.Config;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionException;
import bluej.extensions.ExtensionUnloadedException;
import bluej.extensions.Identifier;
import bluej.extensions.MenuGenerator;
import bluej.extensions.PreferenceGenerator;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ApplicationListener;
import bluej.extensions.event.ClassEvent;
import bluej.extensions.event.ClassListener;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.CompileListener;
import bluej.extensions.event.ExtensionEvent;
import bluej.extensions.event.ExtensionEventListener;
import bluej.extensions.event.InvocationEvent;
import bluej.extensions.event.InvocationListener;
import bluej.extensions.event.PackageEvent;
import bluej.extensions.event.PackageListener;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionWrapper;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JMenuItem;

public final class BlueJ {
    private final ExtensionWrapper myWrapper;
    private final ExtensionPrefManager prefManager;
    private PreferenceGenerator currentPrefGen = null;
    private MenuGenerator currentMenuGen = null;
    private Properties localLabels;
    private ArrayList eventListeners;
    private ArrayList applicationListeners;
    private ArrayList packageListeners;
    private ArrayList compileListeners;
    private ArrayList invocationListeners;
    private ArrayList classListeners;

    BlueJ(ExtensionWrapper aWrapper, ExtensionPrefManager aPrefManager) {
        this.myWrapper = aWrapper;
        this.prefManager = aPrefManager;
        this.eventListeners = new ArrayList();
        this.applicationListeners = new ArrayList();
        this.packageListeners = new ArrayList();
        this.compileListeners = new ArrayList();
        this.invocationListeners = new ArrayList();
        this.classListeners = new ArrayList();
        this.localLabels = this.myWrapper.getLabelProperties();
    }

    public final BProject openProject(File directory) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        if (directory == null) {
            return null;
        }
        Project openProj = Project.openProject((String)directory.getAbsolutePath());
        if (openProj == null) {
            return null;
        }
        Package pkg = openProj.getCachedPackage(openProj.getInitialPackageName());
        if (pkg == null) {
            return null;
        }
        Identifier aProject = new Identifier(openProj, pkg);
        try {
            aProject.getPackageFrame();
        }
        catch (ExtensionException exc) {
            // empty catch block
        }
        return openProj.getBProject();
    }

    public BProject newProject(File directory) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String pathString = directory.getAbsolutePath();
        if (!pathString.endsWith(File.separator)) {
            pathString = pathString + File.separator;
        }
        if (!Project.createNewProject((String)pathString)) {
            return null;
        }
        return this.openProject(directory);
    }

    public BProject[] getOpenProjects() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        Collection projects = Project.getProjects();
        BProject[] result = new BProject[projects.size()];
        Iterator iter = projects.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Project prj = (Project)iter.next();
            result[index] = prj.getBProject();
            ++index;
        }
        return result;
    }

    public BPackage getCurrentPackage() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        PkgMgrFrame pmf = PkgMgrFrame.getMostRecent();
        if (pmf == null) {
            return null;
        }
        Package pkg = pmf.getPackage();
        if (pkg == null) {
            return null;
        }
        return pkg.getBPackage();
    }

    public Frame getCurrentFrame() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return PkgMgrFrame.getMostRecent();
    }

    public void setMenuGenerator(MenuGenerator menuGen) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentMenuGen = menuGen;
    }

    public MenuGenerator getMenuGenerator() {
        return this.currentMenuGen;
    }

    public void setPreferenceGenerator(PreferenceGenerator prefGen) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentPrefGen = prefGen;
        this.prefManager.panelRevalidate();
    }

    public PreferenceGenerator getPreferenceGenerator() {
        return this.currentPrefGen;
    }

    public File getSystemLibDir() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getBlueJLibDir();
    }

    public File getUserConfigDir() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getUserConfigDir();
    }

    public String getBlueJPropertyString(String property, String def) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getPropString((String)property, (String)def);
    }

    public String getExtensionPropertyString(String property, String def) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String thisKey = this.myWrapper.getSettingsString(property);
        return Config.getPropString((String)thisKey, (String)def);
    }

    public void setExtensionPropertyString(String property, String value) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String thisKey = this.myWrapper.getSettingsString(property);
        Config.putPropString((String)thisKey, (String)value);
    }

    public String getLabel(String key) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        if (this.localLabels == null) {
            return Config.getString((String)key, (String)key);
        }
        String aLabel = this.localLabels.getProperty(key, null);
        if (aLabel != null) {
            return aLabel;
        }
        return Config.getString((String)key, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionEventListener(ExtensionEventListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.eventListeners;
            synchronized (arrayList) {
                this.eventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionEventListener(ExtensionEventListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.eventListeners;
            synchronized (arrayList) {
                this.eventListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.applicationListeners;
            synchronized (arrayList) {
                this.applicationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(ApplicationListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.applicationListeners;
            synchronized (arrayList) {
                this.applicationListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackageListener(PackageListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.packageListeners;
            synchronized (arrayList) {
                this.packageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackageListener(PackageListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.packageListeners;
            synchronized (arrayList) {
                this.packageListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileListener(CompileListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.compileListeners;
            synchronized (arrayList) {
                this.compileListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileListener(CompileListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.compileListeners;
            synchronized (arrayList) {
                this.compileListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvocationListener(InvocationListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.invocationListeners;
            synchronized (arrayList) {
                this.invocationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvocationListener(InvocationListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.invocationListeners;
            synchronized (arrayList) {
                this.invocationListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassListener(ClassListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.classListeners;
            synchronized (arrayList) {
                this.classListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassListener(ClassListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.classListeners;
            synchronized (arrayList) {
                this.classListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateExtensionEvent(ExtensionEvent event) {
        ExtensionEventListener[] listeners;
        ArrayList arrayList = this.eventListeners;
        synchronized (arrayList) {
            listeners = this.eventListeners.toArray(new ExtensionEventListener[this.eventListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            ExtensionEventListener eventListener = listeners[i];
            eventListener.eventOccurred(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateApplicationEvent(ApplicationEvent event) {
        ApplicationListener[] listeners;
        ArrayList arrayList = this.applicationListeners;
        synchronized (arrayList) {
            listeners = this.applicationListeners.toArray(new ApplicationListener[this.applicationListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            ApplicationListener eventListener = listeners[i];
            eventListener.blueJReady(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegatePackageEvent(PackageEvent event) {
        PackageListener[] listeners;
        ArrayList arrayList = this.packageListeners;
        synchronized (arrayList) {
            listeners = this.packageListeners.toArray(new PackageListener[this.packageListeners.size()]);
        }
        int thisEvent = event.getEvent();
        for (int i = 0; i < listeners.length; ++i) {
            PackageListener eventListener = listeners[i];
            if (thisEvent == 1) {
                eventListener.packageOpened(event);
            }
            if (thisEvent != 2) continue;
            eventListener.packageClosing(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateCompileEvent(CompileEvent event) {
        CompileListener[] listeners;
        ArrayList arrayList = this.compileListeners;
        synchronized (arrayList) {
            listeners = this.compileListeners.toArray(new CompileListener[this.compileListeners.size()]);
        }
        int thisEvent = event.getEvent();
        for (int i = 0; i < listeners.length; ++i) {
            CompileListener eventListener = listeners[i];
            if (thisEvent == 1) {
                eventListener.compileStarted(event);
            }
            if (thisEvent == 3) {
                eventListener.compileError(event);
            }
            if (thisEvent == 2) {
                eventListener.compileWarning(event);
            }
            if (thisEvent == 5) {
                eventListener.compileFailed(event);
            }
            if (thisEvent != 4) continue;
            eventListener.compileSucceeded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateInvocationEvent(InvocationEvent event) {
        InvocationListener[] listeners;
        ArrayList arrayList = this.invocationListeners;
        synchronized (arrayList) {
            listeners = this.invocationListeners.toArray(new InvocationListener[this.invocationListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].invocationFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateClassEvent(ClassEvent event) {
        ClassListener[] listeners;
        ArrayList arrayList = this.classListeners;
        synchronized (arrayList) {
            listeners = this.classListeners.toArray(new ClassListener[this.classListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].classStateChanged(event);
        }
    }

    void delegateEvent(ExtensionEvent event) {
        this.delegateExtensionEvent(event);
        if (event instanceof ApplicationEvent) {
            this.delegateApplicationEvent((ApplicationEvent)event);
        } else if (event instanceof PackageEvent) {
            this.delegatePackageEvent((PackageEvent)event);
        } else if (event instanceof CompileEvent) {
            this.delegateCompileEvent((CompileEvent)event);
        } else if (event instanceof InvocationEvent) {
            this.delegateInvocationEvent((InvocationEvent)event);
        } else if (event instanceof ClassEvent) {
            this.delegateClassEvent((ClassEvent)event);
        }
    }

    JMenuItem getMenuItem(Object attachedObject) {
        if (this.currentMenuGen == null) {
            return null;
        }
        if (attachedObject == null) {
            JMenuItem anItem = this.currentMenuGen.getToolsMenuItem(null);
            if (anItem != null) {
                return anItem;
            }
            return this.currentMenuGen.getMenuItem();
        }
        if (attachedObject instanceof Package) {
            Package attachedPkg = (Package)attachedObject;
            Identifier anId = new Identifier(attachedPkg.getProject(), attachedPkg);
            return this.currentMenuGen.getToolsMenuItem(new BPackage(anId));
        }
        if (attachedObject instanceof ClassTarget) {
            ClassTarget aTarget = (ClassTarget)attachedObject;
            String qualifiedClassName = aTarget.getQualifiedName();
            Package attachedPkg = aTarget.getPackage();
            Identifier anId = new Identifier(attachedPkg.getProject(), attachedPkg, qualifiedClassName);
            return this.currentMenuGen.getClassMenuItem(new BClass(anId));
        }
        if (attachedObject instanceof ObjectWrapper) {
            ObjectWrapper aWrapper = (ObjectWrapper)attachedObject;
            return this.currentMenuGen.getObjectMenuItem(new BObject(aWrapper));
        }
        return null;
    }

    void postMenuItem(Object attachedObject, JMenuItem onThisItem) {
        if (this.currentMenuGen == null) {
            return;
        }
        if (attachedObject == null) {
            this.currentMenuGen.notifyPostToolsMenu(null, onThisItem);
            return;
        }
        if (attachedObject instanceof Package) {
            Package attachedPkg = (Package)attachedObject;
            Identifier anId = new Identifier(attachedPkg.getProject(), attachedPkg);
            this.currentMenuGen.notifyPostToolsMenu(new BPackage(anId), onThisItem);
        }
        if (attachedObject instanceof ClassTarget) {
            ClassTarget aTarget = (ClassTarget)attachedObject;
            String qualifiedClassName = aTarget.getQualifiedName();
            Package attachedPkg = aTarget.getPackage();
            Identifier anId = new Identifier(attachedPkg.getProject(), attachedPkg, qualifiedClassName);
            this.currentMenuGen.notifyPostClassMenu(new BClass(anId), onThisItem);
        }
        if (attachedObject instanceof ObjectWrapper) {
            ObjectWrapper aWrapper = (ObjectWrapper)attachedObject;
            this.currentMenuGen.notifyPostObjectMenu(new BObject(aWrapper), onThisItem);
        }
    }
}

