/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.extensions.BPackage;
import bluej.extensions.ExtensionException;
import bluej.extensions.Identifier;
import bluej.extensions.PackageAlreadyExistsException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import java.io.File;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ListIterator;

public class BProject {
    private Identifier projectId;

    BProject(Identifier i_projectId) {
        this.projectId = i_projectId;
    }

    public String getName() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        return thisProject.getProjectName();
    }

    public File getDir() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        return thisProject.getProjectDir();
    }

    public void save() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        thisProject.saveAll();
    }

    public void close() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        thisProject.saveAll();
        PkgMgrFrame.closeProject((Project)thisProject);
    }

    public BPackage newPackage(String fullyQualifiedName) throws ProjectNotOpenException, PackageAlreadyExistsException {
        Project bluejProject = this.projectId.getBluejProject();
        int risul = bluejProject.newPackage(fullyQualifiedName);
        if (risul == 2) {
            throw new IllegalArgumentException("newPackage: Bad package name '" + fullyQualifiedName + "'");
        }
        if (risul == 1) {
            throw new PackageAlreadyExistsException("newPackage: Package '" + fullyQualifiedName + "' already exists");
        }
        if (risul == 3) {
            throw new IllegalStateException("newPackage: Package '" + fullyQualifiedName + "' has no parent package");
        }
        if (risul != 0) {
            throw new IllegalStateException("newPackage: Unknown result code=" + risul);
        }
        Package pkg = bluejProject.getCachedPackage(fullyQualifiedName);
        if (pkg == null) {
            throw new IllegalStateException("newPackage: getPackage '" + fullyQualifiedName + "' returned null");
        }
        Package reloadPkg = pkg;
        for (int index = 0; index < 10 && reloadPkg != null; reloadPkg = reloadPkg.getParent(), ++index) {
            reloadPkg.reload();
        }
        return pkg.getBPackage();
    }

    public BPackage getPackage(String name) throws ProjectNotOpenException {
        Project bluejProject = this.projectId.getBluejProject();
        Package pkg = bluejProject.getCachedPackage(name);
        if (pkg == null) {
            return null;
        }
        return pkg.getBPackage();
    }

    public BPackage[] getPackages() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        List names = thisProject.getPackageNames();
        BPackage[] packages = new BPackage[names.size()];
        ListIterator li = names.listIterator();
        while (li.hasNext()) {
            int i = li.nextIndex();
            String name = (String)li.next();
            packages[i] = this.getPackage(name);
        }
        return packages;
    }

    public URLClassLoader getClassLoader() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        return thisProject.getClassLoader();
    }

    public String toString() {
        try {
            Project thisProject = this.projectId.getBluejProject();
            return "BProject: " + thisProject.getProjectName();
        }
        catch (ExtensionException exc) {
            return "BProject: INVALID";
        }
    }
}

