/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJLabel;
import bluej.GreenfootLabel;
import bluej.SplashLabel;
import bluej.SplashWindow;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 2;
    public static final int BLUEJ_VERSION_MINOR = 2;
    public static final int BLUEJ_VERSION_RELEASE = 0;
    public static final String BLUEJ_VERSION_SUFFIX = "";
    public static final String BLUEJ_VERSION = "2.2.0";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 2.2.0";
    public static String GREENFOOT_VERSION = "1.2.1";
    public static String GREENFOOT_API_VERSION = "1.2.0";
    private static Boot instance;
    private static String[] bluejJars;
    private static final int bluejBuildJars = 3;
    private static final String[] bluejUserJars;
    private static final int bluejUserBuildJars = 1;
    private static final String[] greenfootUserJars;
    private static final int greenfootUserBuildJars = 4;
    private static String[] runtimeJars;
    private static String[] userJars;
    private static int numBuildJars;
    private static int numUserBuildJars;
    private static boolean isGreenfoot;
    private Properties commandLineProps;
    private String[] args;
    private File javaHomeDir;
    private File bluejLibDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1 && "-version".equals(stringArray[0])) {
            System.out.println("BlueJ version 2.2.0 (Java version " + System.getProperty("java.version") + ")");
            System.out.println("--");
            System.out.println("virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            System.out.println("running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            System.exit(-1);
        }
        Properties properties = Boot.processCommandLineProperties(stringArray);
        isGreenfoot = properties.getProperty("greenfoot", "false").equals("true");
        SplashLabel splashLabel = null;
        if (isGreenfoot) {
            splashLabel = new GreenfootLabel();
            runtimeJars = greenfootUserJars;
            userJars = greenfootUserJars;
            numBuildJars = 4;
            numUserBuildJars = 4;
        } else {
            splashLabel = new BlueJLabel();
        }
        SplashWindow splashWindow = new SplashWindow(splashLabel);
        instance = new Boot(stringArray, properties);
        instance.bootBluej();
        splashWindow.dispose();
    }

    public static Boot getInstance() {
        return instance;
    }

    private Boot(String[] stringArray, Properties properties) {
        this.args = stringArray;
        this.commandLineProps = properties;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean isGreenfoot() {
        return isGreenfoot;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public File getBluejLibDir() {
        return this.bluejLibDir;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> clazz = Class.forName("bluej.Main", true, uRLClassLoader);
            clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        this.bluejLibDir = this.calculateBluejLibDir();
        try {
            this.runtimeClassPath = this.getKnownJars(this.bluejLibDir, runtimeJars, true, numBuildJars);
            this.runtimeUserClassPath = this.getKnownJars(this.bluejLibDir, userJars, false, numUserBuildJars);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private File calculateBluejLibDir() {
        File file = null;
        String string = this.getClass().getResource("Boot.class").toString();
        try {
            if (!string.startsWith("jar:")) {
                File file2;
                for (file2 = new File(new URI(string)).getParentFile(); file2 != null && !new File(file2.getParentFile(), "lib").isDirectory(); file2 = file2.getParentFile()) {
                }
                file = file2 == null ? null : new File(file2.getParentFile(), "lib");
            } else {
                int n = string.indexOf("!");
                String string2 = string.substring(4, n);
                File file3 = new File(new URI(string2));
                file = file3.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return file;
    }

    private URL[] getKnownJars(File file, String[] stringArray, boolean bl, int n) throws MalformedURLException {
        URL uRL;
        Object object;
        File file2;
        boolean bl2 = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int n2 = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (n != 0 && bl2 && (file2 = new File(file.getParentFile(), "classes")).isDirectory()) {
            arrayList.add(file2.toURI().toURL());
            if (isGreenfoot && (object = this.commandLineProps.getProperty("greenfootclassesdir")) != null) {
                file2 = new File((String)object);
                arrayList.add(file2.toURI().toURL());
            }
            n2 = n;
        }
        for (int i = n2; i < stringArray.length; ++i) {
            object = new File(file, stringArray[i]);
            if (!((File)object).canRead()) continue;
            arrayList.add(((File)object).toURI().toURL());
        }
        if (bl && (uRL = this.getToolsURL()) != null) {
            arrayList.add(uRL);
        }
        return arrayList.toArray(new URL[0]);
    }

    private URL getToolsURL() throws MalformedURLException {
        String string = System.getProperty("os.name", BLUEJ_VERSION_SUFFIX);
        if (string.startsWith("Mac")) {
            return null;
        }
        File file = new File(this.javaHomeDir, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        File file2 = this.javaHomeDir.getParentFile();
        file = new File(file2, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        System.err.println("class Boot: tools.jar not found. Potential problem for execution.");
        return null;
    }

    private static Properties processCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            if (!stringArray[i].startsWith("-") || (n = (string = stringArray[i].substring(1)).indexOf(61)) < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equals(BLUEJ_VERSION_SUFFIX) || string3.equals(BLUEJ_VERSION_SUFFIX)) continue;
            properties.put(string2, string3);
        }
        return properties;
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr.jar", "MRJ141Stubs.jar", "org-netbeans-lib-cvsclient.jar", "sshconnection.jar", "jsch.jar"};
        bluejUserJars = new String[]{"bluejcore.jar", "junit.jar"};
        greenfootUserJars = new String[]{"extensions" + File.separatorChar + "greenfoot.jar", "bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr.jar", "MRJ141Stubs.jar", "junit.jar", "bluej.jar"};
        runtimeJars = bluejJars;
        userJars = bluejUserJars;
        numBuildJars = 3;
        numUserBuildJars = 1;
        isGreenfoot = false;
    }
}

