/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class StatusInformation
extends FileInfoContainer {
    private File file;
    private FileStatus status;
    private String workingRevision;
    private String repositoryRevision;
    private String repositoryFileName;
    private String stickyDate;
    private String stickyOptions;
    private String stickyTag;
    private List tags;
    private StringBuffer symNamesBuffer;

    public StatusInformation() {
        this.setAllExistingTags(null);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileStatus getStatus() {
        return this.status;
    }

    public void setStatus(FileStatus status) {
        this.status = status;
    }

    public String getStatusString() {
        if (this.status == null) {
            return null;
        }
        return this.status.toString();
    }

    public void setStatusString(String statusString) {
        this.setStatus(FileStatus.getStatusForString(statusString));
    }

    public String getWorkingRevision() {
        return this.workingRevision;
    }

    public void setWorkingRevision(String workingRevision) {
        this.workingRevision = workingRevision;
    }

    public String getRepositoryRevision() {
        return this.repositoryRevision;
    }

    public void setRepositoryRevision(String repositoryRevision) {
        this.repositoryRevision = repositoryRevision;
    }

    public String getRepositoryFileName() {
        return this.repositoryFileName;
    }

    public void setRepositoryFileName(String repositoryFileName) {
        this.repositoryFileName = repositoryFileName;
    }

    public String getStickyTag() {
        return this.stickyTag;
    }

    public void setStickyTag(String stickyTag) {
        this.stickyTag = stickyTag;
    }

    public String getStickyDate() {
        return this.stickyDate;
    }

    public void setStickyDate(String stickyDate) {
        this.stickyDate = stickyDate;
    }

    public String getStickyOptions() {
        return this.stickyOptions;
    }

    public void setStickyOptions(String stickyOptions) {
        this.stickyOptions = stickyOptions;
    }

    public void addExistingTag(String tagName, String revisionNumber) {
        if (this.symNamesBuffer == null) {
            this.symNamesBuffer = new StringBuffer();
        }
        this.symNamesBuffer.append(tagName);
        this.symNamesBuffer.append(" ");
        this.symNamesBuffer.append(revisionNumber);
        this.symNamesBuffer.append("\n");
    }

    /*
     * Unable to fully structure code
     */
    private void createSymNames() {
        this.tags = new LinkedList<E>();
        if (this.symNamesBuffer == null) {
            return;
        }
        length = 0;
        lastLength = 0;
        ** GOTO lbl21
        {
            ++length;
            do {
                if (length < this.symNamesBuffer.length() && this.symNamesBuffer.charAt(length) != '\n') continue block0;
                if (length <= lastLength) continue;
                line = this.symNamesBuffer.substring(lastLength, length);
                symName = line.substring(0, line.indexOf(32));
                revisionNumber = line.substring(line.indexOf(32) + 1);
                newName = new SymName();
                newName.setTag(symName);
                newName.setRevision(revisionNumber);
                this.tags.add(newName);
                lastLength = length + 1;
                ++length;
lbl21:
                // 3 sources

            } while (length < this.symNamesBuffer.length());
        }
        this.symNamesBuffer = null;
    }

    public List getAllExistingTags() {
        if (this.tags == null) {
            this.createSymNames();
        }
        return this.tags;
    }

    public void setAllExistingTags(List tags) {
        this.tags = tags;
    }

    public List getSymNamesForRevision(String revNumber) {
        if (this.tags == null) {
            this.createSymNames();
        }
        LinkedList<SymName> list = new LinkedList<SymName>();
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            SymName item = (SymName)it.next();
            if (!item.getRevision().equals(revNumber)) continue;
            list.add(item);
        }
        return list;
    }

    public SymName getSymNameForTag(String tagName) {
        if (this.tags == null) {
            this.createSymNames();
        }
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            SymName item = (SymName)it.next();
            if (!item.getTag().equals(tagName)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nFile: ");
        buf.append(this.file != null ? this.file.getAbsolutePath() : "null");
        buf.append("\nStatus is: ");
        buf.append(this.getStatusString());
        buf.append("\nWorking revision: ");
        buf.append(this.workingRevision);
        buf.append("\nRepository revision: ");
        buf.append("\nSticky date: ");
        buf.append(this.stickyDate);
        buf.append("\nSticky options: ");
        buf.append(this.stickyOptions);
        buf.append("\nSticky tag: ");
        buf.append(this.stickyTag);
        if (this.tags != null && this.tags.size() > 0) {
            buf.append("\nExisting Tags:");
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                buf.append("\n  ");
                buf.append(it.next().toString());
            }
        }
        return buf.toString();
    }

    public static class SymName {
        private String tag;
        private String revision;

        public String getTag() {
            return this.tag;
        }

        public void setTag(String symName) {
            this.tag = symName;
        }

        public void setRevision(String rev) {
            this.revision = rev;
        }

        public String getRevision() {
            return this.revision;
        }

        public String toString() {
            return String.valueOf(this.getTag()) + " : " + this.getRevision();
        }
    }
}

