/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.remove;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.remove.RemoveBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public class RemoveCommand
extends BasicCommand {
    private boolean deleteBeforeRemove;
    private boolean ignoreLocallyExistingFiles;

    public boolean isDeleteBeforeRemove() {
        return this.deleteBeforeRemove;
    }

    public void setDeleteBeforeRemove(boolean deleteBeforeRemove) {
        this.deleteBeforeRemove = deleteBeforeRemove;
    }

    public boolean doesIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public boolean isIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public void setIgnoreLocallyExistingFiles(boolean ignoreLocallyExistingFiles) {
        this.ignoreLocallyExistingFiles = ignoreLocallyExistingFiles;
    }

    public Builder createBuilder(EventManager eventMan) {
        return new RemoveBuilder(eventMan, this);
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        if (this.files == null || this.files.length == 0) {
            throw new CommandException("No files have been specified for removal.", CommandException.getLocalMessage("RemoveCommand.noFilesSpecified", null));
        }
        client.ensureConnection();
        if (this.isDeleteBeforeRemove()) {
            this.removeAll(this.files);
        }
        super.execute(client, em);
        try {
            try {
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.REMOVE);
                client.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
        }
        finally {
            this.requests.clear();
        }
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        super.sendEntryAndModifiedRequests(entry, this.isIgnoreLocallyExistingFiles() ? null : file);
        if (entry.getRevision().equals("0")) {
            try {
                this.clientServices.removeEntry(file);
            }
            catch (IOException exc) {
                BugLog.getInstance().showException(exc);
            }
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("remove ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            int index = 0;
            while (index < files.length) {
                toReturn.append(String.valueOf(files[index].getName()) + " ");
                ++index;
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'f') {
            this.setDeleteBeforeRemove(true);
        } else {
            return false;
        }
        return true;
    }

    private void removeAll(File[] filesToDel) throws CommandException {
        if (filesToDel == null) {
            return;
        }
        int index = 0;
        while (index < filesToDel.length) {
            File file = filesToDel[index];
            if (file.exists() && file.isFile()) {
                if (!file.delete()) {
                    throw new CommandException("Cannot delete file " + file.getAbsolutePath(), CommandException.getLocalMessage("RemoveCommand.cannotDelete", new Object[]{file.getAbsolutePath()}));
                }
            } else if (this.isRecursive() && !file.getName().equalsIgnoreCase("CVS")) {
                this.removeAll(file.listFiles());
            }
            ++index;
        }
    }

    public String getOptString() {
        return "flR";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDeleteBeforeRemove(false);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isDeleteBeforeRemove()) {
            toReturn.append("-f ");
        }
        return toReturn.toString();
    }
}

