/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BObject;
import bluej.extensions.DirectInvoker;
import bluej.extensions.Identifier;
import bluej.extensions.InvocationArgumentException;
import bluej.extensions.InvocationErrorException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.CallableView;
import bluej.views.ConstructorView;

public class BConstructor {
    private Identifier parentId;
    private ConstructorView bluej_view;

    BConstructor(Identifier aParentId, ConstructorView i_view) {
        this.parentId = aParentId;
        this.bluej_view = i_view;
    }

    public boolean matches(Class[] parameter) {
        Class[] thisArgs = this.bluej_view.getParameters();
        if (thisArgs != null && thisArgs.length <= 0) {
            thisArgs = null;
        }
        if (parameter != null && parameter.length <= 0) {
            parameter = null;
        }
        if (thisArgs == null && parameter == null) {
            return true;
        }
        if (thisArgs == null || parameter == null) {
            return false;
        }
        if (thisArgs.length != parameter.length) {
            return false;
        }
        for (int index = 0; index < thisArgs.length; ++index) {
            if (thisArgs[index].isAssignableFrom(parameter[index])) continue;
            return false;
        }
        return true;
    }

    public Class[] getParameterTypes() {
        return this.bluej_view.getParameters();
    }

    public BObject newInstance(Object[] initargs) throws ProjectNotOpenException, PackageNotFoundException, InvocationArgumentException, InvocationErrorException {
        PkgMgrFrame pkgFrame = this.parentId.getPackageFrame();
        DirectInvoker invoker = new DirectInvoker(pkgFrame, (CallableView)this.bluej_view);
        DebuggerObject result = invoker.invokeConstructor(initargs);
        if (result == null) {
            return null;
        }
        String resultName = invoker.getResultName();
        PkgMgrFrame pmf = this.parentId.getPackageFrame();
        ObjectWrapper wrapper = ObjectWrapper.getWrapper((PkgMgrFrame)pmf, (ObjectBench)pmf.getObjectBench(), (DebuggerObject)result, (String)resultName);
        return new BObject(wrapper);
    }

    public String toString() {
        if (this.bluej_view != null) {
            return "BConstructor: " + this.bluej_view.getLongDesc();
        }
        return "BConstructor: ";
    }
}

