/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public abstract class SplashLabel
extends JComponent {
    private BufferedImage image;

    public SplashLabel(String string) {
        this.loadImage(string);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        if (this.image != null) {
            dimension.setSize(this.image.getWidth(), this.image.getHeight());
        }
        return dimension;
    }

    private void loadImage(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            System.out.println("cannot find splash image: " + string);
            return;
        }
        try {
            this.image = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

