/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJLabel;
import bluej.GreenfootLabel;
import bluej.SplashLabel;
import bluej.SplashWindow;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 2;
    public static final int BLUEJ_VERSION_MINOR = 1;
    public static final int BLUEJ_VERSION_RELEASE = 2;
    public static final String BLUEJ_VERSION_SUFFIX = "";
    public static final int BLUEJ_VERSION_NUMBER = 2102;
    public static final String BLUEJ_VERSION = "2.1.2";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 2.1.2";
    public static String GREENFOOT_VERSION = " 0.3.0";
    private static Boot instance;
    private static final int bluejBuildJars = 3;
    private static String[] bluejJars;
    private static String[] bluejUserJars;
    private static String[] greenfootUserJars;
    private static boolean isGreenfoot;
    private Properties commandLineProps;
    private String[] args;
    private File javaHomeDir;
    private File bluejLibDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1 && "-version".equals(stringArray[0])) {
            System.out.println("BlueJ version 2.1.2 (Java version " + System.getProperty("java.version") + ")");
            System.out.println("--");
            System.out.println("virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            System.out.println("running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            System.exit(-1);
        }
        Properties properties = Boot.processCommandLineProperties(stringArray);
        isGreenfoot = properties.getProperty("greenfoot", "false").equals("true");
        SplashLabel splashLabel = null;
        if (isGreenfoot) {
            splashLabel = new GreenfootLabel();
            bluejUserJars = greenfootUserJars;
        } else {
            splashLabel = new BlueJLabel();
        }
        SplashWindow splashWindow = new SplashWindow(splashLabel);
        instance = new Boot(stringArray, properties);
        instance.bootBluej();
        splashWindow.dispose();
    }

    public static Boot getInstance() {
        return instance;
    }

    private Boot(String[] stringArray, Properties properties) {
        this.args = stringArray;
        this.commandLineProps = properties;
    }

    public String[] getArgs() {
        return this.args;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public File getBluejLibDir() {
        return this.bluejLibDir;
    }

    public File getJunitLib() {
        File file = new File(this.bluejLibDir, "junit.jar");
        if (!file.canRead()) {
            throw new IllegalStateException("junit.jar is missing or unreadable");
        }
        return file;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> clazz = Class.forName("bluej.Main", true, uRLClassLoader);
            clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        this.bluejLibDir = this.calculateBluejLibDir();
        try {
            this.runtimeClassPath = this.getKnownJars(this.bluejLibDir, bluejJars, true);
            this.runtimeUserClassPath = this.getKnownJars(this.bluejLibDir, bluejUserJars, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private File calculateBluejLibDir() {
        File file = null;
        String string = this.getClass().getResource("Boot.class").getFile();
        int n = string.indexOf("!");
        String string2 = null;
        if (n < 0) {
            File file2;
            for (file2 = new File(string).getParentFile(); file2 != null && !new File(file2.getParentFile(), "lib").isDirectory(); file2 = file2.getParentFile()) {
            }
            file = file2 == null ? null : new File(file2.getParentFile(), "lib");
        } else {
            string2 = string.substring(0, n);
            string2 = this.getURLPath(string2);
            File file3 = new File(string2);
            file = file3.getParentFile();
        }
        return file;
    }

    private String getURLPath(String string) {
        if (!string.startsWith("file:")) {
            throw new IllegalStateException("Unexpected format of jar file URL (class Boot.java): " + string);
        }
        string = string.substring(5);
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private URL[] getKnownJars(File file, String[] stringArray, boolean bl) throws MalformedURLException {
        URL uRL;
        File file2;
        boolean bl2 = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int n = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if ((bl || isGreenfoot) && bl2 && (file2 = new File(file.getParentFile(), "classes")).isDirectory()) {
            arrayList.add(file2.toURI().toURL());
            n = 3;
        }
        for (int i = n; i < stringArray.length; ++i) {
            File file3 = new File(file, stringArray[i]);
            if (!file3.canRead()) {
                throw new IllegalStateException("required jar is missing or unreadable: " + file3);
            }
            arrayList.add(file3.toURI().toURL());
        }
        if (bl && (uRL = this.getToolsURL()) != null) {
            arrayList.add(uRL);
        }
        return arrayList.toArray(new URL[0]);
    }

    private boolean hasValidExtension(File file) {
        if (file == null) {
            return false;
        }
        if (file.getName().endsWith(".jar")) {
            return true;
        }
        return file.getName().endsWith(".zip");
    }

    private URL getToolsURL() throws MalformedURLException {
        String string = System.getProperty("os.name", BLUEJ_VERSION_SUFFIX);
        if (string.startsWith("Mac")) {
            return null;
        }
        File file = new File(this.javaHomeDir, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        File file2 = this.javaHomeDir.getParentFile();
        file = new File(file2, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        System.err.println("class Boot: tools.jar not found. Potential problem for execution.");
        return null;
    }

    private static Properties processCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            if (!stringArray[i].startsWith("-") || (n = (string = stringArray[i].substring(1)).indexOf(61)) < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equals(BLUEJ_VERSION_SUFFIX) || string3.equals(BLUEJ_VERSION_SUFFIX)) continue;
            properties.put(string2, string3);
        }
        return properties;
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr.jar", "MRJ141Stubs.jar"};
        bluejUserJars = new String[]{"bluejcore.jar", "junit.jar"};
        greenfootUserJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr.jar", "MRJ141Stubs.jar", "junit.jar", "bluej.jar"};
        isGreenfoot = false;
    }
}

