/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.utility.JavaUtils14;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class JavaUtils {
    private static JavaUtils jutils;

    public static JavaUtils getJavaUtils() {
        if (jutils != null) {
            return jutils;
        }
        if (Config.isJava15()) {
            try {
                Class<?> J15Class = Class.forName("bluej.utility.JavaUtils15");
                jutils = (JavaUtils)J15Class.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InstantiationException instantiationException) {}
        } else {
            jutils = new JavaUtils14();
        }
        return jutils;
    }

    public abstract String getSignature(Method var1);

    public abstract String getSignature(Constructor var1);

    public abstract String getShortDesc(Method var1, String[] var2);

    public abstract String getShortDesc(Method var1, String[] var2, Map var3);

    public abstract String getLongDesc(Method var1, String[] var2);

    public abstract String getLongDesc(Method var1, String[] var2, Map var3);

    public abstract String getShortDesc(Constructor var1, String[] var2);

    public abstract String getLongDesc(Constructor var1, String[] var2);

    public abstract boolean isVarArgs(Constructor var1);

    public abstract boolean isVarArgs(Method var1);

    public abstract boolean isSynthetic(Method var1);

    public abstract boolean isEnum(Class var1);

    public abstract JavaType getReturnType(Method var1);

    public abstract JavaType getRawReturnType(Method var1);

    public abstract JavaType getFieldType(Field var1);

    public abstract JavaType getRawFieldType(Field var1);

    public abstract List getTypeParams(Method var1);

    public abstract List getTypeParams(Constructor var1);

    public abstract List getTypeParams(Class var1);

    public abstract GenTypeClass getSuperclass(Class var1);

    public abstract GenTypeClass[] getInterfaces(Class var1);

    public abstract String[] getParameterTypes(Method var1);

    public abstract JavaType[] getParamGenTypes(Method var1, boolean var2);

    public abstract String[] getParameterTypes(Constructor var1);

    public abstract JavaType[] getParamGenTypes(Constructor var1);

    public static Map TParamsToMap(List tparams) {
        HashMap<String, JavaType> rmap = new HashMap<String, JavaType>();
        Iterator i = tparams.iterator();
        while (i.hasNext()) {
            GenTypeDeclTpar n = (GenTypeDeclTpar)i.next();
            rmap.put(n.getTparName(), n.getBound().mapTparsToTypes(rmap));
        }
        return rmap;
    }

    protected static String makeDescription(String name, String[] paramTypes, String[] paramNames, boolean includeTypeNames, boolean isVarArgs) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        for (int j = 0; j < paramTypes.length; ++j) {
            boolean typePrinted = false;
            if (isVarArgs && j == paramTypes.length - 1) {
                if (includeTypeNames || paramNames == null || paramNames[j] == null) {
                    sb.append(paramTypes[j].substring(0, paramTypes[j].length() - 2));
                    sb.append(" ");
                }
                sb.append("...");
                typePrinted = true;
            } else if (includeTypeNames || paramNames == null || paramNames[j] == null) {
                sb.append(paramTypes[j]);
                typePrinted = true;
            }
            if (paramNames != null && paramNames[j] != null) {
                if (typePrinted) {
                    sb.append(" ");
                }
                sb.append(paramNames[j]);
            }
            if (j >= paramTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

