/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.debugmgr.ConstructAction;
import bluej.debugmgr.objectbench.InvokeAction;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.ClassTarget;
import bluej.prefmgr.PrefMgr;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class ClassRole {
    public static final String CLASS_ROLE_NAME = null;
    private final Color defaultbg = Config.getItemColour("colour.class.bg.default");
    protected final Color envOpColour = Config.getItemColour("colour.menu.environOp");

    public String getRoleName() {
        return CLASS_ROLE_NAME;
    }

    public void save(Properties props, int modifiers, String prefix) {
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
    }

    public Color getBackgroundColour() {
        return this.defaultbg;
    }

    public String getStereotypeLabel() {
        return null;
    }

    public boolean generateSkeleton(String template, Package pkg, String name, String sourceFile) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("CLASSNAME", name);
        if (pkg.isUnnamedPackage()) {
            translations.put("PKGLINE", "");
        } else {
            translations.put("PKGLINE", "package " + pkg.getQualifiedName() + ";" + Config.nl + Config.nl);
        }
        try {
            File dest = new File(sourceFile);
            if (dest.exists()) {
                pkg.showError("duplicate-name");
                return false;
            }
            BlueJFileReader.translateFile(Config.getClassTemplateFile(template), new File(sourceFile), translations);
            return true;
        }
        catch (IOException e) {
            pkg.showError("skeleton-error");
            Debug.reportError("The default skeleton for the class could not be generated");
            Debug.reportError("Exception: " + e);
            return false;
        }
    }

    public void addMenuItem(JPopupMenu menu, Action action, boolean enabled) {
        JMenuItem item = new JMenuItem();
        item.setAction(action);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(this.envOpColour);
        item.setEnabled(enabled);
        menu.add(item);
    }

    public boolean createRoleMenu(JPopupMenu menu, ClassTarget ct, Class cl, int state) {
        return false;
    }

    public boolean createRoleMenuEnd(JPopupMenu menu, ClassTarget ct, int state) {
        return false;
    }

    public boolean createClassConstructorMenu(JPopupMenu menu, ClassTarget ct, Class cl) {
        View view = View.getView(cl);
        if (!Modifier.isAbstract(cl.getModifiers())) {
            ViewFilter filter = new ViewFilter(196613);
            CallableView[] constructors = view.getConstructors();
            if (ClassRole.createMenuItems(menu, constructors, filter, 0, constructors.length, "new ", ct)) {
                return true;
            }
        }
        return false;
    }

    public boolean createClassStaticMenu(JPopupMenu menu, ClassTarget ct, Class cl) {
        View view = View.getView(cl);
        ViewFilter filter = new ViewFilter(65549);
        CallableView[] allMethods = view.getAllMethods();
        return ClassRole.createMenuItems(menu, allMethods, filter, 0, allMethods.length, "", ct);
    }

    public static boolean createMenuItems(JPopupMenu menu, CallableView[] members, ViewFilter filter, int first, int last, String prefix, InvokeListener il) {
        boolean hasEntries = false;
        for (int i = first; i < last; ++i) {
            try {
                CallableView m = members[last - i - 1];
                if (!filter.accept(m)) continue;
                AbstractAction callAction = null;
                if (m instanceof MethodView) {
                    callAction = new InvokeAction((MethodView)m, il, prefix + m.getLongDesc());
                } else if (m instanceof ConstructorView) {
                    callAction = new ConstructAction((ConstructorView)m, il, prefix + m.getLongDesc());
                }
                if (callAction == null) continue;
                JMenuItem item = menu.add(callAction);
                item.setFont(PrefMgr.getPopupMenuFont());
                hasEntries = true;
                continue;
            }
            catch (Exception e) {
                Debug.reportError("Exception accessing methods: " + e);
                e.printStackTrace();
            }
        }
        return hasEntries;
    }

    public void prepareFilesForRemoval(ClassTarget ct, String sourceFile, String classFile, String contextFile) {
        File contextFileName;
        File classFileName;
        File sourceFileName = new File(sourceFile);
        if (sourceFileName.exists()) {
            sourceFileName.delete();
        }
        if ((classFileName = new File(classFile)).exists()) {
            classFileName.delete();
        }
        if ((contextFileName = new File(contextFile)).exists()) {
            contextFileName.delete();
        }
    }

    public void run(PkgMgrFrame pmf, ClassTarget ct, String param) {
    }
}

